/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.proto;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SubscriptionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SUBSCRIPTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/subscriptions/{subscription}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String subscription;

    @Deprecated
    protected SubscriptionName() {
        this.project = null;
        this.location = null;
        this.subscription = null;
    }

    private SubscriptionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.subscription = (String)Preconditions.checkNotNull((Object)builder.getSubscription());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SubscriptionName of(String project, String location, String subscription) {
        return SubscriptionName.newBuilder().setProject(project).setLocation(location).setSubscription(subscription).build();
    }

    public static String format(String project, String location, String subscription) {
        return SubscriptionName.newBuilder().setProject(project).setLocation(location).setSubscription(subscription).build().toString();
    }

    public static SubscriptionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SUBSCRIPTION.validatedMatch(formattedString, "SubscriptionName.parse: formattedString not in valid format");
        return SubscriptionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("subscription"));
    }

    public static List<SubscriptionName> parseList(List<String> formattedStrings) {
        ArrayList<SubscriptionName> list = new ArrayList<SubscriptionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SubscriptionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SubscriptionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SubscriptionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SUBSCRIPTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SubscriptionName subscriptionName = this;
            synchronized (subscriptionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.subscription != null) {
                        fieldMapBuilder.put((Object)"subscription", (Object)this.subscription);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SUBSCRIPTION.instantiate(new String[]{"project", this.project, "location", this.location, "subscription", this.subscription});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SubscriptionName that = (SubscriptionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.subscription, that.subscription);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.subscription);
    }

    public static class Builder {
        private String project;
        private String location;
        private String subscription;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSubscription() {
            return this.subscription;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        private Builder(SubscriptionName subscriptionName) {
            this.project = subscriptionName.project;
            this.location = subscriptionName.location;
            this.subscription = subscriptionName.subscription;
        }

        public SubscriptionName build() {
            return new SubscriptionName(this);
        }
    }
}

