/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.metrics.groups.SinkCommitterMetricGroup;
import org.apache.flink.streaming.api.connector.sink2.GlobalCommittableWrapper;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommittableCollector;
import org.apache.flink.streaming.runtime.operators.sink.committables.CommittableCollectorSerializer;
import org.apache.flink.streaming.runtime.operators.sink.committables.SinkV1CommittableDeserializer;
import org.apache.flink.util.Preconditions;

@Internal
class GlobalCommitterSerializer<CommT, GlobalCommT>
implements SimpleVersionedSerializer<GlobalCommittableWrapper<CommT, GlobalCommT>> {
    private static final int MAGIC_NUMBER = -1189141205;
    private final CommittableCollectorSerializer<CommT> committableCollectorSerializer;
    @Nullable
    private final SimpleVersionedSerializer<GlobalCommT> globalCommittableSerializer;
    private final int subtaskId;
    private final int numberOfSubtasks;
    private final SinkCommitterMetricGroup metricGroup;

    GlobalCommitterSerializer(CommittableCollectorSerializer<CommT> committableCollectorSerializer, @Nullable SimpleVersionedSerializer<GlobalCommT> globalCommittableSerializer, int subtaskId, int numberOfSubtasks, SinkCommitterMetricGroup metricGroup) {
        this.committableCollectorSerializer = (CommittableCollectorSerializer)Preconditions.checkNotNull(committableCollectorSerializer);
        this.globalCommittableSerializer = globalCommittableSerializer;
        this.subtaskId = subtaskId;
        this.numberOfSubtasks = numberOfSubtasks;
        this.metricGroup = metricGroup;
    }

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(GlobalCommittableWrapper<CommT, GlobalCommT> obj) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(256);
        out.writeInt(-1189141205);
        if (this.globalCommittableSerializer != null) {
            out.writeBoolean(true);
            Collection<GlobalCommT> globalCommittables = obj.getGlobalCommittables();
            SimpleVersionedSerialization.writeVersionAndSerializeList(this.globalCommittableSerializer, new ArrayList<GlobalCommT>(globalCommittables), (DataOutputView)out);
        } else {
            out.writeBoolean(false);
        }
        SimpleVersionedSerialization.writeVersionAndSerialize(this.committableCollectorSerializer, obj.getCommittableCollector(), (DataOutputView)out);
        return out.getCopyOfBuffer();
    }

    public GlobalCommittableWrapper<CommT, GlobalCommT> deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        if (version == 1) {
            if (this.globalCommittableSerializer == null) {
                throw new IllegalStateException("Tried to deserialize Sink V1 state without a GlobalCommittable serializer.");
            }
            return this.deserializeV1((DataInputView)in);
        }
        if (version == 2) {
            GlobalCommitterSerializer.validateMagicNumber((DataInputView)in);
            return this.deserializeV2((DataInputView)in);
        }
        throw new IllegalStateException("Unrecognized version or corrupt state: " + version);
    }

    private GlobalCommittableWrapper<CommT, GlobalCommT> deserializeV1(DataInputView in) throws IOException {
        List<GlobalCommT> globalCommittables = SinkV1CommittableDeserializer.readVersionAndDeserializeList(this.globalCommittableSerializer, in);
        return new GlobalCommittableWrapper(new CommittableCollector(this.subtaskId, this.numberOfSubtasks, this.metricGroup), globalCommittables);
    }

    private GlobalCommittableWrapper<CommT, GlobalCommT> deserializeV2(DataInputView in) throws IOException {
        List globalCommittables;
        boolean withGlobalCommittableSerializer = in.readBoolean();
        if (this.globalCommittableSerializer == null) {
            Preconditions.checkState((!withGlobalCommittableSerializer ? 1 : 0) != 0, (Object)"Trying to recover state from a GlobalCommittable serializer without specifying one.");
            globalCommittables = Collections.emptyList();
        } else {
            globalCommittables = SimpleVersionedSerialization.readVersionAndDeserializeList(this.globalCommittableSerializer, (DataInputView)in);
        }
        return new GlobalCommittableWrapper((CommittableCollector)SimpleVersionedSerialization.readVersionAndDeSerialize(this.committableCollectorSerializer, (DataInputView)in), globalCommittables);
    }

    private static void validateMagicNumber(DataInputView in) throws IOException {
        int magicNumber = in.readInt();
        if (magicNumber != -1189141205) {
            throw new IllegalStateException(String.format("Corrupt data: Unexpected magic number %08X", magicNumber));
        }
    }
}

