/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.core.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.neo4j.core.data.GraphPropertyData;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Relationship;

public class GraphRelationshipData {
    protected String id;
    protected String label;
    protected List<GraphPropertyData> properties;
    protected String sourceNodeId;
    protected String targetNodeId;
    protected String propertySetId;

    public GraphRelationshipData() {
        this.properties = new ArrayList<GraphPropertyData>();
    }

    public GraphRelationshipData(String id, String label, List<GraphPropertyData> properties, String nodeSource, String nodeTarget) {
        this.id = id;
        this.label = label;
        this.properties = properties;
        this.sourceNodeId = nodeSource;
        this.targetNodeId = nodeTarget;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof GraphRelationshipData)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return ((GraphRelationshipData)o).getId().equalsIgnoreCase(this.id);
    }

    public String toString() {
        return this.id == null ? super.toString() : this.id;
    }

    public GraphRelationshipData(GraphRelationshipData graphRelationship) {
        this();
        this.setId(graphRelationship.getId());
        this.setLabel(graphRelationship.getLabel());
        this.setSourceNodeId(graphRelationship.getSourceNodeId());
        this.setTargetNodeId(graphRelationship.getTargetNodeId());
        ArrayList<GraphPropertyData> properties = new ArrayList<GraphPropertyData>();
        for (GraphPropertyData property : graphRelationship.getProperties()) {
            properties.add(new GraphPropertyData(property.getId(), property.getValue(), property.getType(), property.isPrimary()));
        }
        this.setProperties(properties);
        this.setPropertySetId(graphRelationship.getPropertySetId());
    }

    public GraphRelationshipData(Relationship relationship) {
        this();
        this.setId(Long.toString(relationship.id()));
        this.setSourceNodeId(Long.toString(relationship.startNodeId()));
        this.setTargetNodeId(Long.toString(relationship.endNodeId()));
        this.setLabel(relationship.type());
        for (String propertyKey : relationship.keys()) {
            Value propertyValue = relationship.get(propertyKey);
            Object propertyObject = propertyValue.asObject();
            GraphPropertyDataType propertyType = GraphPropertyDataType.getTypeFromNeo4jValue(propertyObject);
            this.properties.add(new GraphPropertyData(propertyKey, propertyObject, propertyType, false));
        }
    }

    public JSONObject toJson() {
        JSONObject jRelationship = new JSONObject();
        jRelationship.put((Object)"id", (Object)this.id);
        jRelationship.put((Object)"label", (Object)this.label);
        jRelationship.put((Object)"sourceNodeId", (Object)this.sourceNodeId);
        jRelationship.put((Object)"targetNodeId", (Object)this.targetNodeId);
        if (!this.properties.isEmpty()) {
            JSONArray jProperties = new JSONArray();
            jRelationship.put((Object)"properties", (Object)jProperties);
            for (GraphPropertyData property : this.properties) {
                jProperties.add(property.toJson());
            }
        }
        jRelationship.put((Object)"property_set", (Object)this.propertySetId);
        return jRelationship;
    }

    public GraphRelationshipData(JSONObject jRelationship) {
        this();
        this.id = (String)jRelationship.get((Object)"id");
        this.label = (String)jRelationship.get((Object)"label");
        this.sourceNodeId = (String)jRelationship.get((Object)"sourceNodeId");
        this.targetNodeId = (String)jRelationship.get((Object)"targetNodeId");
        JSONArray jProperties = (JSONArray)jRelationship.get((Object)"properties");
        if (jProperties != null) {
            for (int i = 0; i < jProperties.size(); ++i) {
                JSONObject jProperty = (JSONObject)jProperties.get(i);
                this.properties.add(new GraphPropertyData(jProperty));
            }
        }
        this.propertySetId = (String)jRelationship.get((Object)"property_set");
    }

    public GraphRelationshipData clone() {
        return new GraphRelationshipData(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<GraphPropertyData> getProperties() {
        return this.properties;
    }

    public void setProperties(List<GraphPropertyData> properties) {
        this.properties = properties;
    }

    public String getSourceNodeId() {
        return this.sourceNodeId;
    }

    public void setSourceNodeId(String sourceNodeId) {
        this.sourceNodeId = sourceNodeId;
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public void setTargetNodeId(String targetNodeId) {
        this.targetNodeId = targetNodeId;
    }

    public String getPropertySetId() {
        return this.propertySetId;
    }

    public void setPropertySetId(String propertySetId) {
        this.propertySetId = propertySetId;
    }
}

