/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.implementation.CustomClaimRequest;
import com.azure.identity.implementation.IdentityClientBase;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IntelliJAuthMethodDetails;
import com.azure.identity.implementation.IntelliJCacheAccessor;
import com.azure.identity.implementation.MSIToken;
import com.azure.identity.implementation.ManagedIdentityParameters;
import com.azure.identity.implementation.ManagedIdentityType;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.PowershellManager;
import com.azure.identity.implementation.SynchronizedAccessor;
import com.azure.identity.implementation.VisualStudioCacheAccessor;
import com.azure.identity.implementation.util.IdentitySslUtil;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.LoggingUtil;
import com.azure.identity.implementation.util.ScopeUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.aad.msal4j.AppTokenProviderParameters;
import com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.RefreshTokenParameters;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.TokenProviderResult;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.sun.jna.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class IdentityClient
extends IdentityClientBase {
    private final SynchronizedAccessor<PublicClientApplication> publicClientApplicationAccessor = new SynchronizedAccessor(() -> this.getPublicClientApplication(isSharedTokenCacheCredential));
    private final SynchronizedAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessor = new SynchronizedAccessor(this::getConfidentialClientApplication);
    private final SynchronizedAccessor<ConfidentialClientApplication> managedIdentityConfidentialClientApplicationAccessor = new SynchronizedAccessor(this::getManagedIdentityConfidentialClientApplication);
    private final SynchronizedAccessor<ConfidentialClientApplication> workloadIdentityConfidentialClientApplicationAccessor = new SynchronizedAccessor(this::getWorkloadIdentityConfidentialClientApplication);
    private final SynchronizedAccessor<String> clientAssertionAccessor;

    IdentityClient(String tenantId, String clientId, String clientSecret, String certificatePath, String clientAssertionFilePath, String resourceId, Supplier<String> clientAssertionSupplier, InputStream certificate, String certificatePassword, boolean isSharedTokenCacheCredential, Duration clientAssertionTimeout, IdentityClientOptions options) {
        super(tenantId, clientId, clientSecret, certificatePath, clientAssertionFilePath, resourceId, clientAssertionSupplier, certificate, certificatePassword, isSharedTokenCacheCredential, clientAssertionTimeout, options);
        Duration cacheTimeout = clientAssertionTimeout == null ? Duration.ofMinutes(5L) : clientAssertionTimeout;
        this.clientAssertionAccessor = new SynchronizedAccessor(this::parseClientAssertion, cacheTimeout);
    }

    private Mono<ConfidentialClientApplication> getConfidentialClientApplication() {
        return Mono.defer(() -> {
            try {
                return Mono.just((Object)this.getConfidentialClient());
            }
            catch (RuntimeException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getManagedIdentityConfidentialClientApplication() {
        return Mono.defer(() -> {
            try {
                return Mono.just((Object)super.getManagedIdentityConfidentialClient());
            }
            catch (RuntimeException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getWorkloadIdentityConfidentialClientApplication() {
        return Mono.defer(() -> {
            try {
                return Mono.just((Object)super.getWorkloadIdentityConfidentialClient());
            }
            catch (RuntimeException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    @Override
    Mono<AccessToken> getTokenFromTargetManagedIdentity(TokenRequestContext tokenRequestContext) {
        ManagedIdentityParameters parameters = this.options.getManagedIdentityParameters();
        ManagedIdentityType managedIdentityType = this.options.getManagedIdentityType();
        switch (managedIdentityType) {
            case APP_SERVICE: {
                return this.authenticateToManagedIdentityEndpoint(parameters.getIdentityEndpoint(), parameters.getIdentityHeader(), parameters.getMsiEndpoint(), parameters.getMsiSecret(), tokenRequestContext);
            }
            case SERVICE_FABRIC: {
                return this.authenticateToServiceFabricManagedIdentityEndpoint(parameters.getIdentityEndpoint(), parameters.getIdentityHeader(), parameters.getIdentityServerThumbprint(), tokenRequestContext);
            }
            case ARC: {
                return this.authenticateToArcManagedIdentityEndpoint(parameters.getIdentityEndpoint(), tokenRequestContext);
            }
            case AKS: {
                return this.authenticateWithExchangeToken(tokenRequestContext);
            }
            case VM: {
                return this.authenticateToIMDSEndpoint(tokenRequestContext);
            }
        }
        return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("Unknown Managed Identity type, authentication not available."))));
    }

    private Mono<String> parseClientAssertion() {
        return Mono.fromCallable(() -> {
            if (this.clientAssertionFilePath != null) {
                byte[] encoded = Files.readAllBytes(Paths.get(this.clientAssertionFilePath, new String[0]));
                return new String(encoded, StandardCharsets.UTF_8);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Client Assertion File Path is not provided. It should be provided to authenticate with client assertion."));
        });
    }

    private Mono<PublicClientApplication> getPublicClientApplication(boolean sharedTokenCacheCredential) {
        return Mono.defer(() -> {
            try {
                return Mono.just((Object)this.getPublicClient(sharedTokenCacheCredential));
            }
            catch (RuntimeException e) {
                return Mono.error((Throwable)e);
            }
        });
    }

    public Mono<MsalToken> authenticateWithIntelliJ(TokenRequestContext request) {
        try {
            IntelliJAuthMethodDetails authDetails;
            IntelliJCacheAccessor cacheAccessor = new IntelliJCacheAccessor(this.options.getIntelliJKeePassDatabasePath());
            String cachedRefreshToken = cacheAccessor.getIntelliJCredentialsFromIdentityMsalCache();
            if (!CoreUtils.isNullOrEmpty((CharSequence)cachedRefreshToken)) {
                RefreshTokenParameters.RefreshTokenParametersBuilder refreshTokenParametersBuilder = RefreshTokenParameters.builder(new HashSet(request.getScopes()), (String)cachedRefreshToken);
                if (request.getClaims() != null) {
                    ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
                    refreshTokenParametersBuilder.claims(customClaimRequest);
                }
                return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture((CompletableFuture)pc.acquireToken(refreshTokenParametersBuilder.build())).map(MsalToken::new));
            }
            try {
                authDetails = cacheAccessor.getAuthDetailsIfAvailable();
            }
            catch (CredentialUnavailableException e) {
                return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("IntelliJ Authentication not available.", (Throwable)((Object)e)))));
            }
            if (authDetails == null) {
                return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("IntelliJ Authentication not available. Please log in with Azure Tools for IntelliJ plugin in the IDE."))));
            }
            String authType = authDetails.getAuthMethod();
            if ("SP".equalsIgnoreCase(authType)) {
                Map<String, String> spDetails = cacheAccessor.getIntellijServicePrincipalDetails(authDetails.getCredFilePath());
                String authorityUrl = spDetails.get("authURL") + spDetails.get("tenant");
                try {
                    ConfidentialClientApplication.Builder applicationBuilder = (ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)spDetails.get("client"), (IClientCredential)ClientCredentialFactory.createFromSecret((String)spDetails.get("key"))).authority(authorityUrl)).instanceDiscovery(this.options.isInstanceDiscoveryEnabled());
                    if (this.httpPipelineAdapter != null) {
                        applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
                    } else if (this.options.getProxyOptions() != null) {
                        applicationBuilder.proxy(IdentityClient.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
                    }
                    if (this.options.getExecutorService() != null) {
                        applicationBuilder.executorService(this.options.getExecutorService());
                    }
                    ConfidentialClientApplication application = applicationBuilder.build();
                    return Mono.fromFuture((CompletableFuture)application.acquireToken(ClientCredentialParameters.builder(new HashSet(request.getScopes())).build())).map(MsalToken::new);
                }
                catch (MalformedURLException e) {
                    return Mono.error((Throwable)e);
                }
            }
            if ("DC".equalsIgnoreCase(authType)) {
                LOGGER.verbose("IntelliJ Authentication => Device Code Authentication scheme detected in Azure Tools for IntelliJ Plugin.");
                if (this.isADFSTenant()) {
                    LOGGER.verbose("IntelliJ Authentication => The input tenant is detected to be ADFS and the ADFS tenants are not supported via IntelliJ Authentication currently.");
                    return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("IntelliJCredential  authentication unavailable. ADFS tenant/authorities are not supported."))));
                }
                try {
                    JsonNode intelliJCredentials = cacheAccessor.getDeviceCodeCredentials();
                    String refreshToken = intelliJCredentials.get("refreshToken").textValue();
                    RefreshTokenParameters.RefreshTokenParametersBuilder refreshTokenParametersBuilder = RefreshTokenParameters.builder(new HashSet(request.getScopes()), (String)refreshToken);
                    if (request.getClaims() != null) {
                        ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
                        refreshTokenParametersBuilder.claims(customClaimRequest);
                    }
                    return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture((CompletableFuture)pc.acquireToken(refreshTokenParametersBuilder.build())).map(MsalToken::new));
                }
                catch (CredentialUnavailableException e) {
                    return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, e)));
                }
            }
            LOGGER.verbose("IntelliJ Authentication = > Only Service Principal and Device Code Authentication schemes are currently supported via IntelliJ Credential currently. Please ensure you used one of those schemes from Azure Tools for IntelliJ plugin.");
            return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("IntelliJ Authentication not available. Please login with Azure Tools for IntelliJ plugin in the IDE."))));
        }
        catch (IOException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<AccessToken> authenticateWithAzureCli(TokenRequestContext request) {
        StringBuilder azCommand = new StringBuilder("az account get-access-token --output json --resource ");
        String scopes = ScopeUtil.scopesToResource(request.getScopes());
        try {
            ScopeUtil.validateScope(scopes);
        }
        catch (IllegalArgumentException ex) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)ex));
        }
        azCommand.append(scopes);
        try {
            String tenant = IdentityUtil.resolveTenantId(this.tenantId, request, this.options);
            if (!CoreUtils.isNullOrEmpty((CharSequence)tenant)) {
                azCommand.append(" --tenant ").append(tenant);
            }
        }
        catch (ClientAuthenticationException e) {
            return Mono.error((Throwable)e);
        }
        try {
            AccessToken token = this.getTokenFromAzureCLIAuthentication(azCommand);
            return Mono.just((Object)token);
        }
        catch (RuntimeException e) {
            return Mono.error((Throwable)(e instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)((Object)e)) : LOGGER.logExceptionAsError(e)));
        }
    }

    public Mono<AccessToken> authenticateWithAzureDeveloperCli(TokenRequestContext request) {
        StringBuilder azdCommand = new StringBuilder("azd auth token --output json --scope ");
        List scopes = request.getScopes();
        if (scopes.size() == 0) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing scope in request")));
        }
        azdCommand.append(String.join((CharSequence)" --scope ", scopes));
        try {
            String tenant = IdentityUtil.resolveTenantId(this.tenantId, request, this.options);
            if (!CoreUtils.isNullOrEmpty((CharSequence)tenant)) {
                azdCommand.append(" --tenant-id ").append(tenant);
            }
        }
        catch (ClientAuthenticationException e) {
            return Mono.error((Throwable)e);
        }
        try {
            AccessToken token = this.getTokenFromAzureDeveloperCLIAuthentication(azdCommand);
            return Mono.just((Object)token);
        }
        catch (RuntimeException e) {
            return Mono.error((Throwable)(e instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)((Object)e)) : LOGGER.logExceptionAsError(e)));
        }
    }

    public Mono<AccessToken> authenticateWithAzurePowerShell(TokenRequestContext request) {
        ArrayList exceptions = new ArrayList(2);
        PowershellManager defaultPowerShellManager = new PowershellManager(Platform.isWindows() ? "pwsh.exe" : "pwsh");
        PowershellManager legacyPowerShellManager = Platform.isWindows() ? new PowershellManager("powershell.exe") : null;
        ArrayList<PowershellManager> powershellManagers = new ArrayList<PowershellManager>(2);
        powershellManagers.add(defaultPowerShellManager);
        if (legacyPowerShellManager != null) {
            powershellManagers.add(legacyPowerShellManager);
        }
        return Flux.fromIterable(powershellManagers).flatMap(powershellManager -> this.getAccessTokenFromPowerShell(request, (PowershellManager)powershellManager).onErrorResume(t -> {
            if (!t.getClass().getSimpleName().equals("CredentialUnavailableException")) {
                return Mono.error((Throwable)new ClientAuthenticationException("Azure Powershell authentication failed. Error Details: " + t.getMessage() + ". To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/powershellcredential/troubleshoot", null, t));
            }
            exceptions.add((CredentialUnavailableException)((Object)((Object)((Object)t))));
            return Mono.empty();
        }), 1).next().switchIfEmpty(Mono.defer(() -> {
            CredentialUnavailableException last = (CredentialUnavailableException)((Object)((Object)exceptions.get(exceptions.size() - 1)));
            for (int z = exceptions.size() - 2; z >= 0; --z) {
                CredentialUnavailableException current = (CredentialUnavailableException)((Object)((Object)exceptions.get(z)));
                last = new CredentialUnavailableException("Azure PowerShell authentication failed using defaultpowershell(pwsh) with following error: " + current.getMessage() + "\r\nAzure PowerShell authentication failed using powershell-core(powershell) with following error: " + last.getMessage(), last.getCause());
            }
            return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, last)));
        }));
    }

    public Mono<AccessToken> authenticateWithOBO(TokenRequestContext request) {
        return this.confidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> confidentialClient.acquireToken(this.buildOBOFlowParameters(request))).map(MsalToken::new));
    }

    private Mono<AccessToken> getAccessTokenFromPowerShell(TokenRequestContext request, PowershellManager powershellManager) {
        return powershellManager.initSession().flatMap(manager -> {
            String azAccountsCommand = "Import-Module Az.Accounts -MinimumVersion 2.2.0 -PassThru";
            return manager.runCommand(azAccountsCommand).flatMap(output -> {
                if (output.contains("The specified module 'Az.Accounts' with version '2.2.0' was not loaded because no valid module file")) {
                    return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Az.Account module with version >= 2.2.0 is not installed. It needs to be installed to use Azure PowerShell Credential."))));
                }
                LOGGER.verbose("Az.accounts module was found installed.");
                String command = "Get-AzAccessToken -ResourceUrl " + ScopeUtil.scopesToResource(request.getScopes()) + " | ConvertTo-Json";
                LOGGER.verbose("Azure Powershell Authentication => Executing the command `{}` in Azure Powershell to retrieve the Access Token.", new Object[]{command});
                return manager.runCommand(command).flatMap(out -> {
                    if (out.contains("Run Connect-AzAccount to login")) {
                        return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Run Connect-AzAccount to login to Azure account in PowerShell."))));
                    }
                    try {
                        LOGGER.verbose("Azure Powershell Authentication => Attempting to deserialize the received response from Azure Powershell.");
                        Map objectMap = (Map)SERIALIZER_ADAPTER.deserialize(out, Map.class, SerializerEncoding.JSON);
                        String accessToken = (String)objectMap.get("Token");
                        String time = (String)objectMap.get("ExpiresOn");
                        OffsetDateTime expiresOn = OffsetDateTime.parse(time).withOffsetSameInstant(ZoneOffset.UTC);
                        return Mono.just((Object)new AccessToken(accessToken, expiresOn));
                    }
                    catch (IOException e) {
                        return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Encountered error when deserializing response from Azure Power Shell.", e))));
                    }
                });
            });
        }).doFinally(ignored -> powershellManager.close());
    }

    public Mono<AccessToken> authenticateWithConfidentialClient(TokenRequestContext request) {
        return this.confidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            if (this.clientAssertionSupplier != null) {
                builder.clientCredential((IClientCredential)ClientCredentialFactory.createFromClientAssertion((String)((String)this.clientAssertionSupplier.get())));
            }
            return confidentialClient.acquireToken(builder.build());
        })).map(MsalToken::new);
    }

    public Mono<AccessToken> authenticateWithManagedIdentityConfidentialClient(TokenRequestContext request) {
        return this.managedIdentityConfidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            return confidentialClient.acquireToken(builder.build());
        })).onErrorMap(t -> new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)t)).map(MsalToken::new);
    }

    public Mono<AccessToken> authenticateWithWorkloadIdentityConfidentialClient(TokenRequestContext request) {
        return this.workloadIdentityConfidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            return confidentialClient.acquireToken(builder.build());
        })).onErrorMap(t -> new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithUsernamePassword(TokenRequestContext request, String username, String password) {
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> {
            UserNamePasswordParameters.UserNamePasswordParametersBuilder userNamePasswordParametersBuilder = this.buildUsernamePasswordFlowParameters(request, username, password);
            return pc.acquireToken(userNamePasswordParametersBuilder.build());
        })).onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with username and password. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/usernamepasswordcredential/troubleshoot", null, t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithPublicClientCache(TokenRequestContext request, IAccount account) {
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> {
            SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet(request.getScopes()));
            if (request.getClaims() != null) {
                ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
                parametersBuilder.claims(customClaimRequest);
                parametersBuilder.forceRefresh(true);
            }
            if (account != null) {
                parametersBuilder = parametersBuilder.account(account);
            }
            parametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            try {
                return pc.acquireTokenSilently(parametersBuilder.build());
            }
            catch (MalformedURLException e) {
                return this.getFailedCompletableFuture(LOGGER.logExceptionAsError(new RuntimeException(e)));
            }
        }).map(MsalToken::new).filter(t -> OffsetDateTime.now().isBefore(t.getExpiresAt().minus(REFRESH_OFFSET))).switchIfEmpty(Mono.fromFuture(() -> {
            SilentParameters.SilentParametersBuilder forceParametersBuilder = SilentParameters.builder(new HashSet(request.getScopes())).forceRefresh(true);
            if (request.getClaims() != null) {
                ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
                forceParametersBuilder.claims(customClaimRequest);
            }
            if (account != null) {
                forceParametersBuilder = forceParametersBuilder.account(account);
            }
            forceParametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            try {
                return pc.acquireTokenSilently(forceParametersBuilder.build());
            }
            catch (MalformedURLException e) {
                return this.getFailedCompletableFuture(LOGGER.logExceptionAsError(new RuntimeException(e)));
            }
        }).map(MsalToken::new)));
    }

    public Mono<AccessToken> authenticateWithConfidentialClientCache(TokenRequestContext request) {
        return this.confidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            try {
                return confidentialClient.acquireTokenSilently(parametersBuilder.build());
            }
            catch (MalformedURLException e) {
                return this.getFailedCompletableFuture(LOGGER.logExceptionAsError(new RuntimeException(e)));
            }
        }).map(ar -> new MsalToken((IAuthenticationResult)ar)).filter(t -> OffsetDateTime.now().isBefore(t.getExpiresAt().minus(REFRESH_OFFSET))));
    }

    public Mono<MsalToken> authenticateWithDeviceCode(TokenRequestContext request, Consumer<DeviceCodeInfo> deviceCodeConsumer) {
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> {
            DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder parametersBuilder = this.buildDeviceCodeFlowParameters(request, deviceCodeConsumer);
            return pc.acquireToken(parametersBuilder.build());
        }).onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with device code.", null, t)).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithVsCodeCredential(TokenRequestContext request, String cloud) {
        if (this.isADFSTenant()) {
            return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("VsCodeCredential  authentication unavailable. ADFS tenant/authorities are not supported. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/vscodecredential/troubleshoot"))));
        }
        VisualStudioCacheAccessor accessor = new VisualStudioCacheAccessor();
        String credential = null;
        try {
            credential = accessor.getCredentials("VS Code Azure", cloud);
        }
        catch (CredentialUnavailableException e) {
            return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, e)));
        }
        RefreshTokenParameters.RefreshTokenParametersBuilder parametersBuilder = RefreshTokenParameters.builder(new HashSet(request.getScopes()), (String)credential);
        if (request.getClaims() != null) {
            ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(customClaimRequest);
        }
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture((CompletableFuture)pc.acquireToken(parametersBuilder.build())).onErrorResume(t -> {
            if (t instanceof MsalInteractionRequiredException) {
                return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Failed to acquire token with VS code credential. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/vscodecredential/troubleshoot", (Throwable)t))));
            }
            return Mono.error((Throwable)new ClientAuthenticationException("Failed to acquire token with VS code credential", null, t));
        }).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithAuthorizationCode(TokenRequestContext request, String authorizationCode, URI redirectUrl) {
        AuthorizationCodeParameters.AuthorizationCodeParametersBuilder parametersBuilder = AuthorizationCodeParameters.builder((String)authorizationCode, (URI)redirectUrl).scopes(new HashSet(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (request.getClaims() != null) {
            ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(customClaimRequest);
        }
        Mono acquireToken = this.clientSecret != null ? this.confidentialClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(parametersBuilder.build()))) : this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(parametersBuilder.build())));
        return acquireToken.onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with authorization code", null, t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithBrowserInteraction(TokenRequestContext request, Integer port, String redirectUrl, String loginHint) {
        URI redirectUri;
        String redirect = port != null ? "http://localhost:" + port : (redirectUrl != null ? redirectUrl : "http://localhost");
        try {
            redirectUri = new URI(redirect);
        }
        catch (URISyntaxException e) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError(new RuntimeException(e)));
        }
        InteractiveRequestParameters.InteractiveRequestParametersBuilder builder = this.buildInteractiveRequestParameters(request, loginHint, redirectUri);
        Mono acquireToken = this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(builder.build())));
        return acquireToken.onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with Interactive Browser Authentication.", null, t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithSharedTokenCache(TokenRequestContext request, String username) {
        return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(() -> ((PublicClientApplication)pc).getAccounts())).onErrorMap(t -> new CredentialUnavailableException("Cannot get accounts from token cache. Error: " + t.getMessage(), (Throwable)t)).flatMap(set -> {
            HashMap<String, IAccount> accounts = new HashMap<String, IAccount>();
            if (set.isEmpty()) {
                return Mono.error((Throwable)((Object)LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("SharedTokenCacheCredential authentication unavailable. No accounts were found in the cache."))));
            }
            for (IAccount cached : set) {
                if (username != null && !username.equals(cached.username())) continue;
                accounts.putIfAbsent(cached.homeAccountId(), cached);
            }
            if (accounts.isEmpty()) {
                return Mono.error((Throwable)new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. No account matching the specified username: %s was found in the cache.", username)));
            }
            if (accounts.size() > 1) {
                if (username == null) {
                    return Mono.error((Throwable)new RuntimeException("SharedTokenCacheCredential authentication unavailable. Multiple accounts were found in the cache. Use username and tenant id to disambiguate."));
                }
                return Mono.error((Throwable)new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. Multiple accounts matching the specified username: %s were found in the cache.", username)));
            }
            IAccount requestedAccount = (IAccount)accounts.values().iterator().next();
            return this.authenticateWithPublicClientCache(request, requestedAccount);
        });
    }

    private Mono<AccessToken> authenticateToArcManagedIdentityEndpoint(String identityEndpoint, TokenRequestContext request) {
        return Mono.fromCallable(() -> {
            HttpURLConnection connection = null;
            String payload = identityEndpoint + "?resource=" + IdentityClient.urlEncode(ScopeUtil.scopesToResource(request.getScopes())) + "&api-version=" + "2019-11-01";
            URL url = IdentityClient.getUrl(payload);
            String secretKey = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Metadata", "true");
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.connect();
            }
            catch (IOException e) {
                if (connection == null) {
                    throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException("Failed to initialize Http URL connection to the endpoint.", null, (Throwable)e)));
                }
                int status = connection.getResponseCode();
                if (status != 401) {
                    throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException(String.format("Expected a 401 Unauthorized response from Azure Arc Managed Identity Endpoint, received: %d", status), null, (Throwable)e)));
                }
                String realm = connection.getHeaderField("WWW-Authenticate");
                if (realm == null) {
                    throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException("Did not receive a value for WWW-Authenticate header in the response from Azure Arc Managed Identity Endpoint", null)));
                }
                int separatorIndex = realm.indexOf("=");
                if (separatorIndex == -1) {
                    throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException("Did not receive a correct value for WWW-Authenticate header in the response from Azure Arc Managed Identity Endpoint", null)));
                }
                String secretKeyPath = realm.substring(separatorIndex + 1);
                secretKey = new String(Files.readAllBytes(Paths.get(secretKeyPath, new String[0])), StandardCharsets.UTF_8);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            if (secretKey == null) {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new ClientAuthenticationException("Did not receive a secret value in the response from Azure Arc Managed Identity Endpoint", null)));
            }
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", "Basic " + secretKey);
                connection.setRequestProperty("Metadata", "true");
                connection.connect();
                AccessToken accessToken = (AccessToken)SERIALIZER_ADAPTER.deserialize(connection.getInputStream(), MSIToken.class, SerializerEncoding.JSON);
                return accessToken;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateWithExchangeToken(TokenRequestContext request) {
        return this.clientAssertionAccessor.getValue().flatMap(assertionToken -> Mono.fromCallable(() -> this.authenticateWithExchangeTokenHelper(request, (String)assertionToken)));
    }

    private Mono<AccessToken> authenticateToServiceFabricManagedIdentityEndpoint(String identityEndpoint, String identityHeader, String thumbprint, TokenRequestContext request) {
        return Mono.fromCallable(() -> {
            HttpURLConnection connection = null;
            String resource = ScopeUtil.scopesToResource(request.getScopes());
            StringBuilder payload = new StringBuilder(1024).append(identityEndpoint);
            payload.append("?resource=");
            payload.append(IdentityClient.urlEncode(resource));
            payload.append("&api-version=");
            payload.append("2019-07-01-preview");
            if (this.clientId != null) {
                LOGGER.warning("User assigned managed identities are not supported in the Service Fabric environment.");
                payload.append("&client_id=");
                payload.append(IdentityClient.urlEncode(this.clientId));
            }
            if (this.resourceId != null) {
                LOGGER.warning("User assigned managed identities are not supported in the Service Fabric environment.");
                payload.append("&mi_res_id=");
                payload.append(IdentityClient.urlEncode(this.resourceId));
            }
            try {
                URL url = IdentityClient.getUrl(payload.toString());
                connection = (HttpsURLConnection)url.openConnection();
                IdentitySslUtil.addTrustedCertificateThumbprint((HttpsURLConnection)connection, thumbprint, LOGGER);
                connection.setRequestMethod("GET");
                if (identityHeader != null) {
                    connection.setRequestProperty("Secret", identityHeader);
                }
                connection.setRequestProperty("Metadata", "true");
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.connect();
                AccessToken accessToken = (AccessToken)SERIALIZER_ADAPTER.deserialize(connection.getInputStream(), MSIToken.class, SerializerEncoding.JSON);
                return accessToken;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateToManagedIdentityEndpoint(String identityEndpoint, String identityHeader, String msiEndpoint, String msiSecret, TokenRequestContext request) {
        return Mono.fromCallable(() -> {
            String endpointVersion;
            String headerValue;
            String endpoint;
            if (identityEndpoint != null) {
                endpoint = identityEndpoint;
                headerValue = identityHeader;
                endpointVersion = "2019-08-01";
            } else {
                endpoint = msiEndpoint;
                headerValue = msiSecret;
                endpointVersion = "2017-09-01";
            }
            String resource = ScopeUtil.scopesToResource(request.getScopes());
            HttpURLConnection connection = null;
            StringBuilder payload = new StringBuilder(1024).append(endpoint);
            payload.append("?resource=");
            payload.append(IdentityClient.urlEncode(resource));
            payload.append("&api-version=");
            payload.append(URLEncoder.encode(endpointVersion, StandardCharsets.UTF_8.name()));
            if (this.clientId != null) {
                if (endpointVersion.equals("2019-08-01")) {
                    payload.append("&client_id=");
                } else {
                    if (headerValue == null) {
                        LOGGER.warning("User assigned managed identities are not supported in the Cloud Shell environment.");
                    }
                    payload.append("&clientid=");
                }
                payload.append(IdentityClient.urlEncode(this.clientId));
            }
            if (this.resourceId != null) {
                if (endpointVersion.equals("2017-09-01") && headerValue == null) {
                    LOGGER.warning("User assigned managed identities are not supported in the Cloud Shell environment.");
                }
                payload.append("&mi_res_id=");
                payload.append(IdentityClient.urlEncode(this.resourceId));
            }
            try {
                URL url = IdentityClient.getUrl(payload.toString());
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                if (headerValue != null) {
                    if ("2019-08-01".equals(endpointVersion)) {
                        connection.setRequestProperty("X-IDENTITY-HEADER", headerValue);
                    } else {
                        connection.setRequestProperty("Secret", headerValue);
                    }
                }
                connection.setRequestProperty("Metadata", "true");
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.connect();
                AccessToken accessToken = (AccessToken)SERIALIZER_ADAPTER.deserialize(connection.getInputStream(), MSIToken.class, SerializerEncoding.JSON);
                return accessToken;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateToIMDSEndpoint(TokenRequestContext request) {
        String resource = ScopeUtil.scopesToResource(request.getScopes());
        StringBuilder payload = new StringBuilder();
        int imdsUpgradeTimeInMs = 70000;
        try {
            payload.append("api-version=2018-02-01");
            payload.append("&resource=");
            payload.append(IdentityClient.urlEncode(resource));
            if (this.clientId != null) {
                payload.append("&client_id=");
                payload.append(IdentityClient.urlEncode(this.clientId));
            }
            if (this.resourceId != null) {
                payload.append("&mi_res_id=");
                payload.append(IdentityClient.urlEncode(this.resourceId));
            }
        }
        catch (IOException exception) {
            return Mono.error((Throwable)exception);
        }
        String endpoint = TRAILING_FORWARD_SLASHES.matcher(this.options.getImdsAuthorityHost()).replaceAll("") + "/metadata/identity/oauth2/token";
        return this.checkIMDSAvailable(endpoint).flatMap(available -> Mono.fromCallable(() -> {
            int retry = 1;
            while (retry <= this.options.getMaxRetry()) {
                URL url = null;
                HttpURLConnection connection = null;
                try {
                    url = IdentityClient.getUrl(endpoint + "?" + payload);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("Metadata", "true");
                    connection.setRequestProperty("User-Agent", this.userAgent);
                    connection.connect();
                    AccessToken accessToken = (AccessToken)SERIALIZER_ADAPTER.deserialize(connection.getInputStream(), MSIToken.class, SerializerEncoding.JSON);
                    return accessToken;
                }
                catch (IOException exception) {
                    int responseCode;
                    if (connection == null) {
                        throw LOGGER.logExceptionAsError(new RuntimeException("Could not connect to the url: " + url + ".", exception));
                    }
                    try {
                        responseCode = connection.getResponseCode();
                    }
                    catch (Exception e) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established, " + e.getMessage() + ".", e));
                    }
                    if (responseCode == 400) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established.", null));
                    }
                    if (responseCode == 410 || responseCode == 429 || responseCode == 404 || responseCode >= 500 && responseCode <= 599) {
                        int retryTimeoutInMs = this.options.getRetryTimeout().apply(Duration.ofSeconds(ThreadLocalRandom.current().nextInt(retry))).getNano() / 1000;
                        int n = retryTimeoutInMs = responseCode == 410 && retryTimeoutInMs < 70000 ? 70000 : retryTimeoutInMs;
                        if (++retry > this.options.getMaxRetry()) break;
                        IdentityClient.sleep(retryTimeoutInMs);
                        continue;
                    }
                    throw LOGGER.logExceptionAsError(new RuntimeException("Couldn't acquire access token from IMDS, verify your objectId, clientId or msiResourceId", exception));
                }
                finally {
                    if (connection == null) continue;
                    connection.disconnect();
                }
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(String.format("MSI: Failed to acquire tokens after retrying %s times", this.options.getMaxRetry())));
        }));
    }

    private Mono<Boolean> checkIMDSAvailable(String endpoint) {
        return Mono.fromCallable(() -> {
            HttpURLConnection connection = null;
            URL url = IdentityClient.getUrl(endpoint + "?api-version=2018-02-01");
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(500);
                connection.connect();
            }
            catch (Exception e) {
                throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established, " + e.getMessage() + ".", e));
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return true;
        });
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions options) {
        switch (options.getType()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, options.getAddress());
            }
        }
        return new Proxy(Proxy.Type.HTTP, options.getAddress());
    }

    void openUrl(String url) throws IOException {
        Runtime rt = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (os.contains("win")) {
            rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else if (os.contains("mac")) {
            rt.exec("open " + url);
        } else if (os.contains("nix") || os.contains("nux")) {
            rt.exec("xdg-open " + url);
        } else {
            LOGGER.error("Browser could not be opened - please open {} in a browser on this device.", new Object[]{url});
        }
    }

    private CompletableFuture<IAuthenticationResult> getFailedCompletableFuture(Exception e) {
        CompletableFuture<IAuthenticationResult> completableFuture = new CompletableFuture<IAuthenticationResult>();
        completableFuture.completeExceptionally(e);
        return completableFuture;
    }

    public IdentityClientOptions getIdentityClientOptions() {
        return this.options;
    }

    private boolean isADFSTenant() {
        return "adfs".equals(this.tenantId);
    }

    @Override
    Function<AppTokenProviderParameters, CompletableFuture<TokenProviderResult>> getWorkloadIdentityTokenProvider() {
        return appTokenProviderParameters -> {
            TokenRequestContext trc = new TokenRequestContext().setScopes(new ArrayList(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
            Mono<AccessToken> accessTokenAsync = this.authenticateWithExchangeToken(trc);
            return accessTokenAsync.map(accessToken -> {
                TokenProviderResult result = new TokenProviderResult();
                result.setAccessToken(accessToken.getToken());
                result.setTenantId(trc.getTenantId());
                result.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                return result;
            }).toFuture();
        };
    }
}

