/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fieldsplitter;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.fieldsplitter.FieldSplitterData;
import org.apache.hop.pipeline.transforms.fieldsplitter.FieldSplitterMeta;

public class FieldSplitter
extends BaseTransform<FieldSplitterMeta, FieldSplitterData> {
    private static final Class<?> PKG = FieldSplitterMeta.class;

    public FieldSplitter(TransformMeta transformMeta, FieldSplitterMeta meta, FieldSplitterData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] splitField(Object[] r) throws HopException {
        if (this.first) {
            this.first = false;
            ((FieldSplitterData)this.data).previousMeta = this.getInputRowMeta().clone();
            ((FieldSplitterData)this.data).fieldnr = ((FieldSplitterData)this.data).previousMeta.indexOfValue(((FieldSplitterMeta)this.meta).getSplitField());
            if (((FieldSplitterData)this.data).fieldnr < 0) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.CouldNotFindFieldToSplit", (String[])new String[]{((FieldSplitterMeta)this.meta).getSplitField()}));
            }
            if (!((FieldSplitterData)this.data).previousMeta.getValueMeta(((FieldSplitterData)this.data).fieldnr).isString()) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitFieldNotValid", (String[])new String[]{((FieldSplitterMeta)this.meta).getSplitField()}));
            }
            if (((FieldSplitterMeta)this.meta).getFields().isEmpty()) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitMetaNameNotValid", (String[])new String[0]));
            }
            ((FieldSplitterData)this.data).outputMeta = this.getInputRowMeta().clone();
            ((FieldSplitterMeta)this.meta).getFields(((FieldSplitterData)this.data).outputMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((FieldSplitterData)this.data).conversionMeta = ((FieldSplitterData)this.data).outputMeta.cloneToType(2);
            ((FieldSplitterData)this.data).delimiter = this.resolve(((FieldSplitterMeta)this.meta).getDelimiter());
            ((FieldSplitterData)this.data).enclosure = this.resolve(((FieldSplitterMeta)this.meta).getEnclosure());
            ((FieldSplitterData)this.data).escapeString = this.resolve(((FieldSplitterMeta)this.meta).getEscapeString());
        }
        Object[] outputRow = RowDataUtil.allocateRowData((int)((FieldSplitterData)this.data).outputMeta.size());
        int nrExtraFields = ((FieldSplitterMeta)this.meta).getFields().size() - 1;
        System.arraycopy(r, 0, outputRow, 0, ((FieldSplitterData)this.data).fieldnr);
        System.arraycopy(r, ((FieldSplitterData)this.data).fieldnr + 1, outputRow, ((FieldSplitterData)this.data).fieldnr + 1 + nrExtraFields, ((FieldSplitterData)this.data).previousMeta.size() - (((FieldSplitterData)this.data).fieldnr + 1));
        boolean selectFieldById = StringUtils.isNotEmpty((String)((FieldSplitterMeta)this.meta).getFields().get(0).getId());
        if (this.isDebug()) {
            if (selectFieldById) {
                this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.UsingIds", (String[])new String[0]));
            } else {
                this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.UsingPositionOfValue", (String[])new String[0]));
            }
        }
        String valueToSplit = ((FieldSplitterData)this.data).previousMeta.getString(r, ((FieldSplitterData)this.data).fieldnr);
        boolean removeEnclosure = this.getVariableBoolean("HOP_SPLIT_FIELDS_REMOVE_ENCLOSURE", false);
        String[] valueParts = Const.splitString((String)valueToSplit, (String)((FieldSplitterData)this.data).delimiter, (String)((FieldSplitterData)this.data).enclosure, (boolean)removeEnclosure, (String)((FieldSplitterData)this.data).escapeString);
        int prev = 0;
        for (int i = 0; i < ((FieldSplitterMeta)this.meta).getFields().size(); ++i) {
            Object value;
            FieldSplitterMeta.FSField field = ((FieldSplitterMeta)this.meta).getFields().get(i);
            String id = Const.NVL((String)field.getId(), (String)"");
            String rawValue = null;
            if (selectFieldById) {
                for (String part : valueParts) {
                    if (!part.startsWith(id)) continue;
                    if (field.isIdRemoved()) {
                        rawValue = part.substring(id.length());
                        break;
                    }
                    rawValue = part;
                    break;
                }
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitInfo", (String[])new String[0]) + rawValue);
                }
            } else {
                rawValue = valueParts == null || i >= valueParts.length ? null : valueParts[i];
                prev += (rawValue == null ? 0 : rawValue.length()) + ((FieldSplitterData)this.data).delimiter.length();
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitFieldsInfo", (String[])new String[]{rawValue, String.valueOf(prev)}));
                }
            }
            try {
                IValueMeta valueMeta = ((FieldSplitterData)this.data).outputMeta.getValueMeta(((FieldSplitterData)this.data).fieldnr + i);
                IValueMeta conversionValueMeta = ((FieldSplitterData)this.data).conversionMeta.getValueMeta(((FieldSplitterData)this.data).fieldnr + i);
                if (rawValue != null && valueMeta.isNull((Object)rawValue)) {
                    rawValue = null;
                }
                value = valueMeta.convertDataFromString(rawValue, conversionValueMeta, field.getNullIf(), field.getIfNull(), field.getTrimType().getType());
            }
            catch (Exception e) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.ErrorConvertingSplitValue", (String[])new String[]{rawValue, ((FieldSplitterMeta)this.meta).getSplitField() + "]!"}), (Throwable)e);
            }
            outputRow[((FieldSplitterData)this.data).fieldnr + i] = value;
        }
        return outputRow;
    }

    public synchronized boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        Object[] outputRowData = this.splitField(r);
        this.putRow(((FieldSplitterData)this.data).outputMeta, outputRowData);
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }
}

