/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data;

import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseCompression;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseInputStream;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.data.ClickHouseUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;

@Deprecated
public class ClickHouseFile
extends ClickHousePassThruStream {
    private static final long serialVersionUID = -2641191818870839568L;
    private static final String FILE_TYPE_NAME = "File";
    public static final ClickHouseFile NULL = new ClickHouseFile(null, ClickHouseCompression.NONE, -1, null);
    private final File file;

    public static ClickHouseFile of(File file) {
        return ClickHouseFile.of(file, null, -1, null);
    }

    public static ClickHouseFile of(Path path) {
        return ClickHouseFile.of(ClickHouseChecker.nonNull(path, "Path").toFile(), null, -1, null);
    }

    public static ClickHouseFile of(String file) {
        return ClickHouseFile.of(new File(ClickHouseChecker.nonEmpty(file, FILE_TYPE_NAME)), null, -1, null);
    }

    public static ClickHouseFile of(String file, ClickHouseCompression compression, ClickHouseFormat format) {
        return ClickHouseFile.of(file, compression, -1, format);
    }

    public static ClickHouseFile of(String file, ClickHouseCompression compression, int compressionLevel, ClickHouseFormat format) {
        return ClickHouseFile.of(new File(ClickHouseChecker.nonEmpty(file, FILE_TYPE_NAME)), compression, compressionLevel, format);
    }

    public static ClickHouseFile of(File file, ClickHouseCompression compression, ClickHouseFormat format) {
        return ClickHouseFile.of(file, compression, -1, format);
    }

    public static ClickHouseFile of(File file, ClickHouseCompression compression, int compressionLevel, ClickHouseFormat format) {
        String name = ClickHouseChecker.nonNull(file, FILE_TYPE_NAME).getName();
        return new ClickHouseFile(file, compression != null ? compression : ClickHouseCompression.fromFileName(name), compressionLevel, format != null ? format : ClickHouseFormat.fromFileName(name));
    }

    public static ClickHouseFile of(ClickHousePassThruStream stream) {
        if (stream instanceof ClickHouseFile) {
            return (ClickHouseFile)stream;
        }
        if (!stream.hasInput()) {
            throw new IllegalArgumentException("Pass-thru stream does not have input");
        }
        return ClickHouseFile.of(stream.getInputStream(), stream.getCompressionAlgorithm(), stream.getCompressionLevel(), stream.getFormat());
    }

    public static ClickHouseFile of(ClickHouseInputStream input, ClickHouseCompression compression, int compressionLevel, ClickHouseFormat format) {
        File tmp;
        ClickHousePassThruStream stream = ClickHouseChecker.nonNull(input, "InputStream").getUnderlyingStream();
        if (stream instanceof ClickHouseFile) {
            return (ClickHouseFile)stream;
        }
        boolean hasInput = stream.hasInput();
        try {
            tmp = ClickHouseUtils.createTempFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to create temporary file", e);
        }
        try (ClickHouseOutputStream out = ClickHouseOutputStream.of(new FileOutputStream(tmp));){
            (hasInput ? stream.getInputStream() : input).pipe(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return hasInput ? ClickHouseFile.of(tmp, stream.getCompressionAlgorithm(), stream.getCompressionLevel(), stream.getFormat()) : ClickHouseFile.of(tmp, compression, compressionLevel, format);
    }

    public static ClickHouseFile of(InputStream input, ClickHouseCompression compression, int compressionLevel, ClickHouseFormat format) {
        File tmp;
        if (ClickHouseChecker.nonNull(input, "InputStream") instanceof ClickHouseInputStream) {
            return ClickHouseFile.of((ClickHouseInputStream)input, compression, compressionLevel, format);
        }
        try {
            tmp = ClickHouseUtils.createTempFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to create temporary file", e);
        }
        try (ClickHouseOutputStream out = ClickHouseOutputStream.of(new FileOutputStream(tmp));){
            ClickHouseInputStream.of(input).pipe(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ClickHouseFile.of(tmp, compression, compressionLevel, format);
    }

    protected ClickHouseFile(File file, ClickHouseCompression compress, int compressLevel, ClickHouseFormat format) {
        super(null, null, compress, compressLevel, format);
        this.file = file;
    }

    @Override
    public ClickHouseInputStream getInputStream() {
        return ClickHouseInputStream.of(this.getFile());
    }

    @Override
    public ClickHouseInputStream newInputStream(int bufferSize, Runnable postCloseAction) {
        if (!this.hasInput()) {
            return ClickHouseInputStream.empty();
        }
        try {
            return ClickHouseInputStream.wrap(this, new FileInputStream(this.getFile()), bufferSize, ClickHouseCompression.NONE, this.getCompressionLevel(), postCloseAction);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ClickHouseOutputStream getOutputStream() {
        try {
            return ClickHouseOutputStream.of(new FileOutputStream(this.getFile()));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ClickHouseOutputStream newOutputStream(int bufferSize, Runnable postCloseAction) {
        if (!this.hasOutput()) {
            return ClickHouseOutputStream.empty();
        }
        try {
            return ClickHouseOutputStream.wrap(this, new FileOutputStream(this.getFile()), bufferSize, ClickHouseCompression.NONE, this.getCompressionLevel(), postCloseAction);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public boolean isRecognized() {
        return this.hasCompression() || this.hasFormat();
    }

    @Override
    public boolean hasInput() {
        return this.file != null && this.file.exists();
    }

    @Override
    public boolean hasOutput() {
        return this.file != null;
    }
}

