/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.opensearch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.anon.AnonymousPipelineResults;
import org.apache.hop.pipeline.anon.AnonymousPipelineRunner;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGridDataMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGridFieldMeta;
import org.apache.hop.pipeline.transforms.datagrid.DataGridMeta;
import org.apache.hop.pipeline.transforms.rest.RestMeta;
import org.apache.hop.pipeline.transforms.rest.fields.ResultField;

public class RestCaller {
    public static final String BODY_FIELD_NAME = "body";
    public static final String RESPONSE_FIELD_NAME = "response";
    public static final String STATUSCODE_FIELD_NAME = "code";
    public static final String INPUT_TRANSFORM_NAME = "INPUT";
    public static final String REST_TRANSFORM_NAME = "REST";
    private final IHopMetadataProvider metadataProvider;
    private final String url;
    private final String username;
    private final String password;
    private final String method;
    private final String body;
    private final Map<String, String> headers;
    private final boolean ignoreSsl;
    private String response;
    private Long statusCode;
    private String loggingText;
    private Result result;
    private IRowMeta restRowMeta;
    private Object[] restRowData;

    public RestCaller(IHopMetadataProvider metadataProvider, String url, String username, String password, String method, String body, boolean ignoreSsl, Map<String, String> headers) {
        this.metadataProvider = metadataProvider;
        this.url = url;
        this.username = username;
        this.password = password;
        this.method = method;
        this.body = body;
        this.ignoreSsl = ignoreSsl;
        this.headers = headers;
    }

    public String execute() throws HopException {
        try {
            IVariables variables = Variables.getADefaultVariableSpace();
            PipelineMeta pipelineMeta = new PipelineMeta();
            pipelineMeta.setName("RestCaller-execution");
            pipelineMeta.setDescription("OpenSearch Rest Caller");
            DataGridMeta gridMeta = new DataGridMeta();
            gridMeta.setDataGridFields(List.of(new DataGridFieldMeta("", "", "", BODY_FIELD_NAME, "String", "", -1, -1, Boolean.valueOf(false))));
            gridMeta.setDataLines(List.of(new DataGridDataMeta(Collections.singletonList(this.body))));
            TransformMeta gridTransformMeta = new TransformMeta(INPUT_TRANSFORM_NAME, (ITransformMeta)gridMeta);
            gridTransformMeta.setLocation(50, 100);
            pipelineMeta.addTransform(gridTransformMeta);
            RestMeta restMeta = new RestMeta();
            restMeta.setUrl(this.url);
            restMeta.setMethod(this.method);
            restMeta.setHttpLogin(this.username);
            restMeta.setHttpPassword(this.password);
            restMeta.setIgnoreSsl(this.ignoreSsl);
            restMeta.setBodyField(BODY_FIELD_NAME);
            restMeta.setApplicationType("JSON");
            restMeta.setResultField(new ResultField(RESPONSE_FIELD_NAME, STATUSCODE_FIELD_NAME, null, null));
            TransformMeta restTransformMeta = new TransformMeta(REST_TRANSFORM_NAME, (ITransformMeta)restMeta);
            restTransformMeta.setLocation(350, 100);
            pipelineMeta.addTransform(restTransformMeta);
            pipelineMeta.addPipelineHop(new PipelineHopMeta(gridTransformMeta, restTransformMeta));
            AnonymousPipelineResults results = AnonymousPipelineRunner.executePipeline((PipelineMeta)pipelineMeta, (IVariables)variables, (IHopMetadataProvider)this.metadataProvider, (String)REST_TRANSFORM_NAME);
            this.restRowMeta = results.getResultRowMeta();
            this.restRowData = results.getFirstResultRow();
            if (this.restRowMeta != null) {
                this.response = this.restRowMeta.getString(this.restRowData, RESPONSE_FIELD_NAME, null);
                this.statusCode = this.restRowMeta.getInteger(this.restRowData, STATUSCODE_FIELD_NAME, null);
            }
            this.result = results.getResult();
            this.loggingText = HopLogStore.getAppender().getBuffer(results.getPipeline().getLogChannelId(), false).toString();
            return this.response;
        }
        catch (Exception e) {
            throw new HopException("Error executing REST call to " + this.url, (Throwable)e);
        }
    }

    @Generated
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public boolean isIgnoreSsl() {
        return this.ignoreSsl;
    }

    @Generated
    public String getResponse() {
        return this.response;
    }

    @Generated
    public Long getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public String getLoggingText() {
        return this.loggingText;
    }

    @Generated
    public Result getResult() {
        return this.result;
    }

    @Generated
    public IRowMeta getRestRowMeta() {
        return this.restRowMeta;
    }

    @Generated
    public Object[] getRestRowData() {
        return this.restRowData;
    }
}

