/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfiguredYarnAuthorizer
extends YarnAuthorizationProvider {
    private final ConcurrentMap<PrivilegedEntity, Map<AccessType, AccessControlList>> allAcls = new ConcurrentHashMap<PrivilegedEntity, Map<AccessType, AccessControlList>>();
    private volatile AccessControlList adminAcl = null;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    @Override
    public void init(Configuration conf) {
        this.adminAcl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermission(List<Permission> permissions, UserGroupInformation user) {
        try {
            this.writeLock.lock();
            for (Permission perm : permissions) {
                this.allAcls.put(perm.getTarget(), perm.getAcls());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean checkPermissionInternal(AccessType accessType, PrivilegedEntity target, UserGroupInformation user) {
        AccessControlList list;
        boolean ret = false;
        Map acls = (Map)this.allAcls.get(target);
        if (acls != null && (list = (AccessControlList)acls.get((Object)accessType)) != null) {
            ret = list.isUserAllowed(user);
        }
        if (target.getType() == PrivilegedEntity.EntityType.QUEUE && !ret) {
            String queueName = target.getName();
            if (!queueName.contains(".")) {
                return ret;
            }
            String parentQueueName = queueName.substring(0, queueName.lastIndexOf("."));
            return this.checkPermissionInternal(accessType, new PrivilegedEntity(target.getType(), parentQueueName), user);
        }
        return ret;
    }

    @Override
    public boolean checkPermission(AccessRequest accessRequest) {
        try {
            this.readLock.lock();
            boolean bl = this.checkPermissionInternal(accessRequest.getAccessType(), accessRequest.getEntity(), accessRequest.getUser());
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setAdmins(AccessControlList acls, UserGroupInformation ugi) {
        this.adminAcl = acls;
    }

    @Override
    public boolean isAdmin(UserGroupInformation ugi) {
        return this.adminAcl.isUserAllowed(ugi);
    }

    public AccessControlList getAdminAcls() {
        return this.adminAcl;
    }
}

