/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.delegates.HopGuiDirectorySelectedExtension;

@ExtensionPoint(id="HopGuiDirectoryReplaceHomeVariable", extensionPointId="HopGuiDirectorySelected", description="Replace ${PROJECT_HOME} in selected directory as a best practice aid")
public class HopGuiDirectoryReplaceHomeVariable
implements IExtensionPoint<HopGuiDirectorySelectedExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, HopGuiDirectorySelectedExtension ext) {
        String projectName = HopNamespace.getNamespace();
        if (StringUtil.isEmpty((String)projectName)) {
            return;
        }
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        if (projectConfig == null) {
            return;
        }
        String homeFolder = variables != null ? variables.resolve(projectConfig.getProjectHome()) : projectConfig.getProjectHome();
        try {
            if (StringUtils.isNotEmpty((String)homeFolder)) {
                FileObject file = HopVfs.getFileObject((String)ext.folderName);
                String absoluteFile = file.getName().getPath();
                FileObject home = HopVfs.getFileObject((String)homeFolder);
                Object absoluteHome = home.getName().getPath();
                if (!((String)absoluteHome).endsWith("/")) {
                    absoluteHome = (String)absoluteHome + "/";
                }
                if (absoluteFile.startsWith((String)absoluteHome)) {
                    ext.folderName = "${PROJECT_HOME}/" + absoluteFile.substring(((String)absoluteHome).length());
                }
            }
        }
        catch (Exception e) {
            log.logError("Error setting default folder for project " + projectName, (Throwable)e);
        }
    }
}

