/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encode;
import org.owasp.encoder.Encoder;

class ChainedEncoder
extends Encoder {
    final Encoder _first;
    final Encoder _last;
    final CharBuffer _buffer = CharBuffer.allocate(1024);

    public ChainedEncoder(Encoder first, Encoder last) {
        this._first = first;
        this._last = last;
    }

    public String encode(String str) {
        int n;
        int j;
        if (str == null) {
            str = "null";
        }
        if ((j = this._first.firstEncodedOffset(str, 0, n = str.length())) == n) {
            return Encode.encode(this._last, str);
        }
        int remaining = n - j;
        int m = j + this._first.maxEncodedLength(n);
        CharBuffer input = CharBuffer.allocate(m);
        str.getChars(0, j, input.array(), 0);
        str.getChars(j, n, input.array(), m - remaining);
        input.limit(m).position(m - remaining);
        CharBuffer tmp = input.duplicate();
        tmp.position(j);
        CoderResult cr = this._first.encode(input, tmp, true);
        assert (cr.isUnderflow()) : "maxEncodedLength was incorrect";
        CharBuffer output = CharBuffer.allocate(this._last.maxEncodedLength(tmp.position()));
        tmp.flip();
        cr = this._last.encode(tmp, output, true);
        assert (cr.isUnderflow()) : "maxEncodedLength was incorrect";
        return new String(output.array(), 0, output.position());
    }

    protected int firstEncodedOffset(String input, int off, int len) {
        int i = this._first.firstEncodedOffset(input, off, len);
        return this._last.firstEncodedOffset(input, off, i - off);
    }

    protected int maxEncodedLength(int n) {
        return this._last.maxEncodedLength(this._first.maxEncodedLength(n));
    }

    public CoderResult encode(CharBuffer input, CharBuffer output, boolean endOfInput) {
        CoderResult cr2;
        CoderResult cr1;
        do {
            cr1 = this._first.encode(input, this._buffer, endOfInput);
            this._buffer.flip();
            cr2 = this._last.encode(this._buffer, output, endOfInput && cr1.isUnderflow());
            this._buffer.compact();
            if (!cr2.isOverflow()) continue;
            return cr2;
        } while (!cr1.isUnderflow());
        return cr2;
    }

    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        return this.encode(input, output, endOfInput);
    }

    public String toString() {
        return "[" + this._first + "," + this._last + "]";
    }
}

