/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.xml.bind.annotation.XmlRootElement;
import lombok.Generated;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.workflow.action.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlRootElement
public class ActionStatus {
    public static final String XML_TAG = "action_status";
    private String name;
    private Status status;
    private Result result;

    public ActionStatus() {
    }

    @JsonIgnore
    public String getXml() throws HopException {
        try {
            StringBuilder xml = new StringBuilder();
            xml.append(XmlHandler.openTag((String)XML_TAG));
            xml.append(XmlHandler.addTagValue((String)"name", (String)this.name));
            xml.append(XmlHandler.addTagValue((String)"status", (String)this.status.getCode()));
            if (this.result != null) {
                xml.append(this.result.getBasicXml());
            }
            xml.append(XmlHandler.closeTag((String)XML_TAG));
            return xml.toString();
        }
        catch (Exception e) {
            throw new HopException("Unable to serialize action '" + this.name + "' status data to XML", (Throwable)e);
        }
    }

    public ActionStatus(Node node) throws HopException {
        this.name = XmlHandler.getTagValue((Node)node, (String)"name");
        this.status = Status.lookupCode(XmlHandler.getTagValue((Node)node, (String)"status"));
        Node resultNode = XmlHandler.getSubNode((Node)node, (String)"result");
        if (resultNode != null) {
            this.result = new Result(resultNode);
        }
    }

    public ActionStatus fromXml(String xml) throws HopException {
        Document document = XmlHandler.loadXmlString((String)xml);
        return new ActionStatus(XmlHandler.getSubNode((Node)document, (String)XML_TAG));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public Result getResult() {
        return this.result;
    }

    @Generated
    public void setResult(Result result) {
        this.result = result;
    }
}

