/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="Pipeline Graph Check Delegate")
public class HopGuiPipelineCheckDelegate {
    private static final Class<?> PKG = HopGui.class;
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "HopGuiPipelineCheckDelegate-ToolBar";
    private static final String TOOLBAR_ITEM_COLLAPSE_ALL = "HopGuiPipelineCheckDelegate-Toolbar-10010-CollapseAll";
    private static final String TOOLBAR_ITEM_EXPAND_ALL = "HopGuiPipelineCheckDelegate-Toolbar-10020-ExpandAll";
    private final HopGui hopGui;
    private final HopGuiPipelineGraph pipelineGraph;
    private CTabItem pipelineCheckTab;
    private GuiToolbarWidgets toolBarWidgets;
    private Tree wTree;

    public HopGuiPipelineCheckDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
    }

    public static HopGuiPipelineCheckDelegate getInstance() {
        IHopFileTypeHandler fileTypeHandler = HopGui.getInstance().getActiveFileTypeHandler();
        if (fileTypeHandler instanceof HopGuiPipelineGraph) {
            HopGuiPipelineGraph graph = (HopGuiPipelineGraph)fileTypeHandler;
            return graph.pipelineCheckDelegate;
        }
        return null;
    }

    public void addPipelineCheck() {
        if (this.pipelineGraph.extraViewTabFolder == null || this.pipelineGraph.extraViewTabFolder.isDisposed()) {
            this.pipelineGraph.addExtraView();
        } else if (this.pipelineCheckTab != null && !this.pipelineCheckTab.isDisposed()) {
            return;
        }
        this.pipelineCheckTab = new CTabItem(this.pipelineGraph.extraViewTabFolder, 0);
        this.pipelineCheckTab.setFont(GuiResource.getInstance().getFontDefault());
        this.pipelineCheckTab.setImage(GuiResource.getInstance().getImageCheck());
        this.pipelineCheckTab.setText(BaseMessages.getString(PKG, (String)"PipelineGraph.Check.Tab.Name", (String[])new String[0]));
        Composite checkComposite = new Composite((Composite)this.pipelineGraph.extraViewTabFolder, 0);
        checkComposite.setLayout((Layout)new FormLayout());
        this.pipelineCheckTab.setControl((Control)checkComposite);
        ToolBar toolbar = new ToolBar(checkComposite, 16704);
        FormData fdToolBar = new FormData();
        fdToolBar.left = new FormAttachment(0, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        fdToolBar.right = new FormAttachment(100, 0);
        toolbar.setLayoutData((Object)fdToolBar);
        PropsUi.setLook((Widget)toolbar, 5);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)toolbar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        toolbar.pack();
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        toolbar.setLayoutData((Object)fd);
        this.wTree = new Tree(checkComposite, 768);
        PropsUi.setLook((Widget)this.wTree);
        FormData fdTree = new FormData();
        fdTree.top = new FormAttachment((Control)toolbar, 0);
        fdTree.left = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment(100, 0);
        this.wTree.setLayoutData((Object)fdTree);
        this.wTree.addListener(14, this::edit);
    }

    @GuiToolbarElement(root="HopGuiPipelineCheckDelegate-ToolBar", id="HopGuiPipelineCheckDelegate-Toolbar-10010-CollapseAll", toolTip="i18n::System.Tooltip.CollapseALl", image="ui/images/collapse-all.svg")
    public void collapseAll() {
        this.wTree.setRedraw(false);
        for (TreeItem item : this.wTree.getItems()) {
            item.setExpanded(false);
        }
        this.wTree.setRedraw(true);
    }

    @GuiToolbarElement(root="HopGuiPipelineCheckDelegate-ToolBar", id="HopGuiPipelineCheckDelegate-Toolbar-10020-ExpandAll", toolTip="i18n::System.Tooltip.ExpandAll", image="ui/images/expand-all.svg")
    public void expandAll() {
        this.wTree.setRedraw(false);
        for (TreeItem item : this.wTree.getItems()) {
            item.setExpanded(true);
        }
        this.wTree.setRedraw(true);
    }

    public void checkPipeline() {
        try {
            ArrayList<ICheckResult> remarks = new ArrayList<ICheckResult>();
            PipelineMeta pipelineMeta = this.pipelineGraph.getPipelineMeta();
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.hopGui.getShell());
            Runnable run = () -> {
                IProgressMonitor monitor = monitorDialog.getProgressMonitor();
                while (monitorDialog.getShell() == null || !monitorDialog.getShell().isDisposed() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (monitor.isCanceled()) {
                    try {
                        pipelineMeta.cancelQueries();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            new Thread(run).start();
            monitorDialog.run(true, monitor -> {
                try {
                    pipelineMeta.checkTransforms(remarks, false, monitor, this.pipelineGraph.getVariables(), (IHopMetadataProvider)this.hopGui.getMetadataProvider());
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"PipelineGraph.Check.ErrorCheckingPipeline.Exception", (Object[])new Object[]{e}));
                }
            });
            this.refresh(remarks);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineGraph.Check.ErrorCheckingPipeline.Message", (String[])new String[0]), e);
        }
    }

    private void refresh(List<ICheckResult> remarks) {
        this.wTree.setRedraw(false);
        this.wTree.removeAll();
        HashMap<ICheckResultSource, TreeItem> mapSourceItems = new HashMap<ICheckResultSource, TreeItem>();
        for (ICheckResult cr : remarks) {
            if (cr.getType() == 1) continue;
            ICheckResultSource source = cr.getSourceInfo();
            TreeItem item = (TreeItem)mapSourceItems.get(source);
            if (source == null) {
                item = new TreeItem(this.wTree, 0);
            } else if (item == null) {
                TreeItem parentItem = new TreeItem(this.wTree, 0);
                parentItem.setText(source.getName());
                parentItem.setData((Object)source);
                if (source instanceof TransformMeta) {
                    TransformMeta transform = (TransformMeta)source;
                    Image image = GuiResource.getInstance().getSwtImageTransform(transform.getPluginId()).getAsBitmapForSize((Device)this.hopGui.getDisplay(), 24, 24);
                    if (image != null) {
                        parentItem.setImage(image);
                    }
                    mapSourceItems.put(source, parentItem);
                }
                item = new TreeItem(parentItem, 0);
                parentItem.setExpanded(true);
            } else {
                item = new TreeItem(item, 0);
            }
            item.setText(cr.getText());
            item.setData((Object)source);
            Image image = this.getImage(cr);
            if (image == null) continue;
            item.setImage(image);
        }
        this.wTree.setRedraw(true);
    }

    private Image getImage(ICheckResult cr) {
        return switch (cr.getType()) {
            case 1 -> GuiResource.getInstance().getImageTrue();
            case 4 -> GuiResource.getInstance().getImageError();
            case 3 -> GuiResource.getInstance().getImageWarning();
            default -> null;
        };
    }

    private void edit(Event event) {
        TreeItem item;
        Object object;
        Widget widget = event.item;
        if (widget instanceof TreeItem && (object = (item = (TreeItem)widget).getData()) instanceof ICheckResultSource) {
            ICheckResultSource source = (ICheckResultSource)object;
            TransformMeta transformMeta = this.pipelineGraph.getPipelineMeta().findTransform(source.getName());
            this.pipelineGraph.editTransform(this.pipelineGraph.getPipelineMeta(), transformMeta);
        }
    }

    @Generated
    public CTabItem getPipelineCheckTab() {
        return this.pipelineCheckTab;
    }

    @Generated
    public GuiToolbarWidgets getToolBarWidgets() {
        return this.toolBarWidgets;
    }
}

