/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.UnsignedInteger32;

public class TimeTicks
extends UnsignedInteger32 {
    private static final long serialVersionUID = 8663761323061572311L;
    private static final String FORMAT_PATTERN = "{0,choice,0#|1#1 day, |1<{0,number,integer} days, }{1,number,integer}:{2,number,00}:{3,number,00}.{4,number,00}";

    public TimeTicks() {
    }

    public TimeTicks(TimeTicks timeTicks) {
        this.value = timeTicks.value;
    }

    public TimeTicks(long l) {
        super(l);
    }

    public Object clone() {
        return new TimeTicks(this.value);
    }

    public int getSyntax() {
        return 67;
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeUnsignedInteger(outputStream, (byte)67, super.getValue());
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        long l = BER.decodeUnsignedInteger(bERInputStream, mutableByte);
        if (mutableByte.getValue() != 67) {
            throw new IOException("Wrong type encountered when decoding TimeTicks: " + mutableByte.getValue());
        }
        this.setValue(l);
    }

    public String toString() {
        return this.toString(FORMAT_PATTERN);
    }

    public String toString(String string) {
        long l = this.getValue();
        long l2 = l / 8640000L;
        long l3 = (l %= 8640000L) / 360000L;
        long l4 = (l %= 360000L) / 6000L;
        long l5 = (l %= 6000L) / 100L;
        long l6 = l %= 100L;
        Long[] longArray = new Long[]{new Long(l2), new Long(l3), new Long(l4), new Long(l5), new Long(l6)};
        return MessageFormat.format(string, longArray);
    }

    public long toMilliseconds() {
        return this.value * 10L;
    }

    public void fromMilliseconds(long l) {
        this.setValue(l / 10L);
    }
}

