/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.moderation;

import dev.ai4j.openai4j.moderation.ModerationModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ModerationRequest {
    private final String model;
    private final List<String> input;

    private ModerationRequest(Builder builder) {
        this.model = builder.model;
        this.input = builder.input;
    }

    public String model() {
        return this.model;
    }

    public List<String> input() {
        return this.input;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ModerationRequest && this.equalTo((ModerationRequest)another);
    }

    private boolean equalTo(ModerationRequest another) {
        return Objects.equals(this.model, another.model) && Objects.equals(this.input, another.input);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.model);
        h += (h << 5) + Objects.hashCode(this.input);
        return h;
    }

    public String toString() {
        return "ModerationRequest{model=" + this.model + ", input=" + this.input + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String model;
        private List<String> input;

        private Builder() {
        }

        public Builder model(ModerationModel model) {
            return this.model(model.toString());
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder input(List<String> input) {
            if (input != null) {
                this.input = Collections.unmodifiableList(input);
            }
            return this;
        }

        public Builder input(String input) {
            return this.input(Collections.singletonList(input));
        }

        public ModerationRequest build() {
            return new ModerationRequest(this);
        }
    }
}

