/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.github.jamm.Unmetered;

@Unmetered
public final class TableMetadataRef {
    public final TableId id;
    public final String keyspace;
    public final String name;
    private volatile TableMetadata metadata;
    private volatile TableMetadata localTableMetadata;
    private volatile CompressionParams localCompressionParams;

    TableMetadataRef(TableMetadata metadata) {
        this.metadata = metadata;
        this.id = metadata.id;
        this.keyspace = metadata.keyspace;
        this.name = metadata.name;
    }

    public static TableMetadataRef forOfflineTools(TableMetadata metadata) {
        return new TableMetadataRef(metadata);
    }

    public TableMetadata get() {
        return this.metadata;
    }

    public TableMetadata getLocal() {
        if (this.localTableMetadata != null) {
            return this.localTableMetadata;
        }
        return this.metadata;
    }

    void set(TableMetadata metadata) {
        metadata.validateCompatibility(this.get());
        this.metadata = metadata;
        this.localTableMetadata = null;
    }

    public void setLocalOverrides(TableMetadata metadata) {
        metadata.validateCompatibility(this.get());
        this.localTableMetadata = metadata;
    }

    public String toString() {
        return this.get().toString();
    }
}

