/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.ApproxMemoMatrix;
import com.wcohen.ss.CharMatchScore;
import com.wcohen.ss.api.StringWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class ApproxNeedlemanWunsch
extends AbstractStringDistance {
    private static Logger log = Logger.getLogger(ApproxNeedlemanWunsch.class);
    private static final int DEFAULT_WIDTH = 40;
    private CharMatchScore charMatchScore;
    private double gapCost;
    private MyMatrix mat;
    private int width = 40;

    public ApproxNeedlemanWunsch() {
        this(CharMatchScore.DIST_01, 1.0);
    }

    public ApproxNeedlemanWunsch(CharMatchScore charMatchScore, double gapCost) {
        this.charMatchScore = charMatchScore;
        this.gapCost = gapCost;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public double score(StringWrapper s, StringWrapper t) {
        this.mat = new MyMatrix(s, t);
        for (int i = 1; i <= s.length(); ++i) {
            int j = (int)Math.round((double)i * this.mat.getScale());
            if (j < 1 || j > t.length()) continue;
            double forceComputatationHere = this.mat.get(i, j);
        }
        return this.mat.get(s.length(), t.length());
    }

    public String explainScore(StringWrapper s, StringWrapper t) {
        this.mat = new MyMatrix(s, t);
        double d = this.mat.get(s.length(), t.length());
        this.mat.setPrintNegativeValues(true);
        return this.mat.toString() + "\nScore = " + d;
    }

    public int getAlignedChar(int iMinusOne, boolean preferHigherIndices) {
        int i = iMinusOne + 1;
        int bestJ = -1;
        double bestScore = -1.7976931348623157E308;
        for (int j = this.mat.getFirstStoredEntryInRow(i); j <= this.mat.getLastStoredEntryInRow(i); ++j) {
            double score;
            if (this.mat.outOfRange(i, j)) {
                log.error((Object)("out of range: " + i + "," + j));
            }
            if (!((score = this.mat.get(i, j)) > bestScore) && (score != bestScore || !preferHigherIndices)) continue;
            bestScore = score;
            bestJ = j;
        }
        return bestJ - 1;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length == 3) {
            String s = ApproxNeedlemanWunsch.readFile(new File(argv[1]));
            String t = ApproxNeedlemanWunsch.readFile(new File(argv[2]));
            long t0 = System.currentTimeMillis();
            double score = new ApproxNeedlemanWunsch().score(s, t);
            long tf = System.currentTimeMillis();
            System.out.println("score = " + score + " runtime = " + (double)(tf - t0) / 1000.0 + " sec");
        } else {
            ApproxNeedlemanWunsch.doMain(new ApproxNeedlemanWunsch(), argv);
        }
    }

    private static String readFile(File in) throws IOException {
        FileInputStream inputStream = new FileInputStream(in);
        byte[] bytes = new byte[((InputStream)inputStream).available()];
        ((InputStream)inputStream).read(bytes);
        ((InputStream)inputStream).close();
        return new String(bytes);
    }

    private class MyMatrix
    extends ApproxMemoMatrix {
        public MyMatrix(StringWrapper s, StringWrapper t) {
            super(s, t, ApproxNeedlemanWunsch.this.width, -1.7976931348623157E308);
        }

        public double compute(int i, int j) {
            if (i == 0) {
                return (double)(-j) * ApproxNeedlemanWunsch.this.gapCost;
            }
            if (j == 0) {
                return (double)(-i) * ApproxNeedlemanWunsch.this.gapCost;
            }
            return MyMatrix.max3(this.get(i - 1, j - 1) + ApproxNeedlemanWunsch.this.charMatchScore.matchScore(this.sAt(i), this.tAt(j)), this.get(i - 1, j) - ApproxNeedlemanWunsch.this.gapCost, this.get(i, j - 1) - ApproxNeedlemanWunsch.this.gapCost);
        }
    }
}

