/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.paper.PaperApiCursorError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ListUsersCursorError {
    public static final ListUsersCursorError INSUFFICIENT_PERMISSIONS = new ListUsersCursorError().withTag(Tag.INSUFFICIENT_PERMISSIONS);
    public static final ListUsersCursorError OTHER = new ListUsersCursorError().withTag(Tag.OTHER);
    public static final ListUsersCursorError DOC_NOT_FOUND = new ListUsersCursorError().withTag(Tag.DOC_NOT_FOUND);
    private Tag _tag;
    private PaperApiCursorError cursorErrorValue;

    private ListUsersCursorError() {
    }

    private ListUsersCursorError withTag(Tag _tag) {
        ListUsersCursorError result = new ListUsersCursorError();
        result._tag = _tag;
        return result;
    }

    private ListUsersCursorError withTagAndCursorError(Tag _tag, PaperApiCursorError cursorErrorValue) {
        ListUsersCursorError result = new ListUsersCursorError();
        result._tag = _tag;
        result.cursorErrorValue = cursorErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInsufficientPermissions() {
        return this._tag == Tag.INSUFFICIENT_PERMISSIONS;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isDocNotFound() {
        return this._tag == Tag.DOC_NOT_FOUND;
    }

    public boolean isCursorError() {
        return this._tag == Tag.CURSOR_ERROR;
    }

    public static ListUsersCursorError cursorError(PaperApiCursorError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ListUsersCursorError().withTagAndCursorError(Tag.CURSOR_ERROR, value);
    }

    public PaperApiCursorError getCursorErrorValue() {
        if (this._tag != Tag.CURSOR_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.CURSOR_ERROR, but was Tag." + this._tag.name());
        }
        return this.cursorErrorValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.cursorErrorValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ListUsersCursorError) {
            ListUsersCursorError other = (ListUsersCursorError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case INSUFFICIENT_PERMISSIONS: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case DOC_NOT_FOUND: {
                    return true;
                }
                case CURSOR_ERROR: {
                    return this.cursorErrorValue == other.cursorErrorValue || this.cursorErrorValue.equals((Object)other.cursorErrorValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ListUsersCursorError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListUsersCursorError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case INSUFFICIENT_PERMISSIONS: {
                    g.writeString("insufficient_permissions");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case DOC_NOT_FOUND: {
                    g.writeString("doc_not_found");
                    break;
                }
                case CURSOR_ERROR: {
                    g.writeStartObject();
                    this.writeTag("cursor_error", g);
                    g.writeFieldName("cursor_error");
                    PaperApiCursorError.Serializer.INSTANCE.serialize(value.cursorErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public ListUsersCursorError deserialize(JsonParser p) throws IOException, JsonParseException {
            ListUsersCursorError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("insufficient_permissions".equals(tag)) {
                value = INSUFFICIENT_PERMISSIONS;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("doc_not_found".equals(tag)) {
                value = DOC_NOT_FOUND;
            } else if ("cursor_error".equals(tag)) {
                PaperApiCursorError fieldValue = null;
                Serializer.expectField("cursor_error", p);
                fieldValue = PaperApiCursorError.Serializer.INSTANCE.deserialize(p);
                value = ListUsersCursorError.cursorError(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        INSUFFICIENT_PERMISSIONS,
        OTHER,
        DOC_NOT_FOUND,
        CURSOR_ERROR;

    }
}

