/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.fileproperties.InvalidPropertyGroupError;
import com.dropbox.core.v2.files.UploadSessionLookupError;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UploadSessionFinishError {
    public static final UploadSessionFinishError TOO_MANY_SHARED_FOLDER_TARGETS = new UploadSessionFinishError().withTag(Tag.TOO_MANY_SHARED_FOLDER_TARGETS);
    public static final UploadSessionFinishError TOO_MANY_WRITE_OPERATIONS = new UploadSessionFinishError().withTag(Tag.TOO_MANY_WRITE_OPERATIONS);
    public static final UploadSessionFinishError CONCURRENT_SESSION_DATA_NOT_ALLOWED = new UploadSessionFinishError().withTag(Tag.CONCURRENT_SESSION_DATA_NOT_ALLOWED);
    public static final UploadSessionFinishError CONCURRENT_SESSION_NOT_CLOSED = new UploadSessionFinishError().withTag(Tag.CONCURRENT_SESSION_NOT_CLOSED);
    public static final UploadSessionFinishError CONCURRENT_SESSION_MISSING_DATA = new UploadSessionFinishError().withTag(Tag.CONCURRENT_SESSION_MISSING_DATA);
    public static final UploadSessionFinishError PAYLOAD_TOO_LARGE = new UploadSessionFinishError().withTag(Tag.PAYLOAD_TOO_LARGE);
    public static final UploadSessionFinishError CONTENT_HASH_MISMATCH = new UploadSessionFinishError().withTag(Tag.CONTENT_HASH_MISMATCH);
    public static final UploadSessionFinishError OTHER = new UploadSessionFinishError().withTag(Tag.OTHER);
    private Tag _tag;
    private UploadSessionLookupError lookupFailedValue;
    private WriteError pathValue;
    private InvalidPropertyGroupError propertiesErrorValue;

    private UploadSessionFinishError() {
    }

    private UploadSessionFinishError withTag(Tag _tag) {
        UploadSessionFinishError result = new UploadSessionFinishError();
        result._tag = _tag;
        return result;
    }

    private UploadSessionFinishError withTagAndLookupFailed(Tag _tag, UploadSessionLookupError lookupFailedValue) {
        UploadSessionFinishError result = new UploadSessionFinishError();
        result._tag = _tag;
        result.lookupFailedValue = lookupFailedValue;
        return result;
    }

    private UploadSessionFinishError withTagAndPath(Tag _tag, WriteError pathValue) {
        UploadSessionFinishError result = new UploadSessionFinishError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    private UploadSessionFinishError withTagAndPropertiesError(Tag _tag, InvalidPropertyGroupError propertiesErrorValue) {
        UploadSessionFinishError result = new UploadSessionFinishError();
        result._tag = _tag;
        result.propertiesErrorValue = propertiesErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isLookupFailed() {
        return this._tag == Tag.LOOKUP_FAILED;
    }

    public static UploadSessionFinishError lookupFailed(UploadSessionLookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UploadSessionFinishError().withTagAndLookupFailed(Tag.LOOKUP_FAILED, value);
    }

    public UploadSessionLookupError getLookupFailedValue() {
        if (this._tag != Tag.LOOKUP_FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.LOOKUP_FAILED, but was Tag." + this._tag.name());
        }
        return this.lookupFailedValue;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static UploadSessionFinishError path(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UploadSessionFinishError().withTagAndPath(Tag.PATH, value);
    }

    public WriteError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isPropertiesError() {
        return this._tag == Tag.PROPERTIES_ERROR;
    }

    public static UploadSessionFinishError propertiesError(InvalidPropertyGroupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UploadSessionFinishError().withTagAndPropertiesError(Tag.PROPERTIES_ERROR, value);
    }

    public InvalidPropertyGroupError getPropertiesErrorValue() {
        if (this._tag != Tag.PROPERTIES_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.PROPERTIES_ERROR, but was Tag." + this._tag.name());
        }
        return this.propertiesErrorValue;
    }

    public boolean isTooManySharedFolderTargets() {
        return this._tag == Tag.TOO_MANY_SHARED_FOLDER_TARGETS;
    }

    public boolean isTooManyWriteOperations() {
        return this._tag == Tag.TOO_MANY_WRITE_OPERATIONS;
    }

    public boolean isConcurrentSessionDataNotAllowed() {
        return this._tag == Tag.CONCURRENT_SESSION_DATA_NOT_ALLOWED;
    }

    public boolean isConcurrentSessionNotClosed() {
        return this._tag == Tag.CONCURRENT_SESSION_NOT_CLOSED;
    }

    public boolean isConcurrentSessionMissingData() {
        return this._tag == Tag.CONCURRENT_SESSION_MISSING_DATA;
    }

    public boolean isPayloadTooLarge() {
        return this._tag == Tag.PAYLOAD_TOO_LARGE;
    }

    public boolean isContentHashMismatch() {
        return this._tag == Tag.CONTENT_HASH_MISMATCH;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.lookupFailedValue, this.pathValue, this.propertiesErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UploadSessionFinishError) {
            UploadSessionFinishError other = (UploadSessionFinishError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case LOOKUP_FAILED: {
                    return this.lookupFailedValue == other.lookupFailedValue || this.lookupFailedValue.equals(other.lookupFailedValue);
                }
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case PROPERTIES_ERROR: {
                    return this.propertiesErrorValue == other.propertiesErrorValue || this.propertiesErrorValue.equals(other.propertiesErrorValue);
                }
                case TOO_MANY_SHARED_FOLDER_TARGETS: {
                    return true;
                }
                case TOO_MANY_WRITE_OPERATIONS: {
                    return true;
                }
                case CONCURRENT_SESSION_DATA_NOT_ALLOWED: {
                    return true;
                }
                case CONCURRENT_SESSION_NOT_CLOSED: {
                    return true;
                }
                case CONCURRENT_SESSION_MISSING_DATA: {
                    return true;
                }
                case PAYLOAD_TOO_LARGE: {
                    return true;
                }
                case CONTENT_HASH_MISMATCH: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UploadSessionFinishError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UploadSessionFinishError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case LOOKUP_FAILED: {
                    g.writeStartObject();
                    this.writeTag("lookup_failed", g);
                    g.writeFieldName("lookup_failed");
                    UploadSessionLookupError.Serializer.INSTANCE.serialize(value.lookupFailedValue, g);
                    g.writeEndObject();
                    break;
                }
                case PATH: {
                    g.writeStartObject();
                    this.writeTag("path", g);
                    g.writeFieldName("path");
                    WriteError.Serializer.INSTANCE.serialize(value.pathValue, g);
                    g.writeEndObject();
                    break;
                }
                case PROPERTIES_ERROR: {
                    g.writeStartObject();
                    this.writeTag("properties_error", g);
                    g.writeFieldName("properties_error");
                    InvalidPropertyGroupError.Serializer.INSTANCE.serialize(value.propertiesErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                case TOO_MANY_SHARED_FOLDER_TARGETS: {
                    g.writeString("too_many_shared_folder_targets");
                    break;
                }
                case TOO_MANY_WRITE_OPERATIONS: {
                    g.writeString("too_many_write_operations");
                    break;
                }
                case CONCURRENT_SESSION_DATA_NOT_ALLOWED: {
                    g.writeString("concurrent_session_data_not_allowed");
                    break;
                }
                case CONCURRENT_SESSION_NOT_CLOSED: {
                    g.writeString("concurrent_session_not_closed");
                    break;
                }
                case CONCURRENT_SESSION_MISSING_DATA: {
                    g.writeString("concurrent_session_missing_data");
                    break;
                }
                case PAYLOAD_TOO_LARGE: {
                    g.writeString("payload_too_large");
                    break;
                }
                case CONTENT_HASH_MISMATCH: {
                    g.writeString("content_hash_mismatch");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public UploadSessionFinishError deserialize(JsonParser p) throws IOException, JsonParseException {
            UploadSessionFinishError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("lookup_failed".equals(tag)) {
                UploadSessionLookupError fieldValue = null;
                Serializer.expectField("lookup_failed", p);
                fieldValue = UploadSessionLookupError.Serializer.INSTANCE.deserialize(p);
                value = UploadSessionFinishError.lookupFailed(fieldValue);
            } else if ("path".equals(tag)) {
                WriteError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = WriteError.Serializer.INSTANCE.deserialize(p);
                value = UploadSessionFinishError.path(fieldValue);
            } else if ("properties_error".equals(tag)) {
                InvalidPropertyGroupError fieldValue = null;
                Serializer.expectField("properties_error", p);
                fieldValue = InvalidPropertyGroupError.Serializer.INSTANCE.deserialize(p);
                value = UploadSessionFinishError.propertiesError(fieldValue);
            } else {
                value = "too_many_shared_folder_targets".equals(tag) ? TOO_MANY_SHARED_FOLDER_TARGETS : ("too_many_write_operations".equals(tag) ? TOO_MANY_WRITE_OPERATIONS : ("concurrent_session_data_not_allowed".equals(tag) ? CONCURRENT_SESSION_DATA_NOT_ALLOWED : ("concurrent_session_not_closed".equals(tag) ? CONCURRENT_SESSION_NOT_CLOSED : ("concurrent_session_missing_data".equals(tag) ? CONCURRENT_SESSION_MISSING_DATA : ("payload_too_large".equals(tag) ? PAYLOAD_TOO_LARGE : ("content_hash_mismatch".equals(tag) ? CONTENT_HASH_MISMATCH : OTHER))))));
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        LOOKUP_FAILED,
        PATH,
        PROPERTIES_ERROR,
        TOO_MANY_SHARED_FOLDER_TARGETS,
        TOO_MANY_WRITE_OPERATIONS,
        CONCURRENT_SESSION_DATA_NOT_ALLOWED,
        CONCURRENT_SESSION_NOT_CLOSED,
        CONCURRENT_SESSION_MISSING_DATA,
        PAYLOAD_TOO_LARGE,
        CONTENT_HASH_MISMATCH,
        OTHER;

    }
}

