/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.monetdb.mcl.io.BufferedMCLReader;
import org.monetdb.mcl.io.BufferedMCLWriter;
import org.monetdb.mcl.io.LineType;
import org.monetdb.mcl.net.MapiSocket;

public final class SQLRestore {
    private final String _host;
    private final int _port;
    private final String _user;
    private final String _password;
    private final String _dbName;

    public SQLRestore(String string, int n, String string2, String string3, String string4) throws IOException {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new NullPointerException();
        }
        this._host = string;
        this._port = n;
        this._user = string2;
        this._password = string3;
        this._dbName = string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(File file) throws IOException {
        try (MapiSocket mapiSocket = new MapiSocket();){
            mapiSocket.setLanguage("sql");
            mapiSocket.setDatabase(this._dbName);
            mapiSocket.connect(this._host, this._port, this._user, this._password);
            BufferedMCLWriter bufferedMCLWriter = mapiSocket.getWriter();
            BufferedMCLReader bufferedMCLReader = mapiSocket.getReader();
            ServerResponseReader serverResponseReader = new ServerResponseReader(bufferedMCLReader);
            Thread thread = new Thread(serverResponseReader);
            thread.start();
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    char[] cArray;
                    int n;
                    bufferedMCLWriter.write(115);
                    while (!serverResponseReader.inErrorState() && (n = bufferedReader.read(cArray = new char[4096])) >= 0) {
                        bufferedMCLWriter.write(cArray, 0, n);
                    }
                    bufferedMCLWriter.flush();
                    bufferedMCLWriter.close();
                }
                catch (Throwable throwable) {
                    bufferedReader.close();
                    throw throwable;
                }
                bufferedReader.close();
            }
            finally {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException.getMessage());
                }
                if (serverResponseReader.inErrorState()) {
                    throw new IOException(serverResponseReader.getErrorMessage());
                }
            }
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 6) {
            System.err.println("USAGE: java " + SQLRestore.class.getName() + " <host> <port> <user> <password> <dbname> <dumpfile>");
            System.exit(1);
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string2 = stringArray[2];
        String string3 = stringArray[3];
        String string4 = stringArray[4];
        File file = new File(stringArray[5]);
        if (!file.isFile() || !file.canRead()) {
            System.err.println("Cannot read: " + file);
            System.exit(1);
        }
        try (SQLRestore sQLRestore = new SQLRestore(string, n, string2, string3, string4);){
            System.out.println("Start restoring " + file);
            long l = -System.currentTimeMillis();
            sQLRestore.restore(file);
            System.out.println("Restoring took: " + (l += System.currentTimeMillis()) + "ms");
        }
    }

    private static final class ServerResponseReader
    implements Runnable {
        private final BufferedMCLReader _is;
        private final AtomicBoolean _errorState = new AtomicBoolean(false);
        private String _errorMessage = null;

        ServerResponseReader(BufferedMCLReader bufferedMCLReader) {
            this._is = bufferedMCLReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    this._is.advance();
                    String string = this._is.getLine();
                    if (string == null) {
                        break;
                    }
                    LineType lineType = this._is.getLineType();
                    switch (lineType) {
                        case ERROR: {
                            this._errorMessage = string;
                            this._errorState.set(true);
                            return;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                this._errorMessage = iOException.getMessage();
                this._errorState.set(true);
            }
            finally {
                try {
                    this._is.close();
                }
                catch (IOException iOException) {}
            }
        }

        public boolean inErrorState() {
            return this._errorState.get();
        }

        public String getErrorMessage() {
            return this._errorMessage;
        }
    }
}

