/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.transform;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.laf.BasePropertyHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.DialogBoxWithButtons;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.ui.util.HelpUtils;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class BaseTransformDialog
extends Dialog
implements ITransformDialog {
    private static final Class<?> PKG = ITransform.class;
    public static final ILoggingObject loggingObject = new SimpleLoggingObject("Transform dialog", LoggingObjectType.TRANSFORM_DIALOG, null);
    protected IVariables variables;
    protected String transformName;
    protected Label wlTransformName;
    protected Text wTransformName;
    protected FormData fdlTransformName;
    protected FormData fdTransformName;
    protected Button wOk;
    protected Button wGet;
    protected Button wPreview;
    protected Button wSql;
    protected Button wCreate;
    protected Button wCancel;
    protected FormData fdOk;
    protected FormData fdGet;
    protected FormData fdPreview;
    protected FormData fdSql;
    protected FormData fdCreate;
    protected FormData fdCancel;
    protected PipelineMeta pipelineMeta;
    protected Shell shell;
    protected Listener lsResize;
    protected boolean changed;
    protected boolean backupChanged;
    protected ITransformMeta baseTransformMeta;
    protected PropsUi props;
    protected IHopMetadataProvider metadataProvider;
    protected TransformMeta transformMeta;
    protected LogChannel log;
    protected static final int BUTTON_ALIGNMENT_CENTER = 0;
    protected static final int BUTTON_ALIGNMENT_LEFT = 1;
    public static final int BUTTON_ALIGNMENT_RIGHT = 2;
    protected static int buttonAlignment = 0;

    public BaseTransformDialog(Shell parent, IVariables variables, ITransformMeta baseTransformMeta, PipelineMeta pipelineMeta) {
        super(parent, 0);
        this.log = new LogChannel((Object)baseTransformMeta);
        this.variables = variables;
        this.pipelineMeta = pipelineMeta;
        this.baseTransformMeta = baseTransformMeta;
        this.transformName = baseTransformMeta.getParentTransformMeta().getName();
        this.transformMeta = pipelineMeta.findTransform(this.transformName);
        this.backupChanged = baseTransformMeta.hasChanged();
        this.props = PropsUi.getInstance();
        this.metadataProvider = HopGui.getInstance().getMetadataProvider();
    }

    public BaseTransformDialog(Shell parent, IVariables variables, ITransformMeta baseTransformMeta, PipelineMeta pipelineMeta, String transformName) {
        super(parent, 0);
        this.log = new LogChannel((Object)baseTransformMeta);
        this.variables = variables;
        this.pipelineMeta = pipelineMeta;
        this.transformName = transformName;
        this.transformMeta = pipelineMeta.findTransform(transformName);
        this.baseTransformMeta = baseTransformMeta;
        this.backupChanged = baseTransformMeta.hasChanged();
        this.props = PropsUi.getInstance();
    }

    public BaseTransformDialog(Shell parent, int nr, IVariables variables, BaseTransformMeta<?, ?> in, PipelineMeta tr) {
        this(parent, variables, (ITransformMeta)in, tr, null);
    }

    public void setShellImage(Shell shell, ITransformMeta transformMetaInterface) {
        this.setShellImage(shell);
        if (this.transformMeta.isDeprecated()) {
            this.addDeprecation();
        }
    }

    public void setActive() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.setActive();
        }
    }

    private void addDeprecation() {
        if (this.shell == null) {
            return;
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){
            private boolean deprecation = false;

            public void shellActivated(ShellEvent shellEvent) {
                super.shellActivated(shellEvent);
                if (!BaseTransformDialog.this.transformMeta.isDeprecated() || this.deprecation) {
                    return;
                }
                String deprecated = BaseMessages.getString(PKG, (String)"System.Deprecated", (String[])new String[0]).toLowerCase();
                BaseTransformDialog.this.shell.setText(BaseTransformDialog.this.shell.getText() + " (" + deprecated + ")");
                this.deprecation = true;
            }
        });
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public boolean isDisposed() {
        if (this.shell != null) {
            return this.shell.isDisposed();
        }
        return true;
    }

    public void setSize() {
        BaseTransformDialog.setSize(this.shell);
    }

    protected void setButtonPositions(Button[] buttons, int margin, Control lastControl) {
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons, margin, lastControl);
    }

    public static final void positionBottomButtons(Composite composite, Button[] buttons, int margin, Control lastControl) {
        BaseTransformDialog.positionBottomButtons(composite, buttons, margin, buttonAlignment, lastControl);
    }

    public static final void positionBottomButtons(Composite composite, Button[] buttons, int margin, int alignment, Control lastControl) {
        for (Button button : buttons) {
            button.setFont(GuiResource.getInstance().getFontDefault());
        }
        Rectangle largest = null;
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].pack(true);
            Rectangle r = buttons[i].getBounds();
            if (largest == null || r.width > largest.width) {
                largest = r;
            }
            if (buttons[i].getToolTipText() != null) continue;
            buttons[i].setToolTipText(Const.replace((String)buttons[i].getText(), (String)"&", (String)""));
        }
        largest.width += 10;
        if (largest.width % 2 == 1) {
            ++largest.width;
        }
        switch (alignment) {
            case 0: {
                BaseTransformDialog.centerButtons(buttons, largest.width, margin, lastControl);
                break;
            }
            case 1: {
                BaseTransformDialog.leftAlignButtons(buttons, largest.width, margin, lastControl);
                break;
            }
            case 2: {
                BaseTransformDialog.rightAlignButtons(buttons, largest.width, margin, lastControl);
                break;
            }
        }
        if (Const.isOSX()) {
            Shell parentShell = composite.getShell();
            final ArrayList<TableView> tableViews = new ArrayList<TableView>();
            BaseTransformDialog.getTableViews((Control)parentShell, tableViews);
            for (Button button : buttons) {
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        for (TableView view : tableViews) {
                            view.applyOSXChanges();
                        }
                    }
                });
            }
        }
    }

    private static final void getTableViews(Control parentControl, List<TableView> tableViews) {
        block3: {
            Control[] children;
            block4: {
                Control[] children2;
                block2: {
                    if (!(parentControl instanceof TableView)) break block2;
                    TableView tableViewParentControl = (TableView)parentControl;
                    tableViews.add(tableViewParentControl);
                    break block3;
                }
                if (!(parentControl instanceof Composite)) break block4;
                Composite compositeParentControl = (Composite)parentControl;
                for (Control child : children2 = compositeParentControl.getChildren()) {
                    BaseTransformDialog.getTableViews(child, tableViews);
                }
                break block3;
            }
            if (!(parentControl instanceof Shell)) break block3;
            Shell shellParentControl = (Shell)parentControl;
            for (Control child : children = shellParentControl.getChildren()) {
                BaseTransformDialog.getTableViews(child, tableViews);
            }
        }
    }

    protected static int getButtonAlignment() {
        String buttonAlign = BasePropertyHandler.getProperty((String)"Button_Position", (String)"center").toLowerCase();
        if ("center".equals(buttonAlign)) {
            return 0;
        }
        if ("left".equals(buttonAlign)) {
            return 1;
        }
        return 2;
    }

    private static FormData createDefaultFormData(Button button, int width, int margin, Control lastControl) {
        FormData formData = new FormData();
        if (lastControl != null) {
            formData.top = new FormAttachment(lastControl, margin * 3);
        } else {
            formData.bottom = new FormAttachment(100, 0);
        }
        formData.right = new FormAttachment((Control)button, width + margin);
        return formData;
    }

    protected static void leftAlignButtons(Button[] buttons, int width, int margin, Control lastControl) {
        for (int i = 0; i < buttons.length; ++i) {
            FormData formData = BaseTransformDialog.createDefaultFormData(buttons[i], width, margin, lastControl);
            formData.left = i == 0 ? new FormAttachment(0, margin) : new FormAttachment((Control)buttons[i - 1], margin);
            buttons[i].setLayoutData((Object)formData);
        }
    }

    protected static void rightAlignButtons(Button[] buttons, int width, int margin, Control lastControl) {
        for (int i = buttons.length - 1; i >= 0; --i) {
            FormData formData = BaseTransformDialog.createDefaultFormData(buttons[i], width, margin, lastControl);
            formData.left = i == buttons.length - 1 ? new FormAttachment(100, -(width + margin)) : new FormAttachment((Control)buttons[i + 1], -(2 * (width + margin)) - margin);
            buttons[i].setLayoutData((Object)formData);
        }
    }

    protected static void centerButtons(Button[] buttons, int width, int margin, Control lastControl) {
        int i;
        int middleButtonIndex = buttons.length / 2;
        FormData formData = BaseTransformDialog.createDefaultFormData(buttons[middleButtonIndex], width, margin, lastControl);
        int leftOffset = 0;
        leftOffset = buttons.length % 2 == 0 ? margin : -(width + margin) / 2;
        formData.left = new FormAttachment(50, leftOffset);
        buttons[middleButtonIndex].setLayoutData((Object)formData);
        for (i = middleButtonIndex + 1; i < buttons.length; ++i) {
            formData = BaseTransformDialog.createDefaultFormData(buttons[i], width, margin, lastControl);
            formData.left = new FormAttachment((Control)buttons[i - 1], margin);
            buttons[i].setLayoutData((Object)formData);
        }
        for (i = middleButtonIndex - 1; i >= 0; --i) {
            formData = BaseTransformDialog.createDefaultFormData(buttons[i], width, margin, lastControl);
            formData.left = new FormAttachment((Control)buttons[i + 1], -(2 * (width + margin)) - margin);
            buttons[i].setLayoutData((Object)formData);
        }
    }

    public static final ModifyListener getModifyListenerTooltipText(IVariables variables, TextVar textField) {
        return e -> textField.setToolTipText(variables.resolve(textField.getText()));
    }

    public MetaSelectionLine<DatabaseMeta> addConnectionLine(Composite parent, Control previous, DatabaseMeta selected, ModifyListener lsMod) {
        return this.addConnectionLine(parent, previous, selected, lsMod, BaseMessages.getString(PKG, (String)"BaseTransformDialog.Connection.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.Connection.Tooltip", (String[])new String[0]));
    }

    public MetaSelectionLine<DatabaseMeta> addConnectionLine(Composite parent, Control previous, DatabaseMeta selected, ModifyListener lsMod, String connectionLabel) {
        return this.addConnectionLine(parent, previous, selected, lsMod, connectionLabel, BaseMessages.getString(PKG, (String)"BaseTransformDialog.Connection.Tooltip", (String[])new String[0]));
    }

    public MetaSelectionLine<DatabaseMeta> addConnectionLine(Composite parent, Control previous, DatabaseMeta selected, ModifyListener lsMod, String connectionLabel, String connectionTooltip) {
        MetaSelectionLine<DatabaseMeta> wConnection = new MetaSelectionLine<DatabaseMeta>(this.variables, this.metadataProvider, DatabaseMeta.class, parent, 0, connectionLabel, connectionTooltip);
        wConnection.addToConnectionLine(parent, previous, selected, lsMod);
        return wConnection;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public static void setMinimalShellHeight(Shell shell, Control[] controls, int margin, int extra) {
        int height = 0;
        for (int i = 0; i < controls.length; ++i) {
            Rectangle bounds = controls[i].getBounds();
            height += bounds.height + margin;
        }
        shell.setSize(shell.getBounds().width, height += extra);
    }

    public static void setSize(Shell shell) {
        BaseTransformDialog.setSize(shell, -1, -1, !EnvironmentUtils.getInstance().isWeb());
    }

    public static void setSize(Shell shell, int minWidth, int minHeight) {
        BaseTransformDialog.setSize(shell, minWidth, minHeight, false);
    }

    public static void setSize(Shell shell, int minWidth, int minHeight, boolean packIt) {
        PropsUi props = PropsUi.getInstance();
        WindowProperty winprop = props.getScreen(shell.getText());
        if (winprop != null) {
            winprop.setShell(shell, minWidth, minHeight);
        } else {
            if (packIt) {
                shell.pack();
            } else {
                shell.layout();
            }
            winprop = new WindowProperty(shell);
            winprop.setShell(shell, minWidth, minHeight);
            Rectangle shellBounds = shell.getBounds();
            Monitor monitor = shell.getDisplay().getPrimaryMonitor();
            if (shell.getParent() != null) {
                monitor = shell.getParent().getMonitor();
            }
            Rectangle monitorClientArea = monitor.getClientArea();
            int middleX = monitorClientArea.x + (monitorClientArea.width - shellBounds.width) / 2;
            int middleY = monitorClientArea.y + (monitorClientArea.height - shellBounds.height) / 2;
            shell.setLocation(middleX, middleY);
        }
    }

    public static final void setTraverseOrder(Control[] controls) {
        for (int i = 0; i < controls.length; ++i) {
            int controlNr = i;
            if (i < controls.length - 1) {
                controls[i].addTraverseListener(te -> {
                    te.doit = false;
                    int thisOne = controlNr + 1;
                    while (!controls[thisOne].isEnabled()) {
                        if (++thisOne >= controls.length) {
                            thisOne = 0;
                        }
                        if (thisOne != controlNr) continue;
                        return;
                    }
                    controls[thisOne].setFocus();
                });
                continue;
            }
            controls[i].addTraverseListener(te -> {
                te.doit = false;
                int thisOne = 0;
                while (!controls[thisOne].isEnabled()) {
                    if (++thisOne < controls.length) continue;
                    return;
                }
                controls[thisOne].setFocus();
            });
        }
    }

    public static final void getFieldsFromPrevious(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, TableView tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, ITableItemInsertListener listener) {
        try {
            IRowMeta row = pipelineMeta.getPrevTransformFields(variables, transformMeta);
            if (row != null) {
                BaseTransformDialog.getFieldsFromPrevious(row, tableView, keyColumn, nameColumn, dataTypeColumn, lengthColumn, precisionColumn, listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(tableView.getShell(), BaseMessages.getString(PKG, (String)"BaseTransformDialog.FailedToGetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.FailedToGetFields.Message", (String[])new String[]{transformMeta.getName()}), (Exception)((Object)ke));
        }
    }

    public static final void getFieldsFromPrevious(IRowMeta row, TableView tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, ITableItemInsertListener listener) {
        BaseTransformDialog.getFieldsFromPrevious(row, tableView, keyColumn, nameColumn, dataTypeColumn, lengthColumn, precisionColumn, true, listener);
    }

    public static final void getFieldsFromPrevious(IRowMeta row, TableView tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, boolean optimizeWidth, ITableItemInsertListener listener) {
        BaseTransformDialog.getFieldsFromPrevious(row, tableView, keyColumn, nameColumn, dataTypeColumn, lengthColumn, precisionColumn, optimizeWidth, listener, BaseTransformDialog::getFieldsChoiceDialog);
    }

    public static final void getFieldsFromPrevious(IRowMeta row, TableView tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, boolean optimizeWidth, ITableItemInsertListener listener, IFieldsChoiceDialogProvider getFieldsChoiceDialogProvider) {
        if (row == null || row.size() == 0) {
            return;
        }
        Table table = tableView.table;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            String key = tableItem.getText(keyColumn);
            if (Utils.isEmpty((CharSequence)key) || keys.indexOf(key) >= 0) continue;
            keys.add(key);
        }
        int choice = 0;
        if (!keys.isEmpty()) {
            DialogBoxWithButtons getFieldsChoiceDialog = getFieldsChoiceDialogProvider.provide(tableView.getShell(), keys.size(), row.size());
            int idx = getFieldsChoiceDialog.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            tableView.clearAll(false);
        }
        for (int i = 0; i < row.size(); ++i) {
            int c;
            IValueMeta v = row.getValueMeta(i);
            boolean add = true;
            if (choice == 0 && keys.indexOf(v.getName()) >= 0) {
                add = false;
            }
            if (!add) continue;
            TableItem tableItem = new TableItem(table, 0);
            for (c = 0; c < nameColumn.length; ++c) {
                tableItem.setText(nameColumn[c], Const.NVL((String)v.getName(), (String)""));
            }
            if (dataTypeColumn != null) {
                for (c = 0; c < dataTypeColumn.length; ++c) {
                    tableItem.setText(dataTypeColumn[c], v.getTypeDesc());
                }
            }
            if (lengthColumn > 0 && v.getLength() >= 0) {
                tableItem.setText(lengthColumn, Integer.toString(v.getLength()));
            }
            if (precisionColumn > 0 && v.getPrecision() >= 0) {
                tableItem.setText(precisionColumn, Integer.toString(v.getPrecision()));
            }
            if (listener == null || listener.tableItemInserted(tableItem, v)) continue;
            tableItem.dispose();
        }
        tableView.removeEmptyRows();
        tableView.setRowNums();
        if (optimizeWidth) {
            tableView.optWidth(true);
        }
    }

    static DialogBoxWithButtons getFieldsChoiceDialog(Shell shell, int existingFields, int newFields) {
        return new DialogBoxWithButtons(shell, BaseMessages.getString(PKG, (String)"BaseTransformDialog.GetFieldsChoice.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.GetFieldsChoice.Message", (String[])new String[]{"" + existingFields, "" + newFields}), new String[]{BaseMessages.getString(PKG, (String)"BaseTransformDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.Cancel", (String[])new String[0])});
    }

    public static final void getFieldsFromPrevious(IVariables variables, ComboVar comboVar, PipelineMeta pipelineMeta, TransformMeta transformMeta) {
        int indexField = -1;
        try {
            IRowMeta r = pipelineMeta.getPrevTransformFields(variables, transformMeta);
            String selectedField = comboVar.getText();
            comboVar.removeAll();
            if (r != null && !r.isEmpty()) {
                r.getFieldNames();
                comboVar.setItems(r.getFieldNames());
                indexField = r.indexOfValue(selectedField);
            }
            if (indexField > -1) {
                comboVar.select(indexField);
            } else if (selectedField != null) {
                comboVar.setText(selectedField);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(comboVar.getShell(), BaseMessages.getString(PKG, (String)"BaseTransformDialog.FailedToGetFieldsPrevious.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.FailedToGetFieldsPrevious.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public boolean isBasic() {
        return this.log.isBasic();
    }

    public boolean isDetailed() {
        return this.log.isDetailed();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public void logMinimal(String message) {
        this.log.logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.log.logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.log.logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.log.logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.log.logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.log.logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.log.logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.log.logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.log.logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.log.logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.log.logError(message, arguments);
    }

    private void setShellImage(Shell shell) {
        if (this.transformMeta != null) {
            IPlugin plugin = PluginRegistry.getInstance().getPlugin(TransformPluginType.class, (Object)this.transformMeta.getTransform());
            HelpUtils.createHelpButton((Composite)shell, plugin);
            String id = plugin.getIds()[0];
            if (id != null) {
                shell.setImage(GuiResource.getInstance().getSwtImageTransform(id).getAsBitmapForSize((Device)shell.getDisplay(), 32, 32));
            }
        }
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public MetaSelectionLine<DatabaseMeta> addConnectionLine(Composite parent, Control previous, String connection, ModifyListener lsMod) {
        DatabaseMeta databaseMeta = null;
        if (!Utils.isEmpty((CharSequence)connection) && (databaseMeta = this.pipelineMeta.findDatabase(connection, this.variables)) == null) {
            MessageBox mb = new MessageBox(this.shell, 40);
            mb.setMessage(BaseMessages.getString(PKG, (String)"BaseTransformDialog.InvalidConnection.DialogMessage", (String[])new String[]{this.variables.resolve(connection)}));
            mb.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        return this.addConnectionLine(parent, previous, databaseMeta, lsMod);
    }

    public IVariables getVariables() {
        return this.variables;
    }

    protected void replaceNameWithBaseFilename(String filename) {
        MessageBox box = new MessageBox(this.shell, 196);
        box.setText("Change name?");
        box.setMessage("Do you want to change the name of the action to match the filename?");
        int answer = box.open();
        if ((answer & 0x40) != 0) {
            try {
                String baseName = HopVfs.getFileObject((String)this.variables.resolve(filename), (IVariables)this.variables).getName().getBaseName();
                this.wTransformName.setText(baseName);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error extracting name from filename '" + filename + "'", e);
            }
        }
    }

    static {
        buttonAlignment = BaseTransformDialog.getButtonAlignment();
    }

    public static interface IFieldsChoiceDialogProvider {
        public DialogBoxWithButtons provide(Shell var1, int var2, int var3);
    }
}

