/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.data_formats.internal.SerializerUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class NumberConverter {
    public static final Map<NumberType, Function<Object, ?>> NUMBER_CONVERTERS = NumberConverter.getNumberConverters();

    public static byte toByte(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number.byteValue() == number.shortValue()) {
                return number.byteValue();
            }
            throw new ArithmeticException("integer overflow: " + value + " cannot be presented as byte");
        }
        if (value instanceof Boolean) {
            return (byte)((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof String) {
            return Byte.parseByte(value.toString());
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to byte value");
    }

    public static short toShort(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number.shortValue() == number.intValue()) {
                return number.shortValue();
            }
            throw new ArithmeticException("integer overflow: " + value + " cannot be presented as short");
        }
        if (value instanceof Boolean) {
            return (short)((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof String) {
            return Short.parseShort(value.toString());
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to short value");
    }

    public static int toInt(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if ((long)number.intValue() == number.longValue()) {
                return number.intValue();
            }
            throw new ArithmeticException("integer overflow: " + value + " cannot be presented as int");
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to int value");
    }

    public static long toLong(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if ((double)number.longValue() == number.doubleValue()) {
                return number.longValue();
            }
            throw new ArithmeticException("integer overflow: " + value + " cannot be presented as long");
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to long value");
    }

    public static BigInteger toBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        if (value instanceof String) {
            return new BigInteger((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to BigInteger value");
    }

    public static float toFloat(Object value) {
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0f : 0.0f;
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to float value");
    }

    public static double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to double value");
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return BigDecimal.valueOf(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to BigDecimal value");
    }

    static Map<NumberType, Function<Object, ?>> getNumberConverters() {
        HashMap<NumberType, Function<Object, Object>> converters = new HashMap<NumberType, Function<Object, Object>>();
        converters.put(NumberType.Byte, NumberConverter::toByte);
        converters.put(NumberType.Short, NumberConverter::toShort);
        converters.put(NumberType.Int, NumberConverter::toInt);
        converters.put(NumberType.Long, NumberConverter::toLong);
        converters.put(NumberType.BigInteger, NumberConverter::toBigInteger);
        converters.put(NumberType.BigDecimal, NumberConverter::toBigDecimal);
        converters.put(NumberType.Float, NumberConverter::toFloat);
        converters.put(NumberType.Double, NumberConverter::toDouble);
        converters.put(NumberType.Boolean, SerializerUtils::convertToBoolean);
        return Collections.unmodifiableMap(converters);
    }

    public static enum NumberType {
        Byte("byte"),
        Short("short"),
        Int("int"),
        Long("long"),
        BigInteger("BigInteger"),
        Float("float"),
        Double("double"),
        BigDecimal("BigDecimal"),
        Boolean("boolean");

        private final String typeName;

        private NumberType(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

