/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.runners.core.metrics.SpecMonitoringInfoValidator;
import org.apache.beam.runners.core.metrics.StringSetData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SimpleMonitoringInfoBuilder {
    private static final @UnknownKeyFor @NonNull @Initialized SpecMonitoringInfoValidator VALIDATOR = new SpecMonitoringInfoValidator();
    private final @UnknownKeyFor @NonNull @Initialized boolean validateAndDropInvalid;
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfoSpec> KNOWN_SPECS = new HashMap<String, MetricsApi.MonitoringInfoSpec>();
    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo.Builder builder = MetricsApi.MonitoringInfo.newBuilder();

    public SimpleMonitoringInfoBuilder() {
        this(true);
    }

    public SimpleMonitoringInfoBuilder(@UnknownKeyFor @NonNull @Initialized boolean validateAndDropInvalid) {
        this.validateAndDropInvalid = validateAndDropInvalid;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setUrn(@UnknownKeyFor @NonNull @Initialized String urn) {
        this.builder.setUrn(urn);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setType(@UnknownKeyFor @NonNull @Initialized String type) {
        this.builder.setType(type);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setInt64SumValue(@UnknownKeyFor @NonNull @Initialized long value) {
        this.builder.setPayload(MonitoringInfoEncodings.encodeInt64Counter(value));
        this.builder.setType("beam:metrics:sum_int64:v1");
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setDoubleSumValue(@UnknownKeyFor @NonNull @Initialized double value) {
        this.builder.setPayload(MonitoringInfoEncodings.encodeDoubleCounter(value));
        this.builder.setType("beam:metrics:sum_double:v1");
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setInt64LatestValue(@UnknownKeyFor @NonNull @Initialized GaugeData data) {
        Preconditions.checkArgument((GaugeData.empty() != data ? 1 : 0) != 0, (Object)"Cannot encode empty gauge data");
        this.builder.setPayload(MonitoringInfoEncodings.encodeInt64Gauge(data));
        this.builder.setType("beam:metrics:latest_int64:v1");
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setInt64DistributionValue(@UnknownKeyFor @NonNull @Initialized DistributionData data) {
        this.builder.setPayload(MonitoringInfoEncodings.encodeInt64Distribution(data));
        this.builder.setType("beam:metrics:distribution_int64:v1");
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setDoubleDistributionValue(@UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized double sum, @UnknownKeyFor @NonNull @Initialized double min, @UnknownKeyFor @NonNull @Initialized double max) {
        this.builder.setPayload(MonitoringInfoEncodings.encodeDoubleDistribution(count, sum, min, max));
        this.builder.setType("beam:metrics:distribution_double:v1");
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setStringSetValue(@UnknownKeyFor @NonNull @Initialized StringSetData value) {
        this.builder.setPayload(MonitoringInfoEncodings.encodeStringSet(value));
        this.builder.setType("beam:metrics:set_string:v1");
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setLabel(@UnknownKeyFor @NonNull @Initialized String labelName, @UnknownKeyFor @NonNull @Initialized String labelValue) {
        this.builder.putLabels(labelName, labelValue);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized SimpleMonitoringInfoBuilder setLabels(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labels) {
        this.builder.putAllLabels(labels);
        return this;
    }

    public void clear() {
        this.builder = MetricsApi.MonitoringInfo.newBuilder();
    }

    public void merge(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized MetricsApi.MonitoringInfo monitoringInfo) {
        this.builder.mergeFrom(monitoringInfo);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable @UnknownKeyFor @Initialized MetricsApi.MonitoringInfo build() {
        MetricsApi.MonitoringInfo result = this.builder.build();
        if (this.validateAndDropInvalid && VALIDATOR.validate(result).isPresent()) {
            return null;
        }
        return result;
    }

    static {
        for (MetricsApi.MonitoringInfoSpecs.Enum val : MetricsApi.MonitoringInfoSpecs.Enum.values()) {
            if (val.name().equals("UNRECOGNIZED")) continue;
            MetricsApi.MonitoringInfoSpec spec = (MetricsApi.MonitoringInfoSpec)val.getValueDescriptor().getOptions().getExtension(MetricsApi.monitoringInfoSpec);
            KNOWN_SPECS.put(spec.getUrn(), spec);
        }
    }
}

