/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.replacestring;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.replacestring.ReplaceString;
import org.apache.hop.pipeline.transforms.replacestring.ReplaceStringData;

@Transform(id="ReplaceString", image="replaceinstring.svg", name="i18n::ReplaceString.Name", description="i18n::ReplaceString.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::ReplaceStringMeta.keyword"}, documentationUrl="/pipeline/transforms/replacestring.html")
public class ReplaceStringMeta
extends BaseTransformMeta<ReplaceString, ReplaceStringData> {
    private static final Class<?> PKG = ReplaceStringMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionGroupDescription="ReplaceString.Injection.FIELDS")
    private List<RSField> fields = new ArrayList<RSField>();

    public ReplaceStringMeta() {
    }

    public ReplaceStringMeta(ReplaceStringMeta m) {
        this();
        m.fields.forEach(f -> this.fields.add(new RSField((RSField)f)));
    }

    public ReplaceStringMeta clone() {
        return new ReplaceStringMeta(this);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        for (RSField field : this.fields) {
            ValueMetaString valueMeta;
            String fieldName = variables.resolve(field.getFieldOutStream());
            if (!Utils.isEmpty((CharSequence)field.getFieldOutStream())) {
                valueMeta = new ValueMetaString(fieldName);
                valueMeta.setOrigin(name);
                IValueMeta sourceField = inputRowMeta.searchValueMeta(field.getFieldInStream());
                if (sourceField != null) {
                    valueMeta.setStringEncoding(sourceField.getStringEncoding());
                }
                inputRowMeta.addValueMeta((IValueMeta)valueMeta);
                continue;
            }
            valueMeta = inputRowMeta.searchValueMeta(field.getFieldInStream());
            if (valueMeta == null) continue;
            valueMeta.setStorageType(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        StringBuilder errorMessage = new StringBuilder();
        boolean first = true;
        boolean errorFound = false;
        if (prev == null) {
            errorMessage.append(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.NoInputReceived", (String[])new String[0])).append(Const.CR);
            CheckResult cr = new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            void var15_22;
            IValueMeta v;
            String fieldIn;
            for (RSField rSField : this.fields) {
                fieldIn = rSField.getFieldInStream();
                v = prev.searchValueMeta(fieldIn);
                if (v != null) continue;
                if (first) {
                    first = false;
                    errorMessage.append(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.MissingInStreamFields", (String[])new String[0])).append(Const.CR);
                }
                errorFound = true;
                errorMessage.append("\t\t").append(fieldIn).append(Const.CR);
            }
            CheckResult cr = errorFound ? new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.FoundInStreamFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            first = true;
            errorFound = false;
            for (RSField rSField : this.fields) {
                fieldIn = rSField.getFieldInStream();
                v = prev.searchValueMeta(fieldIn);
                if (v == null || v.getType() == 2) continue;
                if (first) {
                    first = false;
                    errorMessage.append(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.OperationOnNonStringFields", (String[])new String[0])).append(Const.CR);
                }
                errorFound = true;
                errorMessage.append("\t\t").append(fieldIn).append(Const.CR);
            }
            cr = errorFound ? new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.AllOperationsOnStringFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            int x = 0;
            for (RSField field : this.fields) {
                ++x;
                if (!Utils.isEmpty((CharSequence)field.getFieldInStream())) continue;
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.InStreamFieldMissing", (String[])new String[]{Integer.toString(x)}), (ICheckResultSource)transforminfo);
                remarks.add((ICheckResult)cr);
            }
            boolean bl = false;
            while (var15_22 < this.fields.size()) {
                for (int jdx = 0; jdx < this.fields.size(); ++jdx) {
                    RSField field1 = this.fields.get((int)var15_22);
                    RSField field2 = this.fields.get(jdx);
                    if (!field1.getFieldInStream().equals(field2.getFieldInStream()) || var15_22 >= jdx) continue;
                    String errMessage = BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.FieldInputError", (String[])new String[]{field1.getFieldInStream()});
                    cr = new CheckResult(4, errMessage, (ICheckResultSource)transforminfo);
                    remarks.add((ICheckResult)cr);
                }
                ++var15_22;
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public List<RSField> getFields() {
        return this.fields;
    }

    public void setFields(List<RSField> fields) {
        this.fields = fields;
    }

    public static final class RSField {
        @HopMetadataProperty(key="in_stream_name", injectionKey="FIELD_IN_STREAM", injectionKeyDescription="ReplaceString.Injection.FIELD_IN_STREAM")
        private String fieldInStream;
        @HopMetadataProperty(key="out_stream_name", injectionKey="FIELD_OUT_STREAM", injectionKeyDescription="ReplaceString.Injection.FIELD_OUT_STREAM")
        private String fieldOutStream;
        @HopMetadataProperty(key="use_regex", injectionKey="USE_REGEX", injectionKeyDescription="ReplaceString.Injection.USE_REGEX")
        private boolean usingRegEx;
        @HopMetadataProperty(key="replace_string", injectionKey="REPLACE_STRING", injectionKeyDescription="ReplaceString.Injection.REPLACE_STRING")
        private String replaceString;
        @HopMetadataProperty(key="replace_by_string", injectionKey="REPLACE_BY", injectionKeyDescription="ReplaceString.Injection.REPLACE_BY")
        private String replaceByString;
        @HopMetadataProperty(key="set_empty_string", injectionKey="EMPTY_STRING", injectionKeyDescription="ReplaceString.Injection.EMPTY_STRING")
        private boolean settingEmptyString;
        @HopMetadataProperty(key="replace_field_by_string", injectionKey="REPLACE_WITH_FIELD", injectionKeyDescription="ReplaceString.Injection.REPLACE_WITH_FIELD")
        private String replaceFieldByString;
        @HopMetadataProperty(key="whole_word", injectionKey="REPLACE_WHOLE_WORD", injectionKeyDescription="ReplaceString.Injection.REPLACE_WHOLE_WORD")
        private boolean replacingWholeWord;
        @HopMetadataProperty(key="case_sensitive", injectionKey="CASE_SENSITIVE", injectionKeyDescription="ReplaceString.Injection.CASE_SENSITIVE")
        private boolean caseSensitive;
        @HopMetadataProperty(key="is_unicode", injectionKey="IS_UNICODE", injectionKeyDescription="ReplaceString.Injection.IS_UNICODE")
        private boolean unicode;

        public RSField() {
        }

        public RSField(RSField f) {
            this();
            this.fieldInStream = f.fieldInStream;
            this.fieldOutStream = f.fieldOutStream;
            this.usingRegEx = f.usingRegEx;
            this.replaceString = f.replaceString;
            this.replaceByString = f.replaceByString;
            this.settingEmptyString = f.settingEmptyString;
            this.replaceFieldByString = f.replaceFieldByString;
            this.replacingWholeWord = f.replacingWholeWord;
            this.caseSensitive = f.caseSensitive;
            this.unicode = f.unicode;
        }

        public String getFieldInStream() {
            return this.fieldInStream;
        }

        public void setFieldInStream(String fieldInStream) {
            this.fieldInStream = fieldInStream;
        }

        public String getFieldOutStream() {
            return this.fieldOutStream;
        }

        public void setFieldOutStream(String fieldOutStream) {
            this.fieldOutStream = fieldOutStream;
        }

        public boolean isUsingRegEx() {
            return this.usingRegEx;
        }

        public void setUsingRegEx(boolean usingRegEx) {
            this.usingRegEx = usingRegEx;
        }

        public String getReplaceString() {
            return this.replaceString;
        }

        public void setReplaceString(String replaceString) {
            this.replaceString = replaceString;
        }

        public String getReplaceByString() {
            return this.replaceByString;
        }

        public void setReplaceByString(String replaceByString) {
            this.replaceByString = replaceByString;
        }

        public boolean isSettingEmptyString() {
            return this.settingEmptyString;
        }

        public void setSettingEmptyString(boolean settingEmptyString) {
            this.settingEmptyString = settingEmptyString;
        }

        public String getReplaceFieldByString() {
            return this.replaceFieldByString;
        }

        public void setReplaceFieldByString(String replaceFieldByString) {
            this.replaceFieldByString = replaceFieldByString;
        }

        public boolean isReplacingWholeWord() {
            return this.replacingWholeWord;
        }

        public void setReplacingWholeWord(boolean replacingWholeWord) {
            this.replacingWholeWord = replacingWholeWord;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public boolean isUnicode() {
            return this.unicode;
        }

        public void setUnicode(boolean unicode) {
            this.unicode = unicode;
        }
    }
}

