/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserList;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUserList;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VUserAndGroup
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String allUsersText_ = ResourceLoader.getText("USER_ALL_USERS").trim();
    private static final String usersNotInGroupsText_ = ResourceLoader.getText("USER_USERS_NOT_IN_GROUPS").trim();
    private static final String groupsText_ = ResourceLoader.getText("USER_GROUPS").trim();
    private static Icon icon16_ = ResourceLoader.getIcon("VUserList16.gif", ResourceLoader.getText("USER_LIST_DESCRIPTION"));
    private static Icon icon32_ = ResourceLoader.getIcon("VUserList32.gif", ResourceLoader.getText("USER_LIST_DESCRIPTION"));
    private AS400 as400_;
    private VNode parent_;
    private transient VNode[] children_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    private static TableColumnModel detailsColumnModel_;
    private static String nameColumnHeader_;
    private static String descriptionColumnHeader_;
    private static String description_;

    public VUserAndGroup(AS400 as400) {
        if (as400 == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = as400;
        this.initializeTransient();
    }

    public VUserAndGroup(VNode parent, AS400 system) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = system;
        this.parent_ = parent;
        this.initializeTransient();
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    @Override
    public VAction[] getActions() {
        return null;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0 || index >= this.children_.length) {
            return null;
        }
        return this.children_[index];
    }

    @Override
    public int getChildCount() {
        return this.children_.length;
    }

    @Override
    public VAction getDefaultAction() {
        return null;
    }

    @Override
    public VObject getDetailsChildAt(int index) {
        if (index < 0 || index >= this.children_.length) {
            return null;
        }
        return this.children_[index];
    }

    @Override
    public int getDetailsChildCount() {
        return this.children_.length;
    }

    @Override
    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    @Override
    public int getDetailsIndex(VObject detailsChild) {
        for (int i = 0; i < this.children_.length; ++i) {
            if (!this.children_[i].equals(detailsChild)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Icon getIcon(int size, boolean open) {
        if (size != 32) {
            return icon16_;
        }
        return icon32_;
    }

    @Override
    public int getIndex(TreeNode child) {
        for (int index = 0; index < this.children_.length; ++index) {
            if (!this.children_[index].equals(child)) continue;
            return index;
        }
        return -1;
    }

    private String getListName(UserList userList) {
        String userInfo = userList.getUserInfo();
        String groupInfo = userList.getGroupInfo();
        if (userInfo.toLowerCase().equals("*all") && groupInfo.toLowerCase().equals("*none")) {
            return allUsersText_;
        }
        if (userInfo.toLowerCase().equals("*member") && groupInfo.toLowerCase().equals("*nogroup")) {
            return usersNotInGroupsText_;
        }
        if (userInfo.toLowerCase().equals("*group") && groupInfo.toLowerCase().equals("*none")) {
            return groupsText_;
        }
        Trace.log(2, "userInfo or groupInfo's value is invalid");
        Trace.log(3, "userInfo : " + userInfo);
        Trace.log(3, "groupInfo : " + groupInfo);
        return "";
    }

    @Override
    public TreeNode getParent() {
        return this.parent_;
    }

    @Override
    public VPropertiesPane getPropertiesPane() {
        return null;
    }

    @Override
    public Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public AS400 getSystem() {
        return this.as400_;
    }

    @Override
    public String getText() {
        return description_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.children_ = new VUserList[3];
        UserList[] listchild = new UserList[]{new UserList(this.as400_, "*ALL", "*NONE"), new UserList(this.as400_, "*GROUP", "*NONE"), new UserList(this.as400_, "*MEMBER", "*NOGROUP")};
        for (int i = 0; i < 3; ++i) {
            this.children_[i] = new VUserList(listchild[i], this.getListName(listchild[i]));
            ((VUserList)this.children_[i]).parent_ = this;
            this.children_[i].addErrorListener(this.errorEventSupport_);
            this.children_[i].addVObjectListener(this.objectEventSupport_);
            this.children_[i].addWorkingListener(this.workingEventSupport_);
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public void load() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.as400_.connectService(2);
            for (int i = 0; i < this.children_.length; ++i) {
                this.children_[i].load();
            }
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    @Override
    public void sortDetailsChildren(Object[] propertyIdentifiers, boolean[] orders) {
    }

    public String toString() {
        return description_;
    }

    static {
        nameColumnHeader_ = ResourceLoader.getText("USER_LIST_NAME");
        descriptionColumnHeader_ = ResourceLoader.getText("USER_DESCRIPTION_PROMPT");
        description_ = ResourceLoader.getText("USER_USER_AND_GROUP");
        detailsColumnModel_ = new DefaultTableColumnModel();
        int i = 0;
        VTableColumn vTable1 = new VTableColumn(i++, NAME_PROPERTY);
        vTable1.setCellRenderer(new VObjectCellRenderer());
        vTable1.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable1.setHeaderValue(nameColumnHeader_);
        vTable1.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTable1);
        VTableColumn vTable2 = new VTableColumn(i++, DESCRIPTION_PROPERTY);
        vTable2.setCellRenderer(new VObjectCellRenderer());
        vTable2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable2.setHeaderValue(descriptionColumnHeader_);
        vTable2.setPreferredCharWidth(70);
        detailsColumnModel_.addColumn(vTable2);
    }
}

