/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DDMReplyDataStream;
import java.io.IOException;
import java.util.Vector;

class DDMAS400MessageReply
extends DDMReplyDataStream {
    ConverterImplRemote conv;
    Vector messages_ = new Vector();
    String msgId_ = null;
    String msgText_ = null;
    int svrCode_ = -1;

    DDMAS400MessageReply(AS400ImplRemote system, byte[] data) throws AS400SecurityException, InterruptedException, IOException {
        super(data);
        this.conv = ConverterImplRemote.getConverter(system.getCcsid(), system);
        this.parseMessageInfo();
    }

    AS400Message getAS400Message() {
        return this.messages_.size() > 0 ? (AS400Message)this.messages_.elementAt(0) : new AS400Message();
    }

    AS400Message[] getAS400MessageList() {
        if (this.messages_.size() > 0) {
            Object[] msgList = new AS400Message[this.messages_.size()];
            this.messages_.copyInto(msgList);
            return msgList;
        }
        return new AS400Message[0];
    }

    void parseMessageInfo() {
        int length;
        for (int offset = 8; offset < this.data_.length; offset += length) {
            int codePoint = this.get16bit(offset);
            length = this.get16bit(offset - 2);
            if (codePoint != 53761) continue;
            AS400Message msg = this.getMessage(offset + 2, length - 4);
            this.messages_.addElement(msg);
        }
    }

    AS400Message getMessage(int offset, int len) {
        int end = offset + len;
        boolean done = false;
        int codePoint = this.get16bit(offset + 2);
        block6: while (!done && offset < end) {
            int length = this.get16bit(offset);
            codePoint = this.get16bit(offset + 2);
            switch (codePoint) {
                case 4425: {
                    this.svrCode_ = this.get16bit(offset + 4);
                    offset += length;
                    continue block6;
                }
                case 53522: {
                    this.msgId_ = this.conv.byteArrayToString(this.data_, offset + 4, length - 4);
                    offset += length;
                    continue block6;
                }
                case 53526: {
                    this.msgText_ = this.conv.byteArrayToString(this.data_, offset + 6, this.get16bit(offset + 4));
                    offset += length;
                    continue block6;
                }
                case 4435: 
                case 53518: 
                case 53521: 
                case 53527: {
                    offset += length;
                    continue block6;
                }
            }
            done = true;
        }
        AS400Message msg = new AS400Message(this.msgId_, this.msgText_);
        if (this.svrCode_ != -1) {
            msg.setSeverity(this.svrCode_);
        }
        return msg;
    }
}

