/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ExecutionEnvironment;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class Converter
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final String BUFFER_OVERFLOWED = "Converted field overflows destination array.";
    public transient ConverterImpl impl;
    private String encoding_ = null;
    private int ccsid_ = -1;
    private AS400 system_ = null;

    public Converter() {
        this.ccsid_ = ExecutionEnvironment.getBestGuessAS400Ccsid();
        try {
            this.chooseImpl();
        }
        catch (UnsupportedEncodingException e) {
            Trace.log(2, "Unexpected CCSID returned from getBestGuessAS400Ccsid: " + this.ccsid_, (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    public Converter(String encoding) throws UnsupportedEncodingException {
        this.encoding_ = encoding;
        this.chooseImpl();
    }

    public Converter(int ccsid) throws UnsupportedEncodingException {
        this.ccsid_ = ccsid;
        this.chooseImpl();
    }

    public Converter(int ccsid, AS400 system) throws UnsupportedEncodingException {
        this.ccsid_ = ccsid;
        this.system_ = system;
        this.chooseImpl();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.chooseImpl();
    }

    private void chooseImpl() throws UnsupportedEncodingException {
        if (this.system_ == null) {
            this.impl = (ConverterImpl)AS400.loadImpl("com.ibm.as400.access.ConverterImplRemote");
            if (this.impl == null) {
                throw new UnsupportedEncodingException();
            }
            if (this.encoding_ != null) {
                this.impl.setEncoding(this.encoding_);
            } else {
                this.impl.setCcsid(this.ccsid_, null);
            }
        } else {
            this.impl = (ConverterImpl)this.system_.loadImpl2("com.ibm.as400.access.ConverterImplRemote", "com.ibm.as400.access.ConverterImplProxy");
            AS400Impl systemImpl = this.system_.getImpl();
            try {
                this.impl.setCcsid(this.ccsid_, systemImpl);
            }
            catch (UnsupportedEncodingException e) {
                try {
                    this.system_.connectService(6);
                    this.impl.setCcsid(this.ccsid_, systemImpl);
                }
                catch (Exception ee) {
                    throw e;
                }
            }
        }
    }

    public String byteArrayToString(byte[] source) {
        return this.impl.byteArrayToString(source, 0, source.length);
    }

    public String byteArrayToString(byte[] source, int offset) {
        return this.impl.byteArrayToString(source, offset, source.length - offset);
    }

    public String byteArrayToString(byte[] source, int offset, int length) {
        return this.impl.byteArrayToString(source, offset, length);
    }

    String byteArrayToString(byte[] source, int offset, int length, int type) {
        return this.byteArrayToString(source, offset, length, new BidiConversionProperties(type));
    }

    String byteArrayToString(byte[] source, int offset, int length, BidiConversionProperties properties) {
        return this.impl.byteArrayToString(source, offset, length, properties);
    }

    public int getCcsid() {
        return this.impl.getCcsid();
    }

    public String getEncoding() {
        return this.impl.getEncoding();
    }

    public byte[] stringToByteArray(String source) {
        return this.impl.stringToByteArray(source);
    }

    byte[] stringToByteArray(String source, int type) {
        return this.stringToByteArray(source, new BidiConversionProperties(type));
    }

    byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        return this.impl.stringToByteArray(source, properties);
    }

    public void stringToByteArray(String source, byte[] destination) throws CharConversionException {
        byte[] convertedBytes = this.impl.stringToByteArray(source);
        if (convertedBytes.length > destination.length) {
            System.arraycopy(convertedBytes, 0, destination, 0, destination.length);
            Trace.log(2, BUFFER_OVERFLOWED);
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, 0, convertedBytes.length);
    }

    public void stringToByteArray(String source, byte[] destination, int offset) throws CharConversionException {
        byte[] convertedBytes = this.impl.stringToByteArray(source);
        if (convertedBytes.length > destination.length - offset) {
            System.arraycopy(convertedBytes, 0, destination, offset, destination.length - offset);
            Trace.log(2, BUFFER_OVERFLOWED);
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, offset, convertedBytes.length);
    }

    public void stringToByteArray(String source, byte[] destination, int offset, int length) throws CharConversionException {
        byte[] convertedBytes = this.impl.stringToByteArray(source);
        if (convertedBytes.length > length) {
            System.arraycopy(convertedBytes, 0, destination, offset, length);
            Trace.log(2, BUFFER_OVERFLOWED);
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, offset, convertedBytes.length);
    }

    void stringToByteArray(String source, byte[] destination, int offset, int length, int type) throws CharConversionException {
        this.stringToByteArray(source, destination, offset, length, new BidiConversionProperties(type));
    }

    void stringToByteArray(String source, byte[] destination, int offset, int length, BidiConversionProperties properties) throws CharConversionException {
        byte[] convertedBytes = this.impl.stringToByteArray(source, properties);
        if (convertedBytes.length > length) {
            System.arraycopy(convertedBytes, 0, destination, offset, length);
            Trace.log(2, BUFFER_OVERFLOWED);
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, offset, convertedBytes.length);
    }

    public byte[] charArrayToByteArray(char[] source) {
        return this.impl.charArrayToByteArray(source);
    }

    byte[] charArrayToByteArray(char[] source, int type) {
        return this.charArrayToByteArray(source, new BidiConversionProperties(type));
    }

    byte[] charArrayToByteArray(char[] source, BidiConversionProperties properties) {
        return this.impl.charArrayToByteArray(source, properties);
    }

    public void charArrayToByteArray(char[] source, byte[] destination) throws CharConversionException {
        byte[] convertedBytes = this.impl.charArrayToByteArray(source);
        if (convertedBytes.length > destination.length) {
            System.arraycopy(convertedBytes, 0, destination, 0, destination.length);
            Trace.log(2, BUFFER_OVERFLOWED);
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, 0, convertedBytes.length);
    }

    public void charArrayToByteArray(char[] source, byte[] destination, int offset) throws CharConversionException {
        byte[] convertedBytes = this.impl.charArrayToByteArray(source);
        if (convertedBytes.length > destination.length - offset) {
            System.arraycopy(convertedBytes, 0, destination, offset, destination.length - offset);
            Trace.log(2, BUFFER_OVERFLOWED);
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, offset, convertedBytes.length);
    }

    public void charArrayToByteArray(char[] source, byte[] destination, int offset, int length) throws CharConversionException {
        byte[] convertedBytes = this.impl.charArrayToByteArray(source);
        if (convertedBytes.length > length) {
            System.arraycopy(convertedBytes, 0, destination, offset, length);
            Trace.log(2, BUFFER_OVERFLOWED);
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, offset, convertedBytes.length);
    }

    void charArrayToByteArray(char[] source, byte[] destination, int offset, int length, int type) throws CharConversionException {
        this.charArrayToByteArray(source, destination, offset, length, new BidiConversionProperties(type));
    }

    void charArrayToByteArray(char[] source, byte[] destination, int offset, int length, BidiConversionProperties properties) throws CharConversionException {
        byte[] convertedBytes = this.impl.charArrayToByteArray(source, properties);
        if (convertedBytes.length > length) {
            System.arraycopy(convertedBytes, 0, destination, offset, length);
            Trace.log(2, BUFFER_OVERFLOWED);
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, offset, convertedBytes.length);
    }

    public char[] byteArrayToCharArray(byte[] source, int offset, int length) {
        return this.impl.byteArrayToCharArray(source, offset, length);
    }

    char[] byteArrayToCharArray(byte[] source, int offset, int length, int type) {
        return this.byteArrayToCharArray(source, offset, length, new BidiConversionProperties(type));
    }

    char[] byteArrayToCharArray(byte[] source, int offset, int length, BidiConversionProperties properties) {
        return this.impl.byteArrayToCharArray(source, offset, length, properties);
    }
}

