/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.deser;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.avro.deser.AvroParserImpl;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.AvroStructureReader;
import java.io.IOException;

public abstract class AvroFieldReader {
    protected final String _name;
    protected final boolean _isSkipper;
    protected final String _typeId;

    protected AvroFieldReader(String name, boolean isSkipper, String typeId) {
        this._name = name;
        this._isSkipper = isSkipper;
        this._typeId = typeId;
    }

    public static AvroFieldReader construct(String name, AvroStructureReader structureReader) {
        return new Structured(name, false, structureReader);
    }

    public static AvroFieldReader constructSkipper(String name, AvroStructureReader structureReader) {
        return new Structured(name, true, structureReader);
    }

    public final String getName() {
        return this._name;
    }

    public final boolean isSkipper() {
        return this._isSkipper;
    }

    public abstract JsonToken readValue(AvroReadContext var1, AvroParserImpl var2) throws IOException;

    public abstract void skipValue(AvroParserImpl var1) throws IOException;

    public String getTypeId() {
        return this._typeId;
    }

    private static final class Structured
    extends AvroFieldReader {
        protected final AvroStructureReader _reader;

        public Structured(String name, boolean skipper, AvroStructureReader r) {
            super(name, skipper, null);
            this._reader = r;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
            return this._reader.newReader(parent, parser).nextToken();
        }

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
            this._reader.skipValue(parser);
        }

        @Override
        public String getTypeId() {
            return this._reader.getTypeId();
        }
    }
}

