/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeAlarmHistoryRequestMarshaller
implements Marshaller<Request<DescribeAlarmHistoryRequest>, DescribeAlarmHistoryRequest> {
    public Request<DescribeAlarmHistoryRequest> marshall(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        if (describeAlarmHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmHistoryRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAlarmHistory");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAlarmHistoryRequest.getAlarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)describeAlarmHistoryRequest.getAlarmName()));
        }
        if (!describeAlarmHistoryRequest.getAlarmTypes().isEmpty() || !((SdkInternalList)describeAlarmHistoryRequest.getAlarmTypes()).isAutoConstruct()) {
            SdkInternalList alarmTypesList = (SdkInternalList)describeAlarmHistoryRequest.getAlarmTypes();
            int alarmTypesListIndex = 1;
            for (String alarmTypesListValue : alarmTypesList) {
                if (alarmTypesListValue != null) {
                    request.addParameter("AlarmTypes.member." + alarmTypesListIndex, StringUtils.fromString((String)alarmTypesListValue));
                }
                ++alarmTypesListIndex;
            }
        }
        if (describeAlarmHistoryRequest.getHistoryItemType() != null) {
            request.addParameter("HistoryItemType", StringUtils.fromString((String)describeAlarmHistoryRequest.getHistoryItemType()));
        }
        if (describeAlarmHistoryRequest.getStartDate() != null) {
            request.addParameter("StartDate", StringUtils.fromDate((Date)describeAlarmHistoryRequest.getStartDate()));
        }
        if (describeAlarmHistoryRequest.getEndDate() != null) {
            request.addParameter("EndDate", StringUtils.fromDate((Date)describeAlarmHistoryRequest.getEndDate()));
        }
        if (describeAlarmHistoryRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAlarmHistoryRequest.getMaxRecords()));
        }
        if (describeAlarmHistoryRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAlarmHistoryRequest.getNextToken()));
        }
        if (describeAlarmHistoryRequest.getScanBy() != null) {
            request.addParameter("ScanBy", StringUtils.fromString((String)describeAlarmHistoryRequest.getScanBy()));
        }
        return request;
    }
}

