/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.changefileencoding;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.changefileencoding.ChangeFileEncoding;
import org.apache.hop.pipeline.transforms.changefileencoding.ChangeFileEncodingData;

@Transform(id="ChangeFileEncoding", image="changefileencoding.svg", name="i18n::ChangeFileEncoding.Name", description="i18n::ChangeFileEncoding.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::ChangeFileEncodingMeta.keyword"}, documentationUrl="/pipeline/transforms/changefileencoding.html")
public class ChangeFileEncodingMeta
extends BaseTransformMeta<ChangeFileEncoding, ChangeFileEncodingData> {
    private static final Class<?> PKG = ChangeFileEncoding.class;
    @HopMetadataProperty(key="addsourceresultfilenames", injectionKeyDescription="ChangeFileEncoding.Injection.AddSourceResultFilenames")
    private boolean addSourceResultFilenames;
    @HopMetadataProperty(key="addtargetresultfilenames", injectionKeyDescription="ChangeFileEncoding.Injection.AddTargetResultFilenames")
    private boolean addTargetResultFilenames;
    @HopMetadataProperty(key="filenamefield", injectionKeyDescription="ChangeFileEncoding.Injection.FilenameField")
    private String filenameField;
    @HopMetadataProperty(key="targetfilenamefield", injectionKeyDescription="ChangeFileEncoding.Injection.TargetFilenameField")
    private String targetFilenameField;
    @HopMetadataProperty(key="targetencoding", injectionKeyDescription="ChangeFileEncoding.Injection.TargetEncoding")
    private String targetEncoding;
    @HopMetadataProperty(key="sourceencoding", injectionKeyDescription="ChangeFileEncoding.Injection.SourceEncoding")
    private String sourceEncoding;
    @HopMetadataProperty(key="createparentfolder", injectionKeyDescription="ChangeFileEncoding.Injection.CreateParentFolder")
    private boolean createParentFolder;

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenamefield) {
        this.filenameField = filenamefield;
    }

    public String getTargetFilenameField() {
        return this.targetFilenameField;
    }

    public void setTargetFilenameField(String targetfilenamefield) {
        this.targetFilenameField = targetfilenamefield;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String encoding) {
        this.sourceEncoding = encoding;
    }

    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    public void setTargetEncoding(String encoding) {
        this.targetEncoding = encoding;
    }

    public boolean isAddSourceResultFilenames() {
        return this.addSourceResultFilenames;
    }

    public void setAddSourceResultFilenames(boolean addresultfilenames) {
        this.addSourceResultFilenames = addresultfilenames;
    }

    public boolean isAddTargetResultFilenames() {
        return this.addTargetResultFilenames;
    }

    public void setAddTargetResultFilenames(boolean addresultfilenames) {
        this.addTargetResultFilenames = addresultfilenames;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createParentFolder = createparentfolder;
    }

    public Object clone() {
        ChangeFileEncodingMeta retval = (ChangeFileEncodingMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.addSourceResultFilenames = false;
        this.addTargetResultFilenames = false;
        this.targetFilenameField = null;
        this.sourceEncoding = System.getProperty("file.encoding");
        this.targetEncoding = null;
        this.createParentFolder = false;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.filenameField)) {
            errorMessage = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.FileFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.FileFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.targetFilenameField)) {
            errorMessage = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.TargetFileFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.TargetFileFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        String realSourceEncoding = variables.resolve(this.getSourceEncoding());
        if (Utils.isEmpty((CharSequence)realSourceEncoding)) {
            errorMessage = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.SourceEncodingMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.SourceEncodingOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        String realTargetEncoding = variables.resolve(this.getTargetEncoding());
        if (Utils.isEmpty((CharSequence)realTargetEncoding)) {
            errorMessage = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.TargetEncodingMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.TargetEncodingOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

