/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.main.RemovableRollFileCandidatesMain;
import net.openhft.chronicle.queue.util.FileState;
import org.jetbrains.annotations.NotNull;

public final class InternalFileUtil {
    private static final Comparator<File> EARLIEST_FIRST = Comparator.comparing(File::getName);

    private InternalFileUtil() {
    }

    @Deprecated
    public static void main(String[] args) {
        RemovableRollFileCandidatesMain.main(args);
    }

    @NotNull
    public static Stream<File> removableRollFileCandidates(@NotNull File baseDir) {
        File file;
        InternalFileUtil.assertOsSupported();
        File[] files = baseDir.listFiles(InternalFileUtil::hasQueueSuffix);
        if (files == null) {
            return Stream.empty();
        }
        List sortedInitialCandidates = Stream.of(files).sorted(EARLIEST_FIRST).collect(Collectors.toList());
        Stream.Builder<File> builder = Stream.builder();
        Iterator iterator = sortedInitialCandidates.iterator();
        while (iterator.hasNext() && InternalFileUtil.state(file = (File)iterator.next()) == FileState.CLOSED) {
            builder.accept(file);
        }
        return builder.build();
    }

    public static boolean hasQueueSuffix(@NotNull File file) {
        return file.getName().endsWith(".cq4");
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static FileState state(@NotNull File file) {
        InternalFileUtil.assertOsSupported();
        if (!file.exists()) {
            return FileState.NON_EXISTENT;
        }
        String absolutePath = file.getAbsolutePath();
        try {
            Process process = new ProcessBuilder("lsof", "|", "grep", absolutePath).start();
            try {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    FileState fileState = reader.lines().anyMatch(l -> l.contains(absolutePath)) ? FileState.OPEN : FileState.CLOSED;
                    return fileState;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                process.destroyForcibly();
            }
        }
        catch (IOException iOException) {
            return FileState.UNDETERMINED;
        }
    }

    /*
     * Exception decompiling
     */
    private static FileState stateWindows(@NotNull File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void assertOsSupported() {
        if (OS.isWindows()) {
            throw new UnsupportedOperationException("This operation is not supported under Windows.");
        }
    }
}

