/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;

public class FlameGraphTypeQueryParameter
extends MessageQueryParameter<Type> {
    public static final String KEY = "type";

    public FlameGraphTypeQueryParameter() {
        super(KEY, MessageParameter.MessageParameterRequisiteness.OPTIONAL);
    }

    @Override
    public Type convertStringToValue(String value) {
        return Type.valueOf(value.toUpperCase());
    }

    @Override
    public String convertValueToString(Type value) {
        return value.name().toLowerCase();
    }

    @Override
    public String getDescription() {
        return "String value that specifies the Flame Graph type. Supported options are: \"" + Arrays.toString((Object[])Type.values()) + "\".";
    }

    @Schema(name="ThreadStates")
    public static enum Type {
        FULL,
        ON_CPU,
        OFF_CPU;

    }
}

