/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SetCoder<@UnknownKeyFor T>
extends IterableLikeCoder<T, Set<T>> {
    public static <T> @UnknownKeyFor @NonNull @Initialized SetCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder) {
        return new SetCoder<T>(elementCoder);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Ordering of elements in a set may be non-deterministic.");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Set<T>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<Set<T>>(){}.where(new TypeParameter<T>(){}, this.getElemCoder().getEncodedTypeDescriptor());
    }

    @Override
    protected final @UnknownKeyFor @NonNull @Initialized Set<T> decodeToIterable(@UnknownKeyFor @NonNull @Initialized List<T> decodedElements) {
        return new HashSet<T>(decodedElements);
    }

    protected SetCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
        super(elemCoder, "Set");
    }
}

