/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.JMXConfiguratorMBean;
import ch.qos.logback.classic.spi.TurboFilterList;
import ch.qos.logback.classic.turbo.ReconfigureOnChangeFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.hook.DelayingShutdownHook;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.JMX;
import javax.management.ObjectName;
import org.apache.cassandra.security.ThreadAwareSecurityManager;
import org.apache.cassandra.utils.logging.LoggingSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackLoggingSupport
implements LoggingSupport {
    private static final Logger logger = LoggerFactory.getLogger(LogbackLoggingSupport.class);

    @Override
    public void onStartup() {
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger(ThreadAwareSecurityManager.class);
        LoggerContext ctx = logbackLogger.getLoggerContext();
        TurboFilterList turboFilterList = ctx.getTurboFilterList();
        for (int i = 0; i < turboFilterList.size(); ++i) {
            TurboFilter turboFilter = (TurboFilter)turboFilterList.get(i);
            if (!(turboFilter instanceof ReconfigureOnChangeFilter)) continue;
            ReconfigureOnChangeFilter reconfigureOnChangeFilter = (ReconfigureOnChangeFilter)turboFilter;
            turboFilterList.set(i, (Object)new SMAwareReconfigureOnChangeFilter(reconfigureOnChangeFilter));
            break;
        }
    }

    @Override
    public void onShutdown() {
        DelayingShutdownHook logbackHook = new DelayingShutdownHook();
        logbackHook.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
        logbackHook.run();
    }

    @Override
    public void setLoggingLevel(String classQualifier, String rawLevel) throws Exception {
        ch.qos.logback.classic.Logger logBackLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)classQualifier);
        if (StringUtils.isBlank((CharSequence)classQualifier) && StringUtils.isBlank((CharSequence)rawLevel)) {
            JMXConfiguratorMBean jmxConfiguratorMBean = JMX.newMBeanProxy(ManagementFactory.getPlatformMBeanServer(), new ObjectName("ch.qos.logback.classic:Name=default,Type=ch.qos.logback.classic.jmx.JMXConfigurator"), JMXConfiguratorMBean.class);
            jmxConfiguratorMBean.reloadDefaultConfiguration();
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)classQualifier) && StringUtils.isBlank((CharSequence)rawLevel)) {
            if (logBackLogger.getLevel() != null || this.hasAppenders(logBackLogger)) {
                logBackLogger.setLevel(null);
            }
            return;
        }
        Level level = Level.toLevel((String)rawLevel);
        logBackLogger.setLevel(level);
        logger.info("set log level to {} for classes under '{}' (if the level doesn't look like '{}' then the logger couldn't parse '{}')", new Object[]{level, classQualifier, rawLevel, rawLevel});
    }

    @Override
    public Map<String, String> getLoggingLevels() {
        LinkedHashMap logLevelMaps = Maps.newLinkedHashMap();
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (ch.qos.logback.classic.Logger logBackLogger : lc.getLoggerList()) {
            if (logBackLogger.getLevel() == null && !this.hasAppenders(logBackLogger)) continue;
            logLevelMaps.put(logBackLogger.getName(), logBackLogger.getLevel().toString());
        }
        return logLevelMaps;
    }

    private boolean hasAppenders(ch.qos.logback.classic.Logger logBackLogger) {
        Iterator it = logBackLogger.iteratorForAppenders();
        return it.hasNext();
    }

    private static class SMAwareReconfigureOnChangeFilter
    extends ReconfigureOnChangeFilter {
        SMAwareReconfigureOnChangeFilter(ReconfigureOnChangeFilter reconfigureOnChangeFilter) {
            this.setRefreshPeriod(reconfigureOnChangeFilter.getRefreshPeriod());
            this.setName(reconfigureOnChangeFilter.getName());
            this.setContext(reconfigureOnChangeFilter.getContext());
            if (reconfigureOnChangeFilter.isStarted()) {
                reconfigureOnChangeFilter.stop();
                this.start();
            }
        }

        protected boolean changeDetected(long now) {
            if (ThreadAwareSecurityManager.isSecuredThread()) {
                return false;
            }
            return super.changeDetected(now);
        }
    }
}

