/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.Condition;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventType;
import org.apache.cassandra.utils.progress.jmx.JMXNotificationProgressListener;

public class BootstrapMonitor
extends JMXNotificationProgressListener {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final PrintStream out;
    private final Condition condition = Condition.newOneTimeCondition();

    public BootstrapMonitor(PrintStream out) {
        this.out = out;
    }

    public void awaitCompletion() throws InterruptedException {
        this.condition.await();
    }

    @Override
    public boolean isInterestedIn(String tag) {
        return "bootstrap".equals(tag);
    }

    @Override
    public void handleNotificationLost(long timestamp, String message) {
        super.handleNotificationLost(timestamp, message);
    }

    @Override
    public void handleConnectionClosed(long timestamp, String message) {
        this.handleConnectionFailed(timestamp, message);
    }

    @Override
    public void handleConnectionFailed(long timestamp, String message) {
        IOException error = new IOException(String.format("[%s] JMX connection closed. (%s)", this.format.format(timestamp), message));
        this.out.println(error.getMessage());
        this.condition.signalAll();
    }

    @Override
    public void progress(String tag, ProgressEvent event) {
        ProgressEventType type = event.getType();
        String message = String.format("[%s] %s", this.format.format(Clock.Global.currentTimeMillis()), event.getMessage());
        if (type == ProgressEventType.PROGRESS) {
            message = message + " (progress: " + (int)event.getProgressPercentage() + "%)";
        }
        this.out.println(message);
        if (type == ProgressEventType.COMPLETE) {
            this.condition.signalAll();
        }
    }
}

