/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Operation;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class PortType
extends WsdlNode {
    private HashMap<QName, Operation> operations = new HashMap();
    private Definitions definitions;

    public PortType(Definitions definitions) {
        this.definitions = definitions;
    }

    public Iterator<Operation> getOperations() {
        return this.operations.values().iterator();
    }

    public Operation getOperation(QName name) {
        return this.operations.get(name);
    }

    void read(WsdlParser parser) throws WsdlParseException {
        int eventType = parser.getEventType();
        while (true) {
            String namespace;
            String name;
            if (eventType == 2) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if (name != null && namespace != null) {
                    this.parse(name, namespace, parser);
                }
            } else if (eventType == 3) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("portType".equals(name) && "http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    private void parse(String name, String namespace, WsdlParser parser) throws WsdlParseException {
        if ("http://schemas.xmlsoap.org/wsdl/".equals(namespace) && "operation".equals(name)) {
            Operation operation = new Operation(this.definitions);
            operation.read(parser);
            this.operations.put(operation.getName(), operation);
        }
    }

    static class MessageRef
    extends WsdlNode {
        private QName message;

        public MessageRef(QName message) {
            this.message = message;
        }

        public QName getMessage() {
            return this.message;
        }
    }
}

