package org.apache.helix.integration.manager;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.helix.HelixManagerProperty;
import org.apache.helix.InstanceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The standalone cluster controller class
 */
public class ClusterControllerManager extends ClusterManager {
  private static Logger LOG = LoggerFactory.getLogger(ClusterControllerManager.class);

  public ClusterControllerManager(String zkAddr, String clusterName) {
    this(zkAddr, clusterName, "controller");
  }

  public ClusterControllerManager(String zkAddr, String clusterName, String controllerName) {
    super(zkAddr, clusterName, controllerName, InstanceType.CONTROLLER);
  }

  public ClusterControllerManager(String clusterName, HelixManagerProperty helixManagerProperty) {
    super(clusterName, "controller", InstanceType.CONTROLLER, null, null, helixManagerProperty);
  }

  @Override
  public void finalize() {
    super.finalize();
  }
}
