/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.extendable.ExtendableItem;
import org.apache.tools.ant.BuildException;

public class IvyDependencyUpdateChecker
extends IvyPostResolveTask {
    private String revisionToCheck = "latest.integration";
    private boolean download = false;
    private boolean checkIfChanged = false;
    private boolean showTransitive = false;

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        ModuleDescriptor originalModuleDescriptor = this.getResolvedReport().getModuleDescriptor();
        DefaultModuleDescriptor latestModuleDescriptor = new DefaultModuleDescriptor(originalModuleDescriptor.getModuleRevisionId(), originalModuleDescriptor.getStatus(), originalModuleDescriptor.getPublicationDate());
        for (Configuration configuration : originalModuleDescriptor.getConfigurations()) {
            latestModuleDescriptor.addConfiguration(configuration);
        }
        for (ExtendableItem extendableItem : originalModuleDescriptor.getDependencies()) {
            ModuleRevisionId upToDateMrid = ModuleRevisionId.newInstance(extendableItem.getDependencyRevisionId(), this.revisionToCheck);
            latestModuleDescriptor.addDependency(extendableItem.clone(upToDateMrid));
        }
        ResolveOptions resolveOptions = new ResolveOptions();
        resolveOptions.setDownload(this.isDownload());
        resolveOptions.setLog(this.getLog());
        resolveOptions.setConfs(StringUtils.splitToArray(this.getConf()));
        resolveOptions.setCheckIfChanged(this.checkIfChanged);
        try {
            ResolveReport latestReport = this.getIvyInstance().getResolveEngine().resolve(latestModuleDescriptor, resolveOptions);
            this.displayDependencyUpdates(this.getResolvedReport(), latestReport);
            if (this.showTransitive) {
                this.displayNewDependencyOnLatest(this.getResolvedReport(), latestReport);
                this.displayMissingDependencyOnLatest(this.getResolvedReport(), latestReport);
            }
        }
        catch (IOException | ParseException e) {
            throw new BuildException("impossible to resolve dependencies:\n\t" + e, (Throwable)e);
        }
    }

    private void displayDependencyUpdates(ResolveReport originalReport, ResolveReport latestReport) {
        this.log("Dependencies updates available :");
        boolean dependencyUpdateDetected = false;
        for (IvyNode latest : latestReport.getDependencies()) {
            for (IvyNode originalDependency : originalReport.getDependencies()) {
                boolean isTransitiveDependency;
                if (!originalDependency.getModuleId().equals(latest.getModuleId()) || originalDependency.getResolvedId().getRevision().equals(latest.getResolvedId().getRevision())) continue;
                boolean bl = isTransitiveDependency = latest.getDependencyDescriptor(latest.getRoot()) == null;
                if (isTransitiveDependency && !this.showTransitive) continue;
                this.log(String.format("\t%s#%s%s\t%s -> %s", originalDependency.getResolvedId().getOrganisation(), originalDependency.getResolvedId().getName(), isTransitiveDependency ? " (transitive)" : "", originalDependency.getResolvedId().getRevision(), latest.getResolvedId().getRevision()));
                dependencyUpdateDetected = true;
            }
        }
        if (!dependencyUpdateDetected) {
            this.log("\tAll dependencies are up to date");
        }
    }

    private void displayMissingDependencyOnLatest(ResolveReport originalReport, ResolveReport latestReport) {
        ArrayList<ModuleRevisionId> listOfMissingDependencyOnLatest = new ArrayList<ModuleRevisionId>();
        for (IvyNode originalDependency : originalReport.getDependencies()) {
            boolean dependencyFound = false;
            for (IvyNode latest : latestReport.getDependencies()) {
                if (!originalDependency.getModuleId().equals(latest.getModuleId())) continue;
                dependencyFound = true;
            }
            if (dependencyFound) continue;
            listOfMissingDependencyOnLatest.add(originalDependency.getId());
        }
        if (listOfMissingDependencyOnLatest.size() > 0) {
            this.log("List of missing dependency on latest resolve :");
            for (ModuleRevisionId moduleRevisionId : listOfMissingDependencyOnLatest) {
                this.log("\t" + moduleRevisionId.toString());
            }
        }
    }

    private void displayNewDependencyOnLatest(ResolveReport originalReport, ResolveReport latestReport) {
        ArrayList<ModuleRevisionId> listOfNewDependencyOnLatest = new ArrayList<ModuleRevisionId>();
        for (IvyNode latest : latestReport.getDependencies()) {
            boolean dependencyFound = false;
            for (IvyNode originalDependency : originalReport.getDependencies()) {
                if (!originalDependency.getModuleId().equals(latest.getModuleId())) continue;
                dependencyFound = true;
            }
            if (dependencyFound) continue;
            listOfNewDependencyOnLatest.add(latest.getId());
        }
        if (listOfNewDependencyOnLatest.size() > 0) {
            this.log("List of new dependency on latest resolve :");
            for (ModuleRevisionId moduleRevisionId : listOfNewDependencyOnLatest) {
                this.log("\t" + moduleRevisionId.toString());
            }
        }
    }

    public String getRevisionToCheck() {
        return this.revisionToCheck;
    }

    public void setRevisionToCheck(String revisionToCheck) {
        this.revisionToCheck = revisionToCheck;
    }

    public boolean isDownload() {
        return this.download;
    }

    public void setDownload(boolean download) {
        this.download = download;
    }

    public boolean isShowTransitive() {
        return this.showTransitive;
    }

    public void setShowTransitive(boolean showTransitive) {
        this.showTransitive = showTransitive;
    }

    public boolean isCheckIfChanged() {
        return this.checkIfChanged;
    }

    public void setCheckIfChanged(boolean checkIfChanged) {
        this.checkIfChanged = checkIfChanged;
    }
}

