/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReplicationPageEventMessage
extends PacketImpl {
    protected long pageNumber;
    private SimpleString storeName;
    private boolean isDelete;
    private final boolean useLong;

    public ReplicationPageEventMessage(boolean useLong) {
        super((byte)98);
        this.useLong = useLong;
    }

    public ReplicationPageEventMessage(SimpleString storeName, long pageNumber, boolean isDelete, boolean useLong) {
        this(useLong);
        this.pageNumber = pageNumber;
        this.isDelete = isDelete;
        this.storeName = storeName;
    }

    public int expectedEncodeSize() {
        if (this.useLong) {
            return 13 + SimpleString.sizeofString((SimpleString)this.storeName) + 8 + 1;
        }
        return 13 + SimpleString.sizeofString((SimpleString)this.storeName) + 4 + 1;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.storeName);
        if (this.useLong) {
            buffer.writeLong(this.pageNumber);
        } else {
            if (this.pageNumber > Integer.MAX_VALUE) {
                throw new IllegalStateException("pageNumber=" + this.pageNumber + " is too large to be used with older broker version on replication");
            }
            buffer.writeInt((int)this.pageNumber);
        }
        buffer.writeBoolean(this.isDelete);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.storeName = buffer.readSimpleString();
        this.pageNumber = this.useLong ? buffer.readLong() : (long)buffer.readInt();
        this.isDelete = buffer.readBoolean();
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public SimpleString getStoreName() {
        return this.storeName;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    protected String getPacketString() {
        String baseString = super.getPacketString();
        return baseString + ", channel=" + this.channelID + ", isDelete=" + this.isDelete + ", storeName=" + String.valueOf(this.storeName) + ", pageNumber=" + this.pageNumber;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isDelete, this.pageNumber, this.storeName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationPageEventMessage)) {
            return false;
        }
        ReplicationPageEventMessage other = (ReplicationPageEventMessage)((Object)obj);
        return this.isDelete == other.isDelete && this.pageNumber == other.pageNumber && Objects.equals(this.storeName, other.storeName);
    }
}

