/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.tccl.logfactory;

import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;

public class TcclDisabledTestCase
extends TestCase {
    public static final String MY_LOG_FACTORY_PKG = "org.apache.commons.logging.tccl.custom";
    public static final String MY_LOG_FACTORY_IMPL = "org.apache.commons.logging.tccl.custom.MyLogFactoryImpl";

    public static Test suite() throws Exception {
        Class<TcclDisabledTestCase> thisClass = TcclDisabledTestCase.class;
        PathableClassLoader dummy = new PathableClassLoader(null);
        dummy.useExplicitLoader("junit.", Test.class.getClassLoader());
        dummy.addLogicalLib("testclasses");
        dummy.addLogicalLib("commons-logging");
        String thisClassPath = thisClass.getName().replace('.', '/') + ".class";
        URL baseUrl = dummy.findResource(thisClassPath);
        PathableClassLoader emptyLoader = new PathableClassLoader(null);
        PathableClassLoader parentLoader = new PathableClassLoader(null);
        parentLoader.useExplicitLoader("junit.", Test.class.getClassLoader());
        parentLoader.addLogicalLib("commons-logging");
        parentLoader.addLogicalLib("testclasses");
        parentLoader.useExplicitLoader("org.apache.commons.logging.tccl.custom.", emptyLoader);
        URL propsEnableUrl = new URL(baseUrl, "props_disable_tccl/");
        parentLoader.addURL(propsEnableUrl);
        PathableClassLoader tcclLoader = new PathableClassLoader(parentLoader);
        tcclLoader.addLogicalLib("testclasses");
        Class<?> testClass = parentLoader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, tcclLoader);
    }

    public void setUp() throws Exception {
        LogFactory.releaseAll();
    }

    public void tearDown() {
        LogFactory.releaseAll();
    }

    public void testLoader() throws Exception {
        Class<?> clazz2;
        ClassLoader thisClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoader tcclLoader = Thread.currentThread().getContextClassLoader();
        TcclDisabledTestCase.assertNotSame((String)"TCCL not same as test class loader", (Object)thisClassLoader, (Object)tcclLoader);
        try {
            clazz2 = thisClassLoader.loadClass(MY_LOG_FACTORY_IMPL);
            TcclDisabledTestCase.fail((String)"Unexpectedly able to load MyLogFactoryImpl via test class class loader");
            TcclDisabledTestCase.assertNotNull(clazz2);
        }
        catch (ClassNotFoundException clazz2) {
            // empty catch block
        }
        try {
            clazz2 = tcclLoader.loadClass(MY_LOG_FACTORY_IMPL);
            TcclDisabledTestCase.assertNotNull(clazz2);
        }
        catch (ClassNotFoundException ex) {
            TcclDisabledTestCase.fail((String)"Unexpectedly unable to load MyLogFactoryImpl via TCCL class loader");
        }
    }

    public void testTcclLoading() throws Exception {
        try {
            LogFactory instance = LogFactory.getFactory();
            TcclDisabledTestCase.fail((String)"Unexpectedly succeeded in loading custom factory, though TCCL disabled.");
            TcclDisabledTestCase.assertNotNull((Object)instance);
        }
        catch (LogConfigurationException ex) {
            TcclDisabledTestCase.assertTrue((String)"MylogFactoryImpl not found", (boolean)ex.getMessage().contains(MY_LOG_FACTORY_IMPL));
        }
    }
}

