/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LangAssertions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrayUtilsRemoveMultipleTest
extends AbstractLangTest {
    private static final int[] NULL_INDICES = null;

    ArrayUtilsRemoveMultipleTest() {
    }

    @Test
    void testRemoveAllBooleanArray() {
        boolean[] array = ArrayUtils.removeAll((boolean[])new boolean[]{true}, (int[])new int[]{0});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{0});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{1});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true}, (int[])new int[]{1});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, false}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, false}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, false}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true}, (int[])new int[]{1, 3, 4});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true, false, true}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true, false, true}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true, false, true}, (int[])new int[]{0, 1, 2});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveAllBooleanArrayNegativeIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{-1}));
    }

    @Test
    void testRemoveAllBooleanArrayOutOfBoundsIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{2}));
    }

    @Test
    void testRemoveAllBooleanArrayRemoveNone() {
        boolean[] array1 = new boolean[]{true, false};
        boolean[] array2 = ArrayUtils.removeAll((boolean[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((boolean[])array1, (boolean[])array2);
        Assertions.assertEquals(Boolean.TYPE, array2.getClass().getComponentType());
    }

    @Test
    void testRemoveAllByteArray() {
        byte[] array = ArrayUtils.removeAll((byte[])new byte[]{1}, (int[])new int[]{0});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{0});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{1});
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((byte[])new byte[]{1, 1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((byte[])new byte[]{3}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((byte[])new byte[]{1, 3, 5}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((byte[])new byte[]{2, 4}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((byte[])new byte[]{1, 3, 5, 7}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((byte[])new byte[]{2, 4, 6}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveAllByteArrayNegativeIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{-1}));
    }

    @Test
    void testRemoveAllByteArrayOutOfBoundsIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{2}));
    }

    @Test
    void testRemoveAllByteArrayRemoveNone() {
        byte[] array1 = new byte[]{1, 2};
        byte[] array2 = ArrayUtils.removeAll((byte[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((byte[])array1, (byte[])array2);
        Assertions.assertEquals(Byte.TYPE, array2.getClass().getComponentType());
    }

    @Test
    void testRemoveAllCharArray() {
        char[] array = ArrayUtils.removeAll((char[])new char[]{'a'}, (int[])new int[]{0});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{0});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{1});
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{1});
        Assertions.assertArrayEquals((char[])new char[]{'a', 'c'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((char[])new char[]{'c'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e'}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((char[])new char[]{'a', 'c', 'e'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e'}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((char[])new char[]{'b', 'd'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g'}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((char[])new char[]{'a', 'c', 'e', 'g'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g'}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((char[])new char[]{'b', 'd', 'f'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveAllCharArrayNegativeIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{-1}));
    }

    @Test
    void testRemoveAllCharArrayOutOfBoundsIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{2}));
    }

    @Test
    void testRemoveAllCharArrayRemoveNone() {
        char[] array1 = new char[]{'a', 'b'};
        char[] array2 = ArrayUtils.removeAll((char[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((char[])array1, (char[])array2);
        Assertions.assertEquals(Character.TYPE, array2.getClass().getComponentType());
    }

    @Test
    void testRemoveAllDoubleArray() {
        double[] array = ArrayUtils.removeAll((double[])new double[]{1.0}, (int[])new int[]{0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{1});
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 1.0}, (int[])new int[]{1});
        Assertions.assertArrayEquals((double[])new double[]{1.0, 1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((double[])new double[]{3.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((double[])new double[]{1.0, 3.0, 5.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((double[])new double[]{2.0, 4.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((double[])new double[]{1.0, 3.0, 5.0, 7.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((double[])new double[]{2.0, 4.0, 6.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveAllDoubleArrayNegativeIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{-1}));
    }

    @Test
    void testRemoveAllDoubleArrayOutOfBoundsIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{2}));
    }

    @Test
    void testRemoveAllDoubleArrayRemoveNone() {
        double[] array1 = new double[]{1.0, 2.0};
        double[] array2 = ArrayUtils.removeAll((double[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((double[])array1, (double[])array2);
        Assertions.assertEquals(Double.TYPE, array2.getClass().getComponentType());
    }

    @Test
    void testRemoveAllFloatArray() {
        float[] array = ArrayUtils.removeAll((float[])new float[]{1.0f}, (int[])new int[]{0});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{0});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{1});
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 1.0f}, (int[])new int[]{1});
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((float[])new float[]{3.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 3.0f, 5.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((float[])new float[]{2.0f, 4.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 3.0f, 5.0f, 7.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((float[])new float[]{2.0f, 4.0f, 6.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveAllFloatArrayNegativeIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{-1}));
    }

    @Test
    void testRemoveAllFloatArrayOutOfBoundsIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{2}));
    }

    @Test
    void testRemoveAllFloatArrayRemoveNone() {
        float[] array1 = new float[]{1.0f, 2.0f};
        float[] array2 = ArrayUtils.removeAll((float[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((float[])array1, (float[])array2);
        Assertions.assertEquals(Float.TYPE, array2.getClass().getComponentType());
    }

    @Test
    void testRemoveAllIntArray() {
        int[] array = ArrayUtils.removeAll((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])ArrayUtils.EMPTY_INT_ARRAY);
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        array = ArrayUtils.removeAll((int[])new int[]{1}, (int[])ArrayUtils.EMPTY_INT_ARRAY);
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array);
        array = ArrayUtils.removeAll((int[])new int[]{1}, (int[])new int[]{0});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{0});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])new int[]{1, 1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((int[])new int[]{3}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((int[])new int[]{1, 3, 5}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((int[])new int[]{2, 4}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((int[])new int[]{1, 3, 5, 7}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((int[])new int[]{2, 4, 6}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveAllIntArrayNegativeIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{-1}));
    }

    @Test
    void testRemoveAllIntArrayOutOfBoundsIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{2}));
    }

    @Test
    void testRemoveAllIntArrayRemoveNone() {
        int[] array1 = new int[]{1, 2};
        int[] array2 = ArrayUtils.removeAll((int[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((int[])array1, (int[])array2);
        Assertions.assertEquals(Integer.TYPE, array2.getClass().getComponentType());
    }

    @Test
    void testRemoveAllLongArray() {
        long[] array = ArrayUtils.removeAll((long[])new long[]{1L}, (int[])new int[]{0});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{0});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{1});
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 1L}, (int[])new int[]{1});
        Assertions.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((long[])new long[]{3L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((long[])new long[]{1L, 3L, 5L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((long[])new long[]{2L, 4L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((long[])new long[]{1L, 3L, 5L, 7L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((long[])new long[]{2L, 4L, 6L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveAllLongArrayNegativeIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{-1}));
    }

    @Test
    void testRemoveAllLongArrayOutOfBoundsIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{2}));
    }

    @Test
    void testRemoveAllLongArrayRemoveNone() {
        long[] array1 = new long[]{1L, 2L};
        long[] array2 = ArrayUtils.removeAll((long[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((long[])array1, (long[])array2);
        Assertions.assertEquals(Long.TYPE, array2.getClass().getComponentType());
    }

    @Test
    void testRemoveAllNullBooleanArray() {
        Assertions.assertNull((Object)ArrayUtils.removeAll((boolean[])null, (int[])new int[]{0}));
        Assertions.assertNull((Object)ArrayUtils.removeAll((boolean[])null, (int[])NULL_INDICES));
        boolean[] array0 = new boolean[]{};
        Assertions.assertArrayEquals((boolean[])array0, (boolean[])ArrayUtils.removeAll((boolean[])array0, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array0, (Object)ArrayUtils.removeAll((boolean[])array0, (int[])NULL_INDICES));
        boolean[] array1 = new boolean[1];
        Assertions.assertArrayEquals((boolean[])array1, (boolean[])ArrayUtils.removeAll((boolean[])array1, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array1, (Object)ArrayUtils.removeAll((boolean[])array1, (int[])NULL_INDICES));
    }

    @Test
    void testRemoveAllNullByteArray() {
        Assertions.assertNull((Object)ArrayUtils.removeAll((byte[])null, (int[])new int[0]));
        Assertions.assertNull((Object)ArrayUtils.removeAll((byte[])null, (int[])new int[]{0}));
        Assertions.assertNull((Object)ArrayUtils.removeAll((byte[])null, (int[])NULL_INDICES));
        byte[] array0 = new byte[]{};
        Assertions.assertArrayEquals((byte[])array0, (byte[])ArrayUtils.removeAll((byte[])array0, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array0, (Object)ArrayUtils.removeAll((byte[])array0, (int[])NULL_INDICES));
        byte[] array1 = new byte[1];
        Assertions.assertArrayEquals((byte[])array1, (byte[])ArrayUtils.removeAll((byte[])array1, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array1, (Object)ArrayUtils.removeAll((byte[])array1, (int[])NULL_INDICES));
    }

    @Test
    void testRemoveAllNullCharArray() {
        Assertions.assertNull((Object)ArrayUtils.removeAll((char[])null, (int[])new int[0]));
        Assertions.assertNull((Object)ArrayUtils.removeAll((char[])null, (int[])new int[]{0}));
        Assertions.assertNull((Object)ArrayUtils.removeAll((char[])null, (int[])NULL_INDICES));
        char[] array0 = new char[]{};
        Assertions.assertArrayEquals((char[])array0, (char[])ArrayUtils.removeAll((char[])array0, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array0, (Object)ArrayUtils.removeAll((char[])array0, (int[])NULL_INDICES));
        char[] array1 = new char[1];
        Assertions.assertArrayEquals((char[])array1, (char[])ArrayUtils.removeAll((char[])array1, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array1, (Object)ArrayUtils.removeAll((char[])array1, (int[])NULL_INDICES));
    }

    @Test
    void testRemoveAllNullDoubleArray() {
        Assertions.assertNull((Object)ArrayUtils.removeAll((double[])null, (int[])new int[0]));
        Assertions.assertNull((Object)ArrayUtils.removeAll((double[])null, (int[])new int[]{0}));
        Assertions.assertNull((Object)ArrayUtils.removeAll((double[])null, (int[])NULL_INDICES));
        double[] array0 = new double[]{};
        Assertions.assertArrayEquals((double[])array0, (double[])ArrayUtils.removeAll((double[])array0, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array0, (Object)ArrayUtils.removeAll((double[])array0, (int[])NULL_INDICES));
        double[] array1 = new double[1];
        Assertions.assertArrayEquals((double[])array1, (double[])ArrayUtils.removeAll((double[])array1, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array1, (Object)ArrayUtils.removeAll((double[])array1, (int[])NULL_INDICES));
    }

    @Test
    void testRemoveAllNullFloatArray() {
        Assertions.assertNull((Object)ArrayUtils.removeAll((float[])null, (int[])new int[0]));
        Assertions.assertNull((Object)ArrayUtils.removeAll((float[])null, (int[])new int[]{0}));
        Assertions.assertNull((Object)ArrayUtils.removeAll((float[])null, (int[])NULL_INDICES));
        float[] array0 = new float[]{};
        Assertions.assertArrayEquals((float[])array0, (float[])ArrayUtils.removeAll((float[])array0, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array0, (Object)ArrayUtils.removeAll((float[])array0, (int[])NULL_INDICES));
        float[] array1 = new float[1];
        Assertions.assertArrayEquals((float[])array1, (float[])ArrayUtils.removeAll((float[])array1, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array1, (Object)ArrayUtils.removeAll((float[])array1, (int[])NULL_INDICES));
    }

    @Test
    void testRemoveAllNullIntArray() {
        Assertions.assertNull((Object)ArrayUtils.removeAll((int[])null, (int[])new int[0]));
        Assertions.assertNull((Object)ArrayUtils.removeAll((int[])null, (int[])new int[]{0}));
        Assertions.assertNull((Object)ArrayUtils.removeAll((int[])null, (int[])NULL_INDICES));
        int[] array0 = new int[]{};
        Assertions.assertArrayEquals((int[])array0, (int[])ArrayUtils.removeAll((int[])array0, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array0, (Object)ArrayUtils.removeAll((int[])array0, (int[])NULL_INDICES));
        int[] array1 = new int[1];
        Assertions.assertArrayEquals((int[])array1, (int[])ArrayUtils.removeAll((int[])array1, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array1, (Object)ArrayUtils.removeAll((int[])array1, (int[])NULL_INDICES));
    }

    @Test
    void testRemoveAllNullLongArray() {
        Assertions.assertNull((Object)ArrayUtils.removeAll((long[])null, (int[])new int[0]));
        Assertions.assertNull((Object)ArrayUtils.removeAll((long[])null, (int[])new int[]{0}));
        Assertions.assertNull((Object)ArrayUtils.removeAll((long[])null, (int[])NULL_INDICES));
        long[] array0 = new long[]{};
        Assertions.assertArrayEquals((long[])array0, (long[])ArrayUtils.removeAll((long[])array0, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array0, (Object)ArrayUtils.removeAll((long[])array0, (int[])NULL_INDICES));
        long[] array1 = new long[1];
        Assertions.assertArrayEquals((long[])array1, (long[])ArrayUtils.removeAll((long[])array1, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array1, (Object)ArrayUtils.removeAll((long[])array1, (int[])NULL_INDICES));
    }

    @Test
    void testRemoveAllNullObjectArray() {
        Assertions.assertNull((Object)ArrayUtils.removeAll((Object[])null, (int[])new int[0]));
        Assertions.assertNull((Object)ArrayUtils.removeAll((Object[])null, (int[])new int[]{0}));
        Assertions.assertNull((Object)ArrayUtils.removeAll((Object[])null, (int[])NULL_INDICES));
        Object[] array0 = new Object[]{};
        Assertions.assertArrayEquals((Object[])array0, (Object[])ArrayUtils.removeAll((Object[])array0, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array0, (Object)ArrayUtils.removeAll((Object[])array0, (int[])NULL_INDICES));
        Object[] array1 = new Object[1];
        Assertions.assertArrayEquals((Object[])array1, (Object[])ArrayUtils.removeAll((Object[])array1, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array1, (Object)ArrayUtils.removeAll((Object[])array1, (int[])NULL_INDICES));
    }

    @Test
    void testRemoveAllNullShortArray() {
        Assertions.assertNull((Object)ArrayUtils.removeAll((short[])null, (int[])new int[0]));
        Assertions.assertNull((Object)ArrayUtils.removeAll((short[])null, (int[])new int[]{0}));
        Assertions.assertNull((Object)ArrayUtils.removeAll((short[])null, (int[])NULL_INDICES));
        short[] array0 = new short[]{};
        Assertions.assertArrayEquals((short[])array0, (short[])ArrayUtils.removeAll((short[])array0, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array0, (Object)ArrayUtils.removeAll((short[])array0, (int[])NULL_INDICES));
        short[] array1 = new short[1];
        Assertions.assertArrayEquals((short[])array1, (short[])ArrayUtils.removeAll((short[])array1, (int[])NULL_INDICES));
        Assertions.assertNotSame((Object)array1, (Object)ArrayUtils.removeAll((short[])array1, (int[])NULL_INDICES));
    }

    @Test
    void testRemoveAllNumberArray() {
        Object[] inarray = new Number[]{1, 2L, (byte)3};
        Assertions.assertEquals((int)3, (int)inarray.length);
        Object[] outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{1});
        Assertions.assertArrayEquals((Object[])new Number[]{1, (byte)3}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])outarray, (int[])new int[]{1});
        Assertions.assertArrayEquals((Object[])new Number[]{1}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])outarray, (int[])new int[]{0});
        Assertions.assertEquals((int)0, (int)outarray.length);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((Object[])new Number[]{(byte)3}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((Object[])new Number[]{2L}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((Object[])new Number[]{1}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
    }

    @Test
    void testRemoveAllObjectArray() {
        Object[] array = ArrayUtils.removeAll((Object[])new Object[]{"a"}, (int[])new int[]{0});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b"}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c"}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((Object[])new Object[]{"a", "d"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{0, 3});
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "c"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{0, 1, 3});
        Assertions.assertArrayEquals((Object[])new Object[]{"c"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d", "e"}, (int[])new int[]{0, 1, 3});
        Assertions.assertArrayEquals((Object[])new Object[]{"c", "e"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d", "e"}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "d"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{0, 1, 3, 0, 1, 3});
        Assertions.assertArrayEquals((Object[])new Object[]{"c"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{2, 1, 0, 3});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{2, 0, 1, 3, 0, 2, 1, 3});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
    }

    @Test
    void testRemoveAllObjectArrayNegativeIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((Object[])new Object[]{"a", "b"}, (int[])new int[]{-1}));
    }

    @Test
    void testRemoveAllObjectArrayOutOfBoundsIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((Object[])new Object[]{"a", "b"}, (int[])new int[]{2}));
    }

    @Test
    void testRemoveAllObjectArrayRemoveNone() {
        Object[] array1 = new Object[]{"foo", "bar", "baz"};
        Object[] array2 = ArrayUtils.removeAll((Object[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((Object[])array1, (Object[])array2);
        Assertions.assertEquals(Object.class, array2.getClass().getComponentType());
    }

    @Test
    void testRemoveAllShortArray() {
        short[] array = ArrayUtils.removeAll((short[])new short[]{1}, (int[])new int[]{0});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{0});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{1});
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((short[])new short[]{1, 1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((short[])new short[]{3}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((short[])new short[]{1, 3, 5}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((short[])new short[]{2, 4}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((short[])new short[]{1, 3, 5, 7}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((short[])new short[]{2, 4, 6}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveAllShortArrayNegativeIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{-1, 0}));
    }

    @Test
    void testRemoveAllShortArrayOutOfBoundsIndex() {
        LangAssertions.assertIndexOutOfBoundsException(() -> ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{2, 0}));
    }

    @Test
    void testRemoveAllShortArrayRemoveNone() {
        short[] array1 = new short[]{1, 2};
        short[] array2 = ArrayUtils.removeAll((short[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((short[])array1, (short[])array2);
        Assertions.assertEquals(Short.TYPE, array2.getClass().getComponentType());
    }

    @Test
    void testRemoveElementBooleanArray() {
        boolean[] array = ArrayUtils.removeElements((boolean[])null, (boolean[])new boolean[]{true});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])new boolean[]{true});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true}, (boolean[])new boolean[]{true});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])null, (boolean[])new boolean[]{true, false});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])new boolean[]{true, false});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true}, (boolean[])new boolean[]{true, false});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{true, false});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{true, true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true, false});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true, true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true, true, true, true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveElementByteArray() {
        byte[] array = ArrayUtils.removeElements((byte[])null, (byte[])new byte[]{1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])new byte[]{1});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1}, (byte[])new byte[]{1});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2}, (byte[])new byte[]{1});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1});
        Assertions.assertArrayEquals((byte[])new byte[]{2, 1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])null, (byte[])new byte[]{1, 2});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])new byte[]{1, 2});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1}, (byte[])new byte[]{1, 2});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2}, (byte[])new byte[]{1, 2});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2}, (byte[])new byte[]{1, 1});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1, 2});
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1, 1});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1, 1, 1, 1});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveElementCharArray() {
        char[] array = ArrayUtils.removeElements((char[])null, (char[])new char[]{'a'});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])new char[]{'a'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a'}, (char[])new char[]{'a'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b'}, (char[])new char[]{'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b', 'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])null, (char[])new char[]{'a', 'b'});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])new char[]{'a', 'b'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a'}, (char[])new char[]{'a', 'b'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b'}, (char[])new char[]{'a', 'b'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b'}, (char[])new char[]{'a', 'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a', 'b'});
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a', 'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a', 'a', 'a', 'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveElementDoubleArray() {
        double[] array = ArrayUtils.removeElements((double[])null, (double[])new double[]{1.0});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])new double[]{1.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0}, (double[])new double[]{1.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0}, (double[])new double[]{1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0, 1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])null, (double[])new double[]{1.0, 2.0});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])new double[]{1.0, 2.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0}, (double[])new double[]{1.0, 2.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0}, (double[])new double[]{1.0, 2.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0}, (double[])new double[]{1.0, 1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0, 2.0});
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0, 1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0, 1.0, 1.0, 1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveElementFloatArray() {
        float[] array = ArrayUtils.removeElements((float[])null, (float[])new float[]{1.0f});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])new float[]{1.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f}, (float[])new float[]{1.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f}, (float[])new float[]{1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f, 1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])null, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f}, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f}, (float[])new float[]{1.0f, 2.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f}, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f, 2.0f});
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveElementIntArray() {
        int[] array = ArrayUtils.removeElements((int[])null, (int[])new int[]{1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])new int[]{2, 1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])null, (int[])new int[]{1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{1, 1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1}, (int[])new int[]{1, 1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2}, (int[])new int[]{1, 1});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1, 1});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1, 1, 1, 1});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveElementLongArray() {
        long[] array = ArrayUtils.removeElements((long[])null, (long[])new long[]{1L});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{1L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L}, (long[])new long[]{1L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L}, (long[])new long[]{1L});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L});
        Assertions.assertArrayEquals((long[])new long[]{2L, 1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])null, (long[])new long[]{1L, 1L});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{1L, 1L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L}, (long[])new long[]{1L, 1L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L}, (long[])new long[]{1L, 2L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L}, (long[])new long[]{1L, 1L});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L, 1L});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L, 2L});
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L, 1L, 1L, 1L});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveElementShortArray() {
        short[] array = ArrayUtils.removeElements((short[])null, (short[])new short[]{1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])new short[]{1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1}, (short[])new short[]{1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2}, (short[])new short[]{1});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1});
        Assertions.assertArrayEquals((short[])new short[]{2, 1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])null, (short[])new short[]{1, 1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])new short[]{1, 1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1}, (short[])new short[]{1, 1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2}, (short[])new short[]{1, 2});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2}, (short[])new short[]{1, 1});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1, 1});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1, 2});
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1, 1, 1, 1});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
    }

    @Test
    void testRemoveElementsObjectArray() {
        Object[] array = ArrayUtils.removeElements((Object[])null, (Object[])new Object[]{"a"});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a"}, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b"}, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])null, (Object[])new Object[]{"a", "b"});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])new Object[]{"a", "b"});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a"}, (Object[])new Object[]{"a", "b"});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b"}, (Object[])new Object[]{"a", "c"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a", "b"});
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a", "a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a", "a", "a", "a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
    }
}

