/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Proxy;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.ObjectContext;
import org.apache.commons.jexl3.internal.Engine32;
import org.apache.commons.jexl3.internal.OptionsContext;
import org.apache.commons.jexl3.internal.Util;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Issues300Test {
    Issues300Test() {
    }

    static JexlContext pragmaticContext() {
        JexlOptions opts = new JexlOptions();
        opts.setFlags(new String[]{"-strict", "-cancellable", "-lexical", "-lexicalShade", "+safe", "+sharedInstance"});
        return new JexlTestCase.PragmaticContext(opts);
    }

    <T> T createProxy(JexlEngine jexl, Object o, Class[] clazzz) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), clazzz, (proxy, method, args) -> jexl.invokeMethod(o, method.getName(), args));
    }

    private Object run361a(JexlEngine jexl) {
        String src = "()-> { ()-> { if (versionFile != null) { return 'foo'; } else { return 'bar'; }} }";
        JexlScript script = jexl.createScript("()-> { ()-> { if (versionFile != null) { return 'foo'; } else { return 'bar'; }} }");
        Object result = script.execute(null);
        JexlScript rs = (JexlScript)result;
        return rs.execute(null);
    }

    private Object run361b(JexlEngine jexl) {
        String src = "()-> { ()-> {var voa = vaf.value;\nif (voa != NaN && voa <= 0){ return 'foo'; } else { return 'bar'; }} }";
        MapContext context = new MapContext();
        Map<String, Object> vaf = Collections.singletonMap("value", null);
        context.set("vaf", vaf);
        JexlScript script = jexl.createScript("()-> { ()-> {var voa = vaf.value;\nif (voa != NaN && voa <= 0){ return 'foo'; } else { return 'bar'; }} }");
        Object result = script.execute(null);
        JexlScript rs = (JexlScript)result;
        return rs.execute((JexlContext)context);
    }

    private String run361c(JexlEngine jexl) {
        String src = "$$var t = null;\n$$if (t < 0) {\n'foo'\n$$} else {\n'bar'\n$$}";
        JxltEngine jxlt = jexl.createJxltEngine();
        MapContext context = new MapContext();
        Map<String, Object> vaf = Collections.singletonMap("value", null);
        context.set("vaf", vaf);
        JxltEngine.Template template = jxlt.createTemplate("$$var t = null;\n$$if (t < 0) {\n'foo'\n$$} else {\n'bar'\n$$}");
        StringWriter strw = new StringWriter();
        template.evaluate((JexlContext)context, (Writer)strw);
        return strw.toString();
    }

    private Object run361d(JexlEngine jexl) {
        String src = "var foo = 42; var foo = 43;";
        JexlScript script = jexl.createScript("var foo = 42; var foo = 43;");
        return script.execute(null);
    }

    @Test
    void test301a() {
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic(new JexlArithmetic(false)).create();
        String[] srcs = new String[]{"var x = null; x.0", "var x = null; x[0]", "var x = [null,1]; x[0][0]"};
        for (int i = 0; i < srcs.length; ++i) {
            String src = srcs[i];
            JexlScript s = jexl.createScript(src);
            try {
                Object o = s.execute(null);
                if (i <= 0) continue;
                Assertions.fail((String)(src + ": Should have failed"));
                continue;
            }
            catch (Exception ex) {
                Assertions.assertTrue((boolean)ex.getMessage().contains("x"));
            }
        }
    }

    @Test
    void test302() {
        MapContext jc = new MapContext();
        String[] strs = new String[]{"{if (0) 1 else 2; var x = 4;}", "if (0) 1; else 2; ", "{ if (0) 1; else 2; }", "{ if (0) { if (false) 1 else -3 } else 2; }"};
        JexlEngine jexl = new JexlBuilder().create();
        for (String str : strs) {
            JexlScript e = jexl.createScript(str);
            Object o = e.execute((JexlContext)jc);
            int oo = ((Number)o).intValue() % 2;
            Assertions.assertEquals((int)0, (int)oo, () -> "Block result is wrong " + str);
        }
    }

    @Test
    void test304() {
        CharSequence[] keywords;
        JexlEngine jexlEngine = new JexlBuilder().strict(false).create();
        JexlExpression e304 = jexlEngine.createExpression("overview.limit.var");
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("var", "4711");
        HashMap<String, HashMap<String, String>> map2 = new HashMap<String, HashMap<String, String>>();
        map2.put("limit", map3);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("overview", map2);
        MapContext context = new MapContext(map);
        Object value = e304.evaluate((JexlContext)context);
        Assertions.assertEquals((Object)"4711", (Object)value);
        map.clear();
        map.put("overview.limit.var", Integer.valueOf(42));
        value = e304.evaluate((JexlContext)context);
        Assertions.assertEquals((Object)42, (Object)value);
        for (String string : keywords = new String[]{"if", "else", "do", "while", "for", "break", "continue", "function", "return", "new", "size", "empty", "var", "let", "const", "null", "true", "false", "not", "div", "mod", "and", "or", "eq", "ne", "lt", "gt", "ge", "le"}) {
            String pkw = "e304." + string;
            map.put(pkw, Integer.valueOf(42));
            e304 = jexlEngine.createExpression(pkw);
            value = e304.evaluate((JexlContext)context);
            Assertions.assertEquals((Object)42, (Object)value);
        }
        for (int i = 0; i < keywords.length; ++i) {
            String pkw = "e304." + keywords[i] + "." + (String)keywords[keywords.length - 1 - i];
            map.put(pkw, Integer.valueOf(42));
            e304 = jexlEngine.createExpression(pkw);
            value = e304.evaluate((JexlContext)context);
            Assertions.assertEquals((Object)42, (Object)value);
        }
        String allkw = "e304." + String.join((CharSequence)".", keywords);
        map.put(allkw, Integer.valueOf(42));
        e304 = jexlEngine.createExpression(allkw);
        value = e304.evaluate((JexlContext)context);
        Assertions.assertEquals((Object)42, (Object)value);
    }

    @Test
    void test305() {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("{while(false) {}; var x = 1;}");
        String str0 = e.getParsedText();
        e = jexl.createScript(str0);
        Assertions.assertNotNull((Object)e);
        String str1 = e.getParsedText();
        Assertions.assertEquals((Object)str0, (Object)str1);
    }

    @Test
    void test306() {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("x.y ?: 2");
        Object o1 = e.execute(null);
        Assertions.assertEquals((Object)2, (Object)o1);
        ctxt.set("x.y", null);
        Object o2 = e.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)2, (Object)o2);
    }

    @Test
    void test306a() {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("x.y ?: 2", new String[]{"x"});
        Object o = e.execute(null, new Object[]{new Object()});
        Assertions.assertEquals((Object)2, (Object)o);
        o = e.execute(null);
        Assertions.assertEquals((Object)2, (Object)o);
    }

    @Test
    void test306b() {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("x?.y ?: 2", new String[]{"x"});
        Object o1 = e.execute(null, new Object[]{new Object()});
        Assertions.assertEquals((Object)2, (Object)o1);
        Object o2 = e.execute(null);
        Assertions.assertEquals((Object)2, (Object)o2);
    }

    @Test
    void test306c() {
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript e = jexl.createScript("x.y ?: 2", new String[]{"x"});
        Object o = e.execute(null, new Object[]{new Object()});
        Assertions.assertEquals((Object)2, (Object)o);
        o = e.execute(null);
        Assertions.assertEquals((Object)2, (Object)o);
    }

    @Test
    void test306d() {
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript e = jexl.createScript("x.y[z.t] ?: 2", new String[]{"x"});
        Object o = e.execute(null, new Object[]{new Object()});
        Assertions.assertEquals((Object)2, (Object)o);
        o = e.execute(null);
        Assertions.assertEquals((Object)2, (Object)o);
    }

    @Test
    void test309a() {
        String src = "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = 12++;\n  </body>\n</html>";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JexlInfo info = new JexlInfo("template", 1, 1);
        JexlException.Parsing xerror = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jxlt.createTemplate(info, "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = 12++;\n  </body>\n</html>"));
        Assertions.assertEquals((int)4, (int)xerror.getInfo().getLine());
    }

    @Test
    void test309b() {
        String src = "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = a b c;\n  </body>\n</html>";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JexlInfo info = new JexlInfo("template", 1, 1);
        JexlException.Parsing xerror = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jxlt.createTemplate(info, "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = a b c;\n  </body>\n</html>"));
        Assertions.assertEquals((int)4, (int)xerror.getInfo().getLine());
    }

    @Test
    void test309c() {
        String src = "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i =12;\n  </body>\n</html>";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JexlInfo info = new JexlInfo("template", 1, 1);
        JxltEngine.Template tmplt = jxlt.createTemplate(info, "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i =12;\n  </body>\n</html>");
        String src1 = tmplt.asString();
        String src2 = tmplt.toString();
        Assertions.assertEquals((Object)src1, (Object)src2);
    }

    @Test
    void test314() {
        JexlEngine jexl = new JexlBuilder().strict(true).safe(false).create();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        VaContext ctxt = new VaContext(vars);
        JexlScript script = jexl.createScript("cell()");
        Object result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)0, (Object)result);
        script = jexl.createScript("x.cell()", new String[]{"x"});
        result = script.execute((JexlContext)ctxt, new Object[]{Arrays.asList(10, 20)});
        Assertions.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("cell('1', '2')");
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)2, (Object)result);
        script = jexl.createScript("x.cell('1', '2')", new String[]{"x"});
        result = script.execute((JexlContext)ctxt, new Object[]{Arrays.asList(10, 20)});
        Assertions.assertEquals((Object)44, (Object)result);
        vars.put("TVALOGAR", null);
        String jexlExp = "TVALOGAR==null ?'SIMON':'SIMONAZO'";
        script = jexl.createScript(jexlExp);
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)"SIMON", (Object)result);
        jexlExp = "TVALOGAR.PEPITO==null ?'SIMON':'SIMONAZO'";
        script = jexl.createScript(jexlExp);
        LinkedHashMap<String, Object> tva = new LinkedHashMap<String, Object>();
        tva.put("PEPITO", null);
        vars.put("TVALOGAR", tva);
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)"SIMON", (Object)result);
        vars.remove("TVALOGAR");
        ctxt.set("TVALOGAR.PEPITO", null);
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)"SIMON", (Object)result);
    }

    @Test
    void test315() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        VaContext ctxt = new VaContext(vars);
        JexlScript script = jexl.createScript("a?? 42 + 10", new String[]{"a"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assertions.assertEquals((Object)32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assertions.assertEquals((Object)52, (Object)result);
        script = jexl.createScript("- a??42 + +10", new String[]{"a"});
        result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assertions.assertEquals((Object)-32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assertions.assertEquals((Object)52, (Object)result);
        script = jexl.createScript("a? a : +42 + 10", new String[]{"a"});
        result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assertions.assertEquals((Object)32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assertions.assertEquals((Object)52, (Object)result);
        script = jexl.createScript("a ?: +42 + 10", new String[]{"a"});
        result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assertions.assertEquals((Object)32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assertions.assertEquals((Object)52, (Object)result);
    }

    @Test
    void test317() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        MapContext ctxt = new MapContext();
        JexlInfo info = new JexlInfo("test317", 1, 1);
        JexlScript script = jexl.createScript(info, "var f = ()-> {x + x }; f", new String[]{"x"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{21});
        Assertions.assertInstanceOf(JexlScript.class, (Object)result);
        script = (JexlScript)result;
        info = JexlInfo.from((JexlScript)script);
        Assertions.assertNotNull((Object)info);
        Assertions.assertEquals((Object)"test317", (Object)info.getName());
        result = script.execute((JexlContext)ctxt, new Object[]{21});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void test322a() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        MapContext context = new MapContext();
        String[] ins = new String[]{"${'{'}", "${\"{\"}", "${\"{}\"}", "${'{42}'}", "${\"{\\\"\\\"}\"}"};
        String[] ctls = new String[]{"{", "{", "{}", "{42}", "{\"\"}"};
        for (int i = 0; i < ins.length; ++i) {
            String src = ins[i];
            JxltEngine.Template template = jxlt.createTemplate("$$", (Reader)new StringReader(src), new String[0]);
            StringWriter strw = new StringWriter();
            template.evaluate((JexlContext)context, (Writer)strw);
            String output = strw.toString();
            Assertions.assertEquals((Object)ctls[i], (Object)output);
        }
    }

    @Test
    void test322b() {
        MapContext ctxt = new MapContext();
        String src = "L'utilisateur ${session.user.name} s'est connecte";
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template template = jxlt.createTemplate("$$", (Reader)new StringReader("L'utilisateur ${session.user.name} s'est connecte"), new String[0]);
        ctxt.set("session", (Object)new Session322());
        StringWriter strw = new StringWriter();
        template.evaluate((JexlContext)ctxt, (Writer)strw);
        String output = strw.toString();
        Assertions.assertEquals((Object)"L'utilisateur user322 s'est connecte", (Object)output);
        ctxt.set("session.user", (Object)new User322());
        strw = new StringWriter();
        template.evaluate((JexlContext)ctxt, (Writer)strw);
        output = strw.toString();
        Assertions.assertEquals((Object)"L'utilisateur user322 s'est connecte", (Object)output);
        ctxt.set("session.user.name", (Object)"user322");
        strw = new StringWriter();
        template.evaluate((JexlContext)ctxt, (Writer)strw);
        output = strw.toString();
        Assertions.assertEquals((Object)"L'utilisateur user322 s'est connecte", (Object)output);
    }

    @Test
    void test323() {
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        HashMap vars = new HashMap();
        MapContext jc = new MapContext(vars);
        JexlScript script0 = jexl.createScript("a.n.t.variable");
        JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> Issues300Test.lambda$test323$0(script0, (JexlContext)jc), (String)"a.n.t.variable is undefined!");
        Assertions.assertTrue((boolean)xvar.toString().contains("a.n.t"));
        jc.set("a.n.t.variable", null);
        JexlScript script = jexl.createScript("a.n.t.variable");
        Object result = script.execute((JexlContext)jc);
        Assertions.assertNull((Object)result);
        jc.set("a.n.t", null);
        JexlScript script1 = jexl.createScript("a.n.t[0].variable");
        xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> Issues300Test.lambda$test323$1(script1, (JexlContext)jc), (String)"a.n.t is null!");
        Assertions.assertTrue((boolean)xvar.toString().contains("a.n.t"));
        vars.remove("a.n.t");
        JexlScript script2 = jexl.createScript("a.n.t[0].variable");
        xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> Issues300Test.lambda$test323$2(script2, (JexlContext)jc), (String)"a.n.t is undefined!");
        Assertions.assertTrue((boolean)xvar.toString().contains("a.n.t"));
        ArrayList<Integer> inner = new ArrayList<Integer>();
        vars.put("a.n.t", inner);
        JexlScript script3 = jexl.createScript("a.n.t[0].variable");
        JexlException.Property xprop = (JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> Issues300Test.lambda$test323$3(script3, (JexlContext)jc), (String)"a.n.t is null!");
        Assertions.assertTrue((boolean)xprop.toString().contains("0"));
        inner.add(42);
        JexlScript script4 = jexl.createScript("a.n.t[0].variable");
        xprop = (JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> Issues300Test.lambda$test323$4(script4, (JexlContext)jc), (String)"a.n.t is null!");
        Assertions.assertTrue((boolean)xprop.toString().contains("variable"));
    }

    @Test
    void test324() {
        JexlEngine jexl = new JexlBuilder().create();
        String src42 = "new('java.lang.Integer', 42)";
        JexlExpression expr0 = jexl.createExpression("new('java.lang.Integer', 42)");
        Assertions.assertEquals((Object)42, (Object)expr0.evaluate(null));
        String parsed = expr0.getParsedText();
        Assertions.assertEquals((Object)"new('java.lang.Integer', 42)", (Object)parsed);
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createExpression("new()"), (String)"should not parse");
        Assertions.assertTrue((boolean)xparse.toString().contains(")"));
    }

    @Test
    void test325() {
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        HashMap<String, Object> map = new HashMap<String, Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object get(Object key) {
                return super.get(key == null ? "" : key);
            }

            @Override
            public Object put(String key, Object value) {
                return super.put(key == null ? "" : key, value);
            }
        };
        map.put("42", 42);
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("map[null] = 42", new String[]{"map"});
        Object result = script.execute((JexlContext)jc, new Object[]{map});
        Assertions.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("map[key]", new String[]{"map", "key"});
        result = script.execute((JexlContext)jc, new Object[]{map, null});
        Assertions.assertEquals((Object)42, (Object)result);
        result = script.execute((JexlContext)jc, new Object[]{map, "42"});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void test330() {
        JexlEngine jexl = new JexlBuilder().create();
        String longExpression = "'THIS IS A VERY VERY VERY VERY VERY VERY VERY VERY VERY LONG STRING CONCATENATION ' + VARIABLE ' <--- error: missing + between VARIABLE and literal'";
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createExpression("'THIS IS A VERY VERY VERY VERY VERY VERY VERY VERY VERY LONG STRING CONCATENATION ' + VARIABLE ' <--- error: missing + between VARIABLE and literal'"), (String)"parsing malformed expression did not throw exception");
        Assertions.assertTrue((boolean)xparse.getMessage().contains("VARIABLE"));
    }

    @Test
    void test331() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext ctxt = new MapContext();
        JexlScript script = jexl.createScript("a + '\\n' + b", new String[]{"a", "b"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{"hello", "world"});
        Assertions.assertTrue((boolean)result.toString().contains("\n"));
    }

    @Test
    void test347() {
        String src = "A.B == 5";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("A.B == 5");
        Object result = script.execute(null);
        Assertions.assertFalse((boolean)((Boolean)result));
        jexl = new JexlBuilder().strict(true).safe(false).create();
        MapContext ctxt = new MapContext();
        JexlScript script1 = jexl.createScript("A.B == 5");
        Assertions.assertThrows(JexlException.class, () -> Issues300Test.lambda$test347$0(script1, (JexlContext)ctxt));
        ctxt.set("A", null);
        Assertions.assertThrows(JexlException.class, () -> Issues300Test.lambda$test347$1(script1, (JexlContext)ctxt), (String)"should only succeed with safe navigation");
        ctxt.set("A.B", null);
        result = script1.execute((JexlContext)ctxt);
        Assertions.assertFalse((boolean)((Boolean)result));
    }

    @Test
    void test349() {
        String text = "(A ? C.D : E)";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlExpression expr = jexl.createExpression("(A ? C.D : E)");
        JexlScript script = jexl.createScript("(A ? C.D : E)");
    }

    @Test
    void test361_33() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        Assertions.assertThrows(JexlException.class, () -> this.run361c(jexl), (String)"null arg should fail");
    }

    @Test
    void test361a_32() {
        Engine32 jexl = new Engine32(new JexlBuilder().safe(false));
        Object result = this.run361a((JexlEngine)jexl);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void test361a_33() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        Assertions.assertThrows(JexlException.class, () -> this.run361a(jexl), (String)"null arg should fail");
    }

    @Test
    void test361b_32() {
        Engine32 jexl = new Engine32(new JexlBuilder().safe(false).strict(false));
        Object result = this.run361b((JexlEngine)jexl);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void test361b_33() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        Assertions.assertThrows(JexlException.class, () -> this.run361b(jexl), (String)"null arg should fail");
    }

    @Test
    void test361c_32() {
        Engine32 jexl = new Engine32(new JexlBuilder().safe(false).strict(false));
        String result = this.run361c((JexlEngine)jexl);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void test361d_32() {
        Engine32 jexl = new Engine32(new JexlBuilder().lexical(false).lexicalShade(false).safe(false));
        Object result = this.run361d((JexlEngine)jexl);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void test361d_33() {
        JexlEngine jexl = new JexlBuilder().lexical(true).lexicalShade(true).safe(false).strict(true).create();
        Assertions.assertThrows(JexlException.class, () -> this.run361d(jexl), (String)"null arg should fail");
    }

    @Test
    void test367() {
        String text = "var toto; function foo(x) { x }; var tata = 3; foo(3)";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("var toto; function foo(x) { x }; var tata = 3; foo(3)");
        Object result = script.execute(null);
        Assertions.assertEquals((Object)3, (Object)result);
        String s0 = script.getParsedText();
        String s1 = script.getSourceText();
        Assertions.assertNotEquals((Object)s0, (Object)s1);
    }

    @Test
    void test370() {
        Var370 var370 = new Var370();
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        ObjectContext ctxt = new ObjectContext(jexl, (Object)var370);
        JexlExpression get = jexl.createExpression("name");
        var370.setName("John");
        Assertions.assertEquals((Object)"John", (Object)get.evaluate((JexlContext)ctxt));
        Assertions.assertTrue((boolean)ctxt.has("name"));
        var370.setName(null);
        Assertions.assertNull((Object)get.evaluate((JexlContext)ctxt));
        Assertions.assertTrue((boolean)ctxt.has("name"));
        JexlExpression get1 = jexl.createExpression("phone");
        Assertions.assertFalse((boolean)ctxt.has("phone"));
        JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> get1.evaluate((JexlContext)ctxt), (String)"phone should be undefined!");
        Assertions.assertEquals((Object)"phone", (Object)xvar.getVariable());
    }

    @Test
    void test373b() {
        String src = "var i = ++1";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlInfo info = new JexlInfo("badscript", 0, 0);
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript(info, "var i = ++1", new String[0]), (String)"should not parse");
        Assertions.assertTrue((boolean)xparse.getMessage().contains("badscript"));
    }

    @Test
    void test374() {
        JexlEngine engine = new JexlBuilder().cache(512).strict(true).silent(false).antish(false).safe(false).create();
        JexlExpression expr = engine.createExpression("nested.name");
        TestObject374 myObject = new TestObject374();
        myObject.setName("John");
        ObjectContext context = new ObjectContext(engine, (Object)myObject);
        Assertions.assertThrows(JexlException.class, () -> Issues300Test.lambda$test374$0(expr, (JexlContext)context));
    }

    @Test
    void test375() {
        JexlSandbox jexlSandbox = new JexlSandbox(false);
        jexlSandbox.allow(Type375.class.getName());
        JexlEngine engine = new JexlBuilder().sandbox(jexlSandbox).create();
        MapContext context = new MapContext();
        context.set("Type", Type375.class);
        Object result = engine.createScript("Type.valueOf('DOMICILE')").execute((JexlContext)context);
        Assertions.assertEquals((Object)((Object)Type375.DOMICILE), (Object)result);
        result = engine.createScript("Type.DOMICILE").execute((JexlContext)context);
        Assertions.assertEquals((Object)((Object)Type375.DOMICILE), (Object)result);
    }

    @Test
    void test377() {
        String text = "function add(x, y) { x + y } add(a, b)";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("function add(x, y) { x + y } add(a, b)", new String[]{"a", "b"});
        Object result = script.execute(null, new Object[]{20, 22});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void test379a() {
        String src = "#pragma jexl.import java.util\nconst map = new LinkedHashMap({0 : 'zero'});";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("#pragma jexl.import java.util\nconst map = new LinkedHashMap({0 : 'zero'});");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertNotNull((Object)result);
        Assertions.assertInstanceOf(LinkedHashMap.class, (Object)result);
        Assertions.assertEquals((int)1, (int)((Map)result).size());
    }

    @Test
    void test383() {
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic((JexlArithmetic)new Arithmetic383(true)).create();
        String src0 = "if (a) 1; else 2;";
        String src1 = "if (!a) 1; else 2;";
        JexlScript s0 = jexl.createScript("if (a) 1; else 2;", new String[]{"a"});
        JexlScript s1 = jexl.createScript("if (!a) 1; else 2;", new String[]{"a"});
        Assertions.assertEquals((Object)2, (Object)s0.execute(null, new Object[]{null}));
        Assertions.assertEquals((Object)1, (Object)s1.execute(null, new Object[]{null}));
        JexlScript s2 = jexl.createScript("if (a) 1; else 2;");
        JexlScript s3 = jexl.createScript("if (!a) 1; else 2;");
        JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> s2.execute(null, new Object[]{null}));
        Assertions.assertEquals((Object)"a", (Object)xvar.getVariable());
        xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> s3.execute(null, new Object[]{null}));
        Assertions.assertEquals((Object)"a", (Object)xvar.getVariable());
        MapContext ctxt = new MapContext();
        ctxt.set("a", null);
        Assertions.assertEquals((Object)2, (Object)s2.execute((JexlContext)ctxt, new Object[]{null}));
        Assertions.assertEquals((Object)1, (Object)s3.execute((JexlContext)ctxt, new Object[]{null}));
    }

    @Test
    void test384a() {
        Throwable xvar;
        MapContext ctxt;
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        for (String src0 : Arrays.asList("'ABC' + null", "null + 'ABC'")) {
            ctxt = new MapContext();
            JexlScript s0 = jexl.createScript(src0);
            xvar = (JexlException)Assertions.assertThrows(JexlException.class, () -> Issues300Test.lambda$test384a$0(s0, (JexlContext)ctxt), (String)"null argument should throw");
            Assertions.assertTrue((boolean)xvar.toString().contains("+"));
        }
        for (String src1 : Arrays.asList("'ABC' + a", "a + 'ABC'")) {
            ctxt = new MapContext();
            JexlScript s1 = jexl.createScript(src1, new String[]{"a"});
            xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> Issues300Test.lambda$test384a$1(s1, (JexlContext)ctxt), (String)"null argument should throw");
            Assertions.assertEquals((Object)"a", (Object)xvar.getVariable());
            JexlScript s2 = jexl.createScript(src1);
            xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> Issues300Test.lambda$test384a$2(s2, (JexlContext)ctxt), (String)"null argument should throw");
            Assertions.assertEquals((Object)"a", (Object)xvar.getVariable());
            Assertions.assertTrue((boolean)xvar.isUndefined());
            ctxt.set("a", null);
            xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> Issues300Test.lambda$test384a$3(s2, (JexlContext)ctxt), (String)"null argument should throw");
            Assertions.assertEquals((Object)"a", (Object)xvar.getVariable());
            Assertions.assertFalse((boolean)xvar.isUndefined());
        }
    }

    @Test
    void test384b() {
        MapContext ctxt;
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new Arithmetic384(true)).safe(false).strict(true).create();
        for (String src0 : Arrays.asList("'ABC' + null", "null + 'ABC'")) {
            ctxt = new MapContext();
            JexlScript s0 = jexl.createScript(src0);
            Assertions.assertEquals((Object)"ABC", (Object)s0.execute((JexlContext)ctxt));
        }
        for (String src1 : Arrays.asList("'ABC' + a", "a + 'ABC'")) {
            ctxt = new MapContext();
            JexlScript s1 = jexl.createScript(src1, new String[]{"a"});
            Assertions.assertEquals((Object)"ABC", (Object)s1.execute((JexlContext)ctxt, new Object[]{null}));
            JexlScript s2 = jexl.createScript(src1);
            JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> Issues300Test.lambda$test384b$0(s2, (JexlContext)ctxt), (String)"null argument should throw");
            Assertions.assertEquals((Object)"a", (Object)xvar.getVariable());
            Assertions.assertTrue((boolean)xvar.isUndefined());
            ctxt.set("a", null);
            Assertions.assertEquals((Object)"ABC", (Object)s1.execute((JexlContext)ctxt, new Object[]{null}));
        }
    }

    @Test
    void test384c() {
        Arithmetic384c ja = new Arithmetic384c(true);
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).arithmetic((JexlArithmetic)ja).create();
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("3 < 4").evaluate(null)));
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("6 <= 8").evaluate(null)));
        Assertions.assertFalse((boolean)ja.toBoolean(jexl.createExpression("6 == 7").evaluate(null)));
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("4 > 2").evaluate(null)));
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("8 > 6").evaluate(null)));
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("7 != 6").evaluate(null)));
        Assertions.assertEquals((int)6, (int)ja.getCmpCalls());
    }

    @Test
    void test384d() {
        Arithmetic384d ja = new Arithmetic384d(true);
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).arithmetic((JexlArithmetic)ja).create();
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("3 < 4").evaluate(null)));
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("6 <= 8").evaluate(null)));
        Assertions.assertFalse((boolean)ja.toBoolean(jexl.createExpression("6 == 7").evaluate(null)));
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("4 > 2").evaluate(null)));
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("8 > 6").evaluate(null)));
        Assertions.assertTrue((boolean)ja.toBoolean(jexl.createExpression("7 != 6").evaluate(null)));
        Assertions.assertEquals((int)6, (int)ja.getCmpCalls());
    }

    @Test
    void test390() throws Exception {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        JexlScript script = null;
        String src = "if (true) #pragma one 42";
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("if (true) #pragma one 42"), (String)"should have failed parsing");
        Assertions.assertTrue((boolean)xparse.getDetail().contains("pragma"));
        String src1 = "if (true) { #pragma one 42 }";
        script = jexl.createScript("if (true) { #pragma one 42 }");
        Object result = script.execute(null);
        Util.debuggerCheck(jexl);
    }

    @Test
    void test393() {
        String src = "const total = 0;\nif (true) {\n  total = 1;\n}\ntotal; ";
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("const total = 0;\nif (true) {\n  total = 1;\n}\ntotal; "), (String)"should fail on const total assignment");
        Assertions.assertTrue((boolean)xparse.getMessage().contains("total"));
    }

    @Test
    void testBackslashes() {
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        String src = "\"\b\t\f\"";
        JexlScript s = jexl.createScript("\"\b\t\f\"");
        Assertions.assertNotNull((Object)s);
        String ctl = "\b\t\f";
        Assertions.assertEquals((Object)"\b\t\f", (Object)s.execute(null));
        String parsed = s.getParsedText();
        Assertions.assertEquals((Object)"'\\b\\t\\f'", (Object)parsed);
        s = jexl.createScript("\"\b\t\f\"");
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((Object)"\b\t\f", (Object)s.execute(null));
        parsed = s.getParsedText();
        Assertions.assertEquals((Object)"'\\b\\t\\f'", (Object)parsed);
    }

    @Test
    void testDow() {
        String src = "(y, m, d)->{\n// will return 0 for Sunday, 6 for Saturday\nconst t = [0, 3, 2, 5, 0, 3, 5, 1, 4, 6, 2, 4];\nif (m < 3) { --y }\n(y + y/4 - y/100 + y/400 + t[m-1] + d) % 7;\n}";
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript("(y, m, d)->{\n// will return 0 for Sunday, 6 for Saturday\nconst t = [0, 3, 2, 5, 0, 3, 5, 1, 4, 6, 2, 4];\nif (m < 3) { --y }\n(y + y/4 - y/100 + y/400 + t[m-1] + d) % 7;\n}");
        Object r = script.execute(null, new Object[]{2023, 3, 1});
        Assertions.assertInstanceOf(Number.class, (Object)r);
        Number dow = (Number)r;
        Assertions.assertEquals((int)3, (int)dow.intValue());
        r = script.execute(null, new Object[]{1969, 7, 20});
        Assertions.assertInstanceOf(Number.class, (Object)r);
        dow = (Number)r;
        Assertions.assertEquals((int)0, (int)dow.intValue());
    }

    @Test
    void testIssue394() {
        StringBuilder x = new StringBuilder("foobar");
        Assertions.assertEquals((Object)"foobar", (Object)x.toString());
        String src = "x -> x.setLength(3)";
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript("x -> x.setLength(3)");
        Object result = script.execute(null, new Object[]{x});
        Assertions.assertEquals((Object)"foo", (Object)x.toString());
    }

    @Test
    void testIssue397() {
        String control = Class397.class.getName();
        JexlEngine jexl = new JexlBuilder().permissions(JexlPermissions.RESTRICTED).create();
        Class397 instance = new Class397();
        String result = (String)jexl.invokeMethod((Object)instance, "summary", new Object[0]);
        Assertions.assertEquals((Object)control, (Object)result);
        Interface397i proxy = (Interface397i)this.createProxy(jexl, instance, new Class[]{Interface397i.class});
        result = (String)jexl.invokeMethod((Object)proxy, "summary", new Object[0]);
        Assertions.assertEquals((Object)control, (Object)result);
        JexlScript script = jexl.createScript("dan.summary()", new String[]{"dan"});
        result = (String)script.execute(null, new Object[]{instance});
        Assertions.assertEquals((Object)control, (Object)result);
        result = (String)script.execute(null, new Object[]{proxy});
        Assertions.assertEquals((Object)control, (Object)result);
    }

    @Test
    void testIssue398a() {
        String src = "let m = {\n  \"foo\": 1,\n  \"bar\": 2,\n}";
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript("let m = {\n  \"foo\": 1,\n  \"bar\": 2,\n}");
        Object result = script.execute(null);
        Assertions.assertInstanceOf(Map.class, (Object)result);
        Map map = (Map)result;
        Assertions.assertEquals((int)2, (int)map.size());
    }

    @Test
    void testIssue398b() {
        Map<String, String> foo = Collections.singletonMap("X", "x");
        Map<String, String> bar = Collections.singletonMap("Y", "y");
        MapContext ctxt = new MapContext();
        ctxt.set("foo", foo);
        ctxt.set("bar", bar);
        String src = "let m = {\n  foo.X: 1,\n  bar.Y: 2,\n}";
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript("let m = {\n  foo.X: 1,\n  bar.Y: 2,\n}");
        Object result = script.execute((JexlContext)ctxt);
        Assertions.assertInstanceOf(Map.class, (Object)result);
        Map map = (Map)result;
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)1, map.get("x"));
        Assertions.assertEquals((Object)2, map.get("y"));
        script = jexl.createScript("let m = {\n  foo.X: 1,\n  bar.Y: 2,\n}", new String[]{"foo", "bar"});
        result = script.execute(null, new Object[]{foo, bar});
        Assertions.assertInstanceOf(Map.class, (Object)result);
        map = (Map)result;
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)1, map.get("x"));
        Assertions.assertEquals((Object)2, map.get("y"));
    }

    @Test
    void testIssue398c() {
        JexlEngine jexl = new JexlBuilder().create();
        Object empty = jexl.createScript("[,...]").execute(null);
        Assertions.assertNotNull((Object)empty);
        Assertions.assertTrue((boolean)(jexl.createScript("[1]").execute(null) instanceof int[]));
        Assertions.assertTrue((boolean)(jexl.createScript("[1,...]").execute(null) instanceof ArrayList));
        Assertions.assertTrue((boolean)(jexl.createScript("{1}").execute(null) instanceof HashSet));
        Assertions.assertTrue((boolean)(jexl.createScript("{1,...}").execute(null) instanceof LinkedHashSet));
        Assertions.assertTrue((boolean)(jexl.createScript("{'one': 1}").execute(null) instanceof HashMap));
        Assertions.assertTrue((boolean)(jexl.createScript("{'one': 1,...}").execute(null) instanceof LinkedHashMap));
    }

    @Test
    void testPropagateOptions() {
        String src0 = "`${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`";
        String text = "#pragma script.mode pro50\n()->{ ()->{ `${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`; } }";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("#pragma script.mode pro50\n()->{ ()->{ `${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`; } }");
        JexlContext context = Issues300Test.pragmaticContext();
        JexlScript closure = (JexlScript)script.execute(context);
        OptionsContext opts = new OptionsContext();
        Object result = closure.execute((JexlContext)opts);
        Assertions.assertEquals((Object)"+strict +cancellable +lexical +lexicalShade -sharedInstance -safe", (Object)result);
        String text0 = "#pragma script.mode pro50\n()->{ `${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`; }";
        JexlScript script0 = jexl.createScript("#pragma script.mode pro50\n()->{ `${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`; }");
        context = Issues300Test.pragmaticContext();
        Object result0 = script0.execute(context);
        Assertions.assertEquals((Object)"+strict +cancellable +lexical +lexicalShade -sharedInstance -safe", (Object)result0);
        String text1 = "#pragma script.mode pro50\n`${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`";
        JexlScript script1 = jexl.createScript("#pragma script.mode pro50\n`${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`");
        context = Issues300Test.pragmaticContext();
        Object result1 = script1.execute(context);
        Assertions.assertEquals((Object)"+strict +cancellable +lexical +lexicalShade -sharedInstance -safe", (Object)result1);
        String text2 = "`${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`";
        JexlScript script2 = jexl.createScript("`${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`");
        context = Issues300Test.pragmaticContext();
        Object result2 = script2.execute(context);
        Assertions.assertEquals((Object)"-strict -cancellable -lexical -lexicalShade +sharedInstance +safe", (Object)result2);
    }

    @Test
    void tests301b() {
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic(new JexlArithmetic(false)).create();
        Object[] xs = new Object[]{null, null, new Object[]{null, 1}};
        String[] srcs = new String[]{"x.0", "x[0]", "x[0][0]"};
        MapContext ctxt = new MapContext();
        for (int i = 0; i < xs.length; ++i) {
            ctxt.set("x", xs[i]);
            String src = srcs[i];
            JexlScript s = jexl.createScript(src);
            Assertions.assertThrows(JexlException.class, () -> s.execute(null));
        }
    }

    @Test
    void testSO20220930() {
        int i;
        ArrayList<Driver0930> values = new ArrayList<Driver0930>();
        for (i = 0; i < 8; ++i) {
            values.add(new Driver0930("drvr" + Integer.toOctalString(i)));
        }
        for (i = 0; i < 4; ++i) {
            values.add(new Driver0930("favorite" + Integer.toOctalString(i)));
        }
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        Context0930 context = new Context0930();
        context.set("values", values);
        context.set("Collectors", Collectors.class);
        String src32 = "values.stream().filter((driver) ->{ driver.attributeName =^ 'favorite' }).collect(Collectors.toList())";
        String src33 = "values.stream().filter(driver -> driver.attributeName =^ 'favorite').collect(Collectors.toList())";
        for (String src : Arrays.asList("values.stream().filter((driver) ->{ driver.attributeName =^ 'favorite' }).collect(Collectors.toList())", "values.stream().filter(driver -> driver.attributeName =^ 'favorite').collect(Collectors.toList())")) {
            JexlExpression s = jexl.createExpression(src);
            Assertions.assertNotNull((Object)s);
            Object r = s.evaluate((JexlContext)context);
            Assertions.assertNotNull((Object)r);
            List l = (List)r;
            Assertions.assertEquals((int)4, (int)l.size());
            for (Driver0930 d : l) {
                Assertions.assertTrue((boolean)d.getAttributeName().startsWith("favorite"));
            }
        }
    }

    @Test
    void testUnsolvableMethod() {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript("var myFunction1 = function(object) { myNonExistentFunction();}var myFunction2 = function(object) { myFunction1();}myFunction2();");
        JexlException.Method unsolvable = (JexlException.Method)Assertions.assertThrows(JexlException.Method.class, () -> script.execute((JexlContext)new MapContext()));
        Assertions.assertEquals((Object)"myNonExistentFunction", (Object)unsolvable.getMethod());
    }

    private static /* synthetic */ void lambda$test384b$0(JexlScript s2, JexlContext ctxt) throws Throwable {
        s2.execute(ctxt, new Object[]{null});
    }

    private static /* synthetic */ void lambda$test384a$3(JexlScript s2, JexlContext ctxt) throws Throwable {
        s2.execute(ctxt, new Object[]{null});
    }

    private static /* synthetic */ void lambda$test384a$2(JexlScript s2, JexlContext ctxt) throws Throwable {
        s2.execute(ctxt, new Object[]{null});
    }

    private static /* synthetic */ void lambda$test384a$1(JexlScript s1, JexlContext ctxt) throws Throwable {
        s1.execute(ctxt, new Object[]{null});
    }

    private static /* synthetic */ void lambda$test384a$0(JexlScript s0, JexlContext ctxt) throws Throwable {
        s0.execute(ctxt, new Object[]{null});
    }

    private static /* synthetic */ void lambda$test374$0(JexlExpression expr, JexlContext context) throws Throwable {
        expr.evaluate(context);
    }

    private static /* synthetic */ void lambda$test347$1(JexlScript script1, JexlContext ctxt) throws Throwable {
        script1.execute(ctxt);
    }

    private static /* synthetic */ void lambda$test347$0(JexlScript script1, JexlContext ctxt) throws Throwable {
        script1.execute(ctxt);
    }

    private static /* synthetic */ void lambda$test323$4(JexlScript script4, JexlContext jc) throws Throwable {
        script4.execute(jc);
    }

    private static /* synthetic */ void lambda$test323$3(JexlScript script3, JexlContext jc) throws Throwable {
        script3.execute(jc);
    }

    private static /* synthetic */ void lambda$test323$2(JexlScript script2, JexlContext jc) throws Throwable {
        script2.execute(jc);
    }

    private static /* synthetic */ void lambda$test323$1(JexlScript script1, JexlContext jc) throws Throwable {
        script1.execute(jc);
    }

    private static /* synthetic */ void lambda$test323$0(JexlScript script0, JexlContext jc) throws Throwable {
        script0.execute(jc);
    }

    public static class VaContext
    extends MapContext {
        VaContext(Map<String, Object> vars) {
            super(vars);
        }

        public int cell(List<?> l, String ... ms) {
            return 42 + this.cell(ms);
        }

        public int cell(String ... ms) {
            return ms.length;
        }
    }

    public static class Session322 {
        public User322 getUser() {
            return new User322();
        }
    }

    public static class User322 {
        public String getName() {
            return "user322";
        }
    }

    public static class Var370 {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String s) {
            this.name = s;
        }
    }

    public static class TestObject374 {
        private String name;
        private TestObject374 nested;

        public String getName() {
            return this.name;
        }

        public TestObject374 getNested() {
            return this.nested;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNested(TestObject374 nested) {
            this.nested = nested;
        }
    }

    public static enum Type375 {
        DELIVERY_ADDRESS,
        DOMICILE;

    }

    public static class Arithmetic383
    extends JexlArithmetic {
        public Arithmetic383(boolean astrict) {
            super(astrict);
        }

        public boolean isStrict(JexlOperator op) {
            switch (op) {
                case NOT: 
                case CONDITION: {
                    return false;
                }
            }
            return super.isStrict(op);
        }
    }

    public static class Arithmetic384
    extends JexlArithmetic {
        public Arithmetic384(boolean astrict) {
            super(astrict);
        }

        public boolean isStrict(JexlOperator op) {
            if (JexlOperator.ADD == op) {
                return false;
            }
            return super.isStrict(op);
        }
    }

    public static class Arithmetic384c
    extends JexlArithmetic {
        AtomicInteger cmp = new AtomicInteger();

        public Arithmetic384c(boolean astrict) {
            super(astrict);
        }

        public Arithmetic384c(boolean astrict, MathContext bigdContext, int bigdScale) {
            super(astrict, bigdContext, bigdScale);
        }

        protected int compare(Object l, Object r, String op) {
            this.cmp.incrementAndGet();
            return super.compare(l, r, op);
        }

        int getCmpCalls() {
            return this.cmp.get();
        }
    }

    public static class Arithmetic384d
    extends Arithmetic384c {
        public Arithmetic384d(boolean astrict) {
            super(astrict);
        }

        public Arithmetic384d(boolean astrict, MathContext bigdContext, int bigdScale) {
            super(astrict, bigdContext, bigdScale);
        }
    }

    private static class Class397
    implements Interface397i {
        private Class397() {
        }

        @Override
        public String summary() {
            return this.getClass().getName();
        }
    }

    public static interface Interface397i {
        public String summary();
    }

    public static class Driver0930 {
        private final String name;

        Driver0930(String n) {
            this.name = n;
        }

        public String getAttributeName() {
            return this.name;
        }
    }

    public static class Context0930
    extends MapContext {
        public Stream<?> filter(Stream<?> stream, JexlScript filter) {
            return stream.filter(x -> Boolean.TRUE.equals(filter.execute((JexlContext)this, new Object[]{x})));
        }
    }
}

