/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;

public class BlockTest
extends JexlTestCase {
    public BlockTest(String testName) {
        super(testName);
    }

    public void testBlockSimple() throws Exception {
        Expression e = this.JEXL.createExpression("if (true) { 'hello'; }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        BlockTest.assertEquals((String)"Result is wrong", (Object)"hello", (Object)o);
    }

    public void testBlockExecutesAll() throws Exception {
        Expression e = this.JEXL.createExpression("if (true) { x = 'Hello'; y = 'World';}");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        BlockTest.assertEquals((String)"First result is wrong", (Object)"Hello", (Object)jc.get("x"));
        BlockTest.assertEquals((String)"Second result is wrong", (Object)"World", (Object)jc.get("y"));
        BlockTest.assertEquals((String)"Block result is wrong", (Object)"World", (Object)o);
    }

    public void testEmptyBlock() throws Exception {
        Expression e = this.JEXL.createExpression("if (true) { }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        BlockTest.assertNull((String)"Result is wrong", (Object)o);
    }

    public void testBlockLastExecuted01() throws Exception {
        Expression e = this.JEXL.createExpression("if (true) { x = 1; } else { x = 2; }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        BlockTest.assertEquals((String)"Block result is wrong", (Object)new Integer(1), (Object)o);
    }

    public void testBlockLastExecuted02() throws Exception {
        Expression e = this.JEXL.createExpression("if (false) { x = 1; } else { x = 2; }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        BlockTest.assertEquals((String)"Block result is wrong", (Object)new Integer(2), (Object)o);
    }

    public void testNestedBlock() throws Exception {
        Expression e = this.JEXL.createExpression("if (true) { x = 'hello'; y = 'world'; if (true) { x; } y; }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        BlockTest.assertEquals((String)"Block result is wrong", (Object)"world", (Object)o);
    }
}

