/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheConfigurator;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.jcache.Asserts;
import org.apache.commons.jcs3.jcache.ExpiryAwareCache;
import org.apache.commons.jcs3.jcache.ImmutableIterable;
import org.apache.commons.jcs3.jcache.JCSCache;
import org.apache.commons.jcs3.jcache.JCSCachingProvider;
import org.apache.commons.jcs3.jcache.JCSConfiguration;
import org.apache.commons.jcs3.jcache.lang.Subsitutor;
import org.apache.commons.jcs3.jcache.proxy.ClassLoaderAwareCache;

public class JCSCachingManager
implements CacheManager {
    private static final Subsitutor SUBSTITUTOR = Subsitutor.Helper.INSTANCE;
    private static final String DEFAULT_CONFIG = "jcs.default=DC\njcs.default.cacheattributes=org.apache.commons.jcs3.engine.CompositeCacheAttributes\njcs.default.cacheattributes.MaxObjects=200001\njcs.default.cacheattributes.MemoryCacheName=org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache\njcs.default.cacheattributes.UseMemoryShrinker=true\njcs.default.cacheattributes.MaxMemoryIdleTimeSeconds=3600\njcs.default.cacheattributes.ShrinkerIntervalSeconds=60\njcs.default.elementattributes=org.apache.commons.jcs3.engine.ElementAttributes\njcs.default.elementattributes.IsEternal=false\njcs.default.elementattributes.MaxLife=700\njcs.default.elementattributes.IdleTime=1800\njcs.default.elementattributes.IsSpool=true\njcs.default.elementattributes.IsRemote=true\njcs.default.elementattributes.IsLateral=true\n";
    private final CachingProvider provider;
    private final URI uri;
    private final ClassLoader loader;
    private final Properties properties;
    private final ConcurrentMap<String, Cache<?, ?>> caches = new ConcurrentHashMap();
    private final Properties configProperties;
    private volatile boolean closed;
    private final InternalManager delegate = InternalManager.create();

    public JCSCachingManager(CachingProvider provider, URI uri, ClassLoader loader, Properties properties) {
        this.provider = provider;
        this.uri = uri;
        this.loader = loader;
        this.properties = JCSCachingManager.readConfig(uri, loader, properties);
        this.configProperties = properties;
        this.delegate.setJmxName("org.apache.commons.jcs3:type=JCSAdminBean,provider=" + provider.hashCode() + ",uri=" + uri.toString().replaceAll(",|:|=|\n", ".") + ",classloader=" + loader.hashCode() + ",properties=" + this.properties.hashCode());
        this.delegate.initialize();
        this.delegate.configure(this.properties);
    }

    private static Properties readConfig(URI uri, ClassLoader loader, Properties properties) {
        Properties props = new Properties();
        try {
            if (JCSCachingProvider.DEFAULT_URI.toString().equals(uri.toString()) || uri.toURL().getProtocol().equals("jcs")) {
                Enumeration<URL> resources = loader.getResources(uri.getPath());
                if (!resources.hasMoreElements()) {
                    props.load(new ByteArrayInputStream(DEFAULT_CONFIG.getBytes(StandardCharsets.UTF_8)));
                } else {
                    do {
                        JCSCachingManager.addProperties(resources.nextElement(), props);
                    } while (resources.hasMoreElements());
                }
            } else {
                props.load(uri.toURL().openStream());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (properties != null) {
            props.putAll((Map<?, ?>)properties);
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String substitute;
            if (entry.getValue() == null || (substitute = SUBSTITUTOR.substitute(entry.getValue().toString())).equals(entry.getValue())) continue;
            entry.setValue(substitute);
        }
        return props;
    }

    private static void addProperties(URL url, Properties aggregator) {
        try (InputStream inStream = url.openStream();){
            aggregator.load(inStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void assertNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cache manager closed");
        }
    }

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        Asserts.assertNotNull(configuration, "configuration");
        Class keyType = configuration.getKeyType();
        Class valueType = configuration.getValueType();
        if (this.caches.containsKey(cacheName)) {
            throw new CacheException("cache " + cacheName + " already exists");
        }
        Cache cache = ClassLoaderAwareCache.wrap(this.loader, new JCSCache(this.loader, this, cacheName, new JCSConfiguration(configuration, keyType, valueType), this.properties, (ExpiryAwareCache)((Object)ExpiryAwareCache.class.cast(this.delegate.getCache(cacheName)))));
        this.caches.putIfAbsent(cacheName, cache);
        return this.getCache(cacheName, keyType, valueType);
    }

    public void destroyCache(String cacheName) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        Cache cache = (Cache)this.caches.remove(cacheName);
        if (cache != null && !cache.isClosed()) {
            cache.clear();
            cache.close();
        }
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        JCSCache<?, ?> cache = this.getJCSCache(cacheName);
        if (cache != null) {
            if (enabled) {
                cache.enableManagement();
            } else {
                cache.disableManagement();
            }
        }
    }

    private JCSCache<?, ?> getJCSCache(String cacheName) {
        Cache cache = (Cache)this.caches.get(cacheName);
        return (JCSCache)JCSCache.class.cast(ClassLoaderAwareCache.getDelegate(cache));
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        JCSCache<?, ?> cache = this.getJCSCache(cacheName);
        if (cache != null) {
            if (enabled) {
                cache.enableStatistics();
            } else {
                cache.disableStatistics();
            }
        }
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.assertNotClosed();
        for (Cache c : this.caches.values()) {
            c.close();
        }
        this.caches.clear();
        this.closed = true;
        if (JCSCachingProvider.class.isInstance(this.provider)) {
            ((JCSCachingProvider)JCSCachingProvider.class.cast(this.provider)).remove(this);
        }
        this.delegate.shutDown();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException(clazz.getName() + " not supported in unwrap");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        return this.doGetCache(cacheName, Object.class, Object.class);
    }

    public Iterable<String> getCacheNames() {
        return new ImmutableIterable<String>(this.caches.keySet());
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        Asserts.assertNotNull(keyType, "keyType");
        Asserts.assertNotNull(valueType, "valueType");
        try {
            return this.doGetCache(cacheName, keyType, valueType);
        }
        catch (IllegalArgumentException iae) {
            throw new ClassCastException(iae.getMessage());
        }
    }

    private <K, V> Cache<K, V> doGetCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        Cache cache = (Cache)this.caches.get(cacheName);
        if (cache == null) {
            return null;
        }
        Configuration config = cache.getConfiguration(Configuration.class);
        if (keyType != null && !config.getKeyType().isAssignableFrom(keyType) || valueType != null && !config.getValueType().isAssignableFrom(valueType)) {
            throw new IllegalArgumentException("this cache is <" + config.getKeyType().getName() + ", " + config.getValueType().getName() + ">  and not <" + keyType.getName() + ", " + valueType.getName() + ">");
        }
        return cache;
    }

    public CachingProvider getCachingProvider() {
        return this.provider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Properties getProperties() {
        return this.configProperties;
    }

    public void release(String name) {
        this.caches.remove(name);
    }

    private static class InternalManager
    extends CompositeCacheManager {
        private InternalManager() {
        }

        protected static InternalManager create() {
            return new InternalManager();
        }

        protected CompositeCacheConfigurator newConfigurator() {
            return new CompositeCacheConfigurator(){

                protected <K, V> CompositeCache<K, V> newCache(ICompositeCacheAttributes cca, IElementAttributes ea) {
                    return new ExpiryAwareCache(cca, ea);
                }
            };
        }

        protected void initialize() {
            super.initialize();
        }
    }
}

