/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.AbstractBinaryOutputStream;
import org.apache.commons.imaging.common.GenericImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcBlock;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcParser;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcType;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypes;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.commons.imaging.test.TestResources;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class IptcParserTest {
    @ParameterizedTest
    @CsvSource(value={"\u00e4\u00f6\u00fc \u00c4\u00d6\u00dc\u00df, true", "\u00e4\u00f6\u00fc \u00c4\u00d6\u00dc\u00df \u20ac, true", "\u00e4\u00f6\u00fc \u00c4\u00d6\u00dc\u00df, false", "\u00e4\u00f6\u00fc \u00c4\u00d6\u00dc\u00df \u20ac, false"})
    public void testEncoding(String value, boolean forceUtf8) throws IOException {
        byte[] applicationRecord;
        byte[] prefix;
        Charset charset;
        IptcParser parser = new IptcParser();
        ArrayList<IptcRecord> records = new ArrayList<IptcRecord>();
        records.add(new IptcRecord((IptcType)IptcTypes.CAPTION_ABSTRACT, value));
        byte[] actualBytes = parser.writeIptcBlock(records, forceUtf8);
        try (ByteArrayOutputStream envelopeRecordStream = new ByteArrayOutputStream();
             AbstractBinaryOutputStream bos = AbstractBinaryOutputStream.create((OutputStream)envelopeRecordStream, (ByteOrder)parser.getByteOrder());){
            if (forceUtf8 || value.contains("\u20ac")) {
                bos.write(28);
                bos.write(1);
                bos.write(90);
                byte[] codedCharset = new byte[]{27, 37, 71};
                bos.write2Bytes(codedCharset.length);
                bos.write(codedCharset);
                charset = StandardCharsets.UTF_8;
            } else {
                charset = StandardCharsets.ISO_8859_1;
            }
            bos.write(28);
            bos.write(2);
            bos.write(IptcTypes.RECORD_VERSION.type);
            bos.write2Bytes(2);
            bos.write2Bytes(2);
            prefix = envelopeRecordStream.toByteArray();
        }
        try (ByteArrayOutputStream applicationRecordStream = new ByteArrayOutputStream();
             AbstractBinaryOutputStream bos = AbstractBinaryOutputStream.create((OutputStream)applicationRecordStream, (ByteOrder)parser.getByteOrder());){
            bos.write(28);
            bos.write(2);
            bos.write(IptcTypes.CAPTION_ABSTRACT.type);
            byte[] valueBytes = value.getBytes(charset);
            bos.write2Bytes(valueBytes.length);
            bos.write(valueBytes);
            applicationRecord = applicationRecordStream.toByteArray();
        }
        byte[] actualPrefix = ArrayUtils.subarray((byte[])actualBytes, (int)0, (int)prefix.length);
        byte[] actualApplicationRecord = ArrayUtils.subarray((byte[])actualBytes, (int)prefix.length, (int)(prefix.length + applicationRecord.length));
        Assertions.assertArrayEquals((byte[])prefix, (byte[])actualPrefix);
        Assertions.assertArrayEquals((byte[])applicationRecord, (byte[])actualApplicationRecord);
    }

    @Test
    public void testEncodingSupport() throws IOException, ImagingException {
        File file = TestResources.resourceToFile("/images/jpeg/iptc/IMAGING-168/111083453-c07f1880-851e-11eb-8b61-2757f7d934bf.jpg");
        JpegImageParser parser = new JpegImageParser();
        JpegImageMetadata metadata = (JpegImageMetadata)parser.getMetadata(file);
        JpegPhotoshopMetadata photoshopMetadata = metadata.getPhotoshop();
        List items = photoshopMetadata.getItems();
        GenericImageMetadata.GenericImageMetadataItem thanksInMandarin = (GenericImageMetadata.GenericImageMetadataItem)items.get(3);
        Assertions.assertArrayEquals((byte[])"\u8c22\u8c22".getBytes(StandardCharsets.UTF_8), (byte[])thanksInMandarin.getText().getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void testSkipBlockTypes() throws ImagingException, IOException {
        File imageFile = TestResources.resourceToFile("/images/jpeg/photoshop/IMAGING-246/FallHarvestKitKat_07610.jpg");
        JpegImageMetadata metadata = (JpegImageMetadata)new JpegImageParser().getMetadata(ByteSource.file((File)imageFile), new JpegImagingParameters());
        JpegPhotoshopMetadata photoshopMetadata = metadata.getPhotoshop();
        PhotoshopApp13Data photoshopApp13Data = photoshopMetadata.photoshopApp13Data;
        List blocks = photoshopApp13Data.getRawBlocks();
        Assertions.assertEquals((int)2, (int)blocks.size());
        for (IptcBlock block : blocks) {
            if (block.getBlockType() == 1028 || block.getBlockType() == 1061) {
                byte[] data = block.getBlockData();
                Assertions.assertTrue((data.length > 0 ? 1 : 0) != 0);
                continue;
            }
            Assertions.fail((String)("Unexpected block type found: " + block.getBlockType()));
        }
    }
}

