/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.fileupload2.core.DeferrableOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class DeferrableOutputStreamTest {
    private static final Path testDir = Paths.get("target/unit-tests/DeferrableOutputStreamTest", new String[0]);
    private static Path tempTestDir;
    private Supplier<Path> testFileSupplier = () -> {
        try {
            return Files.createTempFile(tempTestDir, "testFile", ".bin", new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    };

    DeferrableOutputStreamTest() {
    }

    @BeforeAll
    static void setUpTestDirs() throws IOException {
        Files.createDirectories(testDir, new FileAttribute[0]);
        tempTestDir = Files.createTempDirectory(testDir, "testDir", new FileAttribute[0]);
    }

    protected byte[] read(InputStream pIs) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int res;
        while ((res = pIs.read(buffer)) != -1) {
            if (res <= 0) continue;
            baos.write(buffer, 0, res);
        }
        return baos.toByteArray();
    }

    @Test
    void testExceedPositiveThreshold() {
        DeferrableOutputStream[] streams = new DeferrableOutputStream[1];
        Consumer<Consumer> tester = consumer -> {
            byte[] actual;
            DeferrableOutputStream dos;
            try {
                dos = new DeferrableOutputStream(5, this.testFileSupplier, null);
                try {
                    streams[0] = dos;
                    Assertions.assertTrue((boolean)dos.isInMemory());
                    Assertions.assertNull((Object)dos.getPath());
                    Assertions.assertNull((Object)dos.getBytes());
                    Assertions.assertSame((Object)DeferrableOutputStream.State.initialized, (Object)dos.getState());
                    for (int i = 0; i < 4; ++i) {
                        try {
                            dos.write(46);
                        }
                        catch (IOException ioe) {
                            throw new UncheckedIOException(ioe);
                        }
                        Assertions.assertSame((Object)DeferrableOutputStream.State.opened, (Object)dos.getState());
                        Assertions.assertTrue((boolean)dos.isInMemory());
                        Assertions.assertNull((Object)dos.getPath());
                        Assertions.assertNull((Object)dos.getBytes());
                    }
                    consumer.accept(dos);
                    Assertions.assertFalse((boolean)dos.isInMemory());
                    Assertions.assertNotNull((Object)dos.getPath());
                    Assertions.assertNull((Object)dos.getBytes());
                }
                finally {
                    dos.close();
                }
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            dos = streams[0];
            Assertions.assertFalse((boolean)dos.isInMemory());
            Assertions.assertNotNull((Object)dos.getPath());
            Assertions.assertTrue((boolean)Files.isRegularFile(dos.getPath(), new LinkOption[0]));
            try (InputStream is = dos.getInputStream();){
                actual = this.read(is);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            byte[] expect = "....,".getBytes(StandardCharsets.UTF_8);
            Assertions.assertArrayEquals((byte[])expect, (byte[])actual);
        };
        tester.accept(os -> {
            try {
                os.write(44);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        });
        tester.accept(os -> {
            byte[] buffer = new byte[]{44};
            try {
                os.write(buffer);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        });
        tester.accept(os -> {
            byte[] buffer = new byte[]{44, 45};
            try {
                os.write(buffer, 0, 1);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        });
    }

    @Test
    void testThresholdMinusOne() {
        DeferrableOutputStream[] streams = new DeferrableOutputStream[1];
        Runnable tester = () -> {
            byte[] actual;
            DeferrableOutputStream dos;
            try {
                dos = new DeferrableOutputStream(-1, this.testFileSupplier, null);
                try {
                    streams[0] = dos;
                    Assertions.assertFalse((boolean)dos.isInMemory());
                    Assertions.assertNotNull((Object)dos.getPath());
                    Assertions.assertNull((Object)dos.getBytes());
                }
                finally {
                    dos.close();
                }
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            dos = streams[0];
            Assertions.assertFalse((boolean)dos.isInMemory());
            Assertions.assertNotNull((Object)dos.getPath());
            Assertions.assertTrue((boolean)Files.isRegularFile(dos.getPath(), new LinkOption[0]));
            try (InputStream is = dos.getInputStream();){
                actual = this.read(is);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            byte[] expect = "".getBytes(StandardCharsets.UTF_8);
            Assertions.assertArrayEquals((byte[])expect, (byte[])actual);
        };
        tester.run();
    }

    @Test
    void testThresholdZero() {
        DeferrableOutputStream[] streams = new DeferrableOutputStream[1];
        Consumer<Consumer> tester = consumer -> {
            byte[] actual;
            DeferrableOutputStream dos;
            try {
                dos = new DeferrableOutputStream(0, this.testFileSupplier, null);
                try {
                    streams[0] = dos;
                    Assertions.assertTrue((boolean)dos.isInMemory());
                    Assertions.assertNull((Object)dos.getPath());
                    Assertions.assertNull((Object)dos.getBytes());
                    Assertions.assertSame((Object)DeferrableOutputStream.State.initialized, (Object)dos.getState());
                    consumer.accept(dos);
                    Assertions.assertFalse((boolean)dos.isInMemory());
                    Assertions.assertNotNull((Object)dos.getPath());
                    Assertions.assertNull((Object)dos.getBytes());
                }
                finally {
                    dos.close();
                }
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            dos = streams[0];
            Assertions.assertFalse((boolean)dos.isInMemory());
            Assertions.assertNotNull((Object)dos.getPath());
            Assertions.assertTrue((boolean)Files.isRegularFile(dos.getPath(), new LinkOption[0]));
            try (InputStream is = dos.getInputStream();){
                actual = this.read(is);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            byte[] expect = ",".getBytes(StandardCharsets.UTF_8);
            Assertions.assertArrayEquals((byte[])expect, (byte[])actual);
        };
        tester.accept(os -> {
            try {
                os.write(44);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        });
        tester.accept(os -> {
            byte[] buffer = new byte[]{44};
            try {
                os.write(buffer);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        });
        tester.accept(os -> {
            byte[] buffer = new byte[]{44, 45};
            try {
                os.write(buffer, 0, 1);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        });
    }
}

