/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.ClassConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClassConverterTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testArray() {
        ClassConverter converter = new ClassConverter();
        Assertions.assertEquals((Object)"[Ljava.lang.Boolean;", (Object)converter.convert(String.class, Boolean[].class), (String)"Array to String");
    }

    @Test
    public void testConvertToClass() {
        ClassConverter converter = new ClassConverter();
        Assertions.assertEquals(Integer.class, (Object)converter.convert(Class.class, Integer.class), (String)"Class Test");
        Assertions.assertEquals(Integer.class, (Object)converter.convert(Class.class, (Object)"java.lang.Integer"), (String)"String Test");
        Assertions.assertEquals(Integer.class, (Object)converter.convert(Class.class, (Object)new StringBuilder("java.lang.Integer")), (String)"StringBuilder Test");
        Assertions.assertThrows(ConversionException.class, () -> ClassConverterTest.lambda$testConvertToClass$0((Converter)converter));
        Assertions.assertThrows(ConversionException.class, () -> ClassConverterTest.lambda$testConvertToClass$1((Converter)converter));
    }

    @Test
    public void testConvertToClassDefault() {
        ClassConverter converter = new ClassConverter(Object.class);
        Assertions.assertEquals(Object.class, (Object)converter.convert(Class.class, (Object)6), (String)"Invalid Test");
        Assertions.assertEquals(Object.class, (Object)converter.convert(Class.class, null), (String)"Null Test");
    }

    @Test
    public void testConvertToClassDefaultNull() {
        ClassConverter converter = new ClassConverter(null);
        Assertions.assertEquals(null, (Object)converter.convert(Class.class, (Object)6), (String)"Invalid Test");
        Assertions.assertEquals(null, (Object)converter.convert(Class.class, null), (String)"Null Test");
    }

    @Test
    public void testConvertToString() {
        ClassConverter converter = new ClassConverter();
        Assertions.assertEquals((Object)"java.lang.Integer", (Object)converter.convert(String.class, Integer.class), (String)"Class Test");
        Assertions.assertEquals((Object)"foo", (Object)converter.convert(String.class, (Object)"foo"), (String)"Value Test");
        Assertions.assertEquals((Object)"bar", (Object)converter.convert(String.class, (Object)new StringBuilder("bar")), (String)"Value Test");
        Assertions.assertEquals(null, (Object)converter.convert(String.class, null), (String)"Null Test");
    }

    @Test
    public void testInvalid() {
        ClassConverter converter = new ClassConverter();
        Assertions.assertThrows(ConversionException.class, () -> ClassConverterTest.lambda$testInvalid$2((Converter)converter));
    }

    @Test
    public void testUnsupportedTargetType() {
        ClassConverter converter = new ClassConverter();
        Assertions.assertThrows(ConversionException.class, () -> this.lambda$testUnsupportedTargetType$3((Converter)converter));
    }

    private /* synthetic */ void lambda$testUnsupportedTargetType$3(Converter converter) throws Throwable {
        converter.convert(Integer.class, (Object)this.getClass().getName());
    }

    private static /* synthetic */ void lambda$testInvalid$2(Converter converter) throws Throwable {
        converter.convert(Class.class, (Object)"foo.bar");
    }

    private static /* synthetic */ void lambda$testConvertToClass$1(Converter converter) throws Throwable {
        converter.convert(Class.class, null);
    }

    private static /* synthetic */ void lambda$testConvertToClass$0(Converter converter) throws Throwable {
        converter.convert(Class.class, (Object)6);
    }
}

