/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.beanutils2.AlphaBean;
import org.apache.commons.beanutils2.BasicDynaBeanTest;
import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.FluentIntrospectionTestBean;
import org.apache.commons.beanutils2.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.apache.commons.beanutils2.TestBean;
import org.apache.commons.beanutils2.WrapDynaBean;
import org.apache.commons.beanutils2.WrapDynaClass;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WrapDynaBeanTest
extends BasicDynaBeanTest {
    private void checkSimplePropertyAccess() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.get("invalidProperty"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.set("invalidProperty", (Object)"XYZ"));
        String testValue = "Original Value";
        String testProperty = "stringProperty";
        TestBean instance = (TestBean)((WrapDynaBean)this.bean).getInstance();
        instance.setStringProperty(testValue);
        Assertions.assertEquals((Object)testValue, (Object)instance.getStringProperty(), (String)"Check String property");
        testValue = "Some new value";
        this.bean.set("stringProperty", (Object)testValue);
        Assertions.assertEquals((Object)testValue, (Object)instance.getStringProperty(), (String)"Test Set");
        Assertions.assertEquals((Object)testValue, (Object)this.bean.get("stringProperty"), (String)"Test Get");
    }

    private Object serializeDeserialize(Object target, String text) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(target);
            oos.flush();
        }
        Object result = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
             ObjectInputStream ois = new ObjectInputStream(bais);){
            result = ois.readObject();
        }
        return result;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.bean = new WrapDynaBean((Object)new TestBean());
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.bean = null;
    }

    @Test
    public void testGetInstance() {
        AlphaBean alphaBean = new AlphaBean("Now On Air... John Peel");
        WrapDynaBean dynaBean = new WrapDynaBean((Object)alphaBean);
        Object wrappedInstance = dynaBean.getInstance();
        Assertions.assertInstanceOf(AlphaBean.class, (Object)wrappedInstance, (String)"Object type is AlphaBean");
        AlphaBean wrappedAlphaBean = (AlphaBean)wrappedInstance;
        Assertions.assertSame((Object)wrappedAlphaBean, (Object)alphaBean, (String)"Same Object");
    }

    @Test
    public void testGetWrapDynaClassFromCache() {
        WrapDynaClass clazz = WrapDynaClass.createDynaClass(TestBean.class);
        Assertions.assertSame((Object)clazz, (Object)WrapDynaClass.createDynaClass(TestBean.class), (String)"Instance not cached");
    }

    @Test
    public void testGetWrapDynaClassFromCacheWithPropUtils() {
        WrapDynaClass clazz = WrapDynaClass.createDynaClass(TestBean.class);
        PropertyUtilsBean pu = new PropertyUtilsBean();
        WrapDynaClass clazz2 = WrapDynaClass.createDynaClass(TestBean.class, (PropertyUtilsBean)pu);
        Assertions.assertNotSame((Object)clazz, (Object)clazz2, (String)"Got same instance from cache");
    }

    @Test
    public void testIndexedProperties() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.get("invalidProperty", 0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.bean.set("invalidProperty", 0, (Object)"XYZ"));
        String testValue = "Original Value";
        String testProperty = "stringIndexed";
        TestBean instance = (TestBean)((WrapDynaBean)this.bean).getInstance();
        instance.setStringIndexed(0, testValue);
        Assertions.assertEquals((Object)testValue, (Object)instance.getStringIndexed(0), (String)"Check String property");
        testValue = "Some new value";
        this.bean.set("stringIndexed", 0, (Object)testValue);
        Assertions.assertEquals((Object)testValue, (Object)instance.getStringIndexed(0), (String)"Test Set");
        Assertions.assertEquals((Object)testValue, (Object)this.bean.get("stringIndexed", 0), (String)"Test Get");
    }

    @Test
    public void testInitWithDynaClass() {
        WrapDynaClass clazz = WrapDynaClass.createDynaClass(TestBean.class);
        this.bean = new WrapDynaBean((Object)new TestBean(), clazz);
        Assertions.assertSame((Object)clazz, (Object)this.bean.getDynaClass(), (String)"Wrong DynaClass");
        this.checkSimplePropertyAccess();
    }

    @Test
    public void testIntrospectionWithCustomPropUtils() {
        PropertyUtilsBean pu = new PropertyUtilsBean();
        pu.addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
        WrapDynaClass dynaClass = WrapDynaClass.createDynaClass(FluentIntrospectionTestBean.class, (PropertyUtilsBean)pu);
        FluentIntrospectionTestBean obj = new FluentIntrospectionTestBean();
        this.bean = new WrapDynaBean((Object)obj, dynaClass);
        this.bean.set("fluentProperty", (Object)"testvalue");
        Assertions.assertEquals((Object)"testvalue", (Object)obj.getStringProperty(), (String)"Property not set");
    }

    @Override
    @Test
    public void testMappedContains() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.bean.contains("mappedProperty", "First Key"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.bean.contains("mappedProperty", "Unknown Key"));
    }

    @Override
    @Test
    public void testMappedRemove() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.bean.contains("mappedProperty", "First Key"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.bean.remove("mappedProperty", "First Key"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.bean.contains("mappedProperty", "Unknown Key"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.bean.remove("mappedProperty", "Unknown Key"));
    }

    @Test
    public void testNewInstance() throws Exception {
        WrapDynaClass dynaClass = WrapDynaClass.createDynaClass(AlphaBean.class);
        DynaBean createdInstance = dynaClass.newInstance();
        Assertions.assertInstanceOf(WrapDynaBean.class, (Object)createdInstance, (String)"Object type is WrapDynaBean");
        WrapDynaBean dynaBean = (WrapDynaBean)createdInstance;
        Assertions.assertInstanceOf(AlphaBean.class, (Object)dynaBean.getInstance(), (String)"Object type is AlphaBean");
    }

    @Override
    @Test
    public void testNotSerializableException() throws Exception {
        WrapDynaBean origBean = new WrapDynaBean((Object)new TestBean());
        Integer newValue = 789;
        Assertions.assertEquals((Object)123, (Object)origBean.get("intProperty"), (String)"origBean default");
        origBean.set("intProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)origBean.get("intProperty"), (String)"origBean new value");
        Assertions.assertThrows(NotSerializableException.class, () -> this.serializeDeserialize(origBean, "First Test"));
    }

    @Test
    public void testSimpleProperties() {
        this.checkSimplePropertyAccess();
    }
}

