/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.binding;

import jakarta.xml.ws.Binding;
import org.apache.axis2.jaxws.binding.HTTPBinding;
import org.apache.axis2.jaxws.binding.SOAPBinding;
import org.apache.axis2.jaxws.description.EndpointDescription;

public class BindingUtils {
    public static Binding createBinding(EndpointDescription ed) {
        String bindingType;
        if (ed == null) {
            throw new NullPointerException("EndpointDescription is null");
        }
        String string = bindingType = ed.getServiceDescription().isServerSide() ? ed.getBindingType() : ed.getClientBindingID();
        if (BindingUtils.isSOAPBinding(bindingType)) {
            return new SOAPBinding(ed);
        }
        if (BindingUtils.isHTTPBinding(bindingType)) {
            return new HTTPBinding(ed);
        }
        return new SOAPBinding(ed);
    }

    public static boolean isSOAPBinding(String url) {
        return BindingUtils.isSOAP11Binding(url) || BindingUtils.isSOAP12Binding(url);
    }

    public static boolean isSOAP11Binding(String url) {
        return url != null && (url.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || url.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || url.equals("http://www.w3.org/2010/soapjms/") || url.equals("http://www.w3.org/2010/soapjms/?mtom=true"));
    }

    public static boolean isSOAP12Binding(String url) {
        return url != null && (url.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || url.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") || url.equals("http://www.w3.org/2010/soapjms/") || url.equals("http://www.w3.org/2010/soapjms/?mtom=true"));
    }

    public static boolean isMTOMBinding(String url) {
        return url != null && (url.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || url.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") || url.equals("http://www.w3.org/2010/soapjms/?mtom=true") || url.equals("http://www.w3.org/2010/soapjms/?mtom=true"));
    }

    public static boolean isHTTPBinding(String url) {
        return url != null && url.equals("http://www.w3.org/2004/08/wsdl/http");
    }
}

