/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.hawt.util.Strings;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationThrottler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationThrottler.class);
    private static final long CACHE_DURATION = 1L;
    private final Cache<String, Attempt> attempts;

    public AuthenticationThrottler() {
        LOG.debug("{} initialised", (Object)this.getClass().getSimpleName());
        this.attempts = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    }

    public Attempt attempt(String username) {
        LOG.debug("Attempt: {}", (Object)username);
        if (Strings.isBlank(username)) {
            return null;
        }
        return (Attempt)this.attempts.getIfPresent((Object)username);
    }

    public void increase(String username) {
        LOG.debug("Increase: {}", (Object)username);
        if (Strings.isBlank(username) || "public".equals(username)) {
            return;
        }
        Attempt attempt = (Attempt)this.attempts.get((Object)username, x$0 -> new Attempt((String)x$0));
        attempt.increase();
    }

    public void reset(String username) {
        LOG.debug("Reset: {}", (Object)username);
        if (Strings.isBlank(username)) {
            return;
        }
        this.attempts.invalidate((Object)username);
    }

    public static class Attempt {
        static final long INTERVAL = 1L;
        static final long MULTIPLIER = 2L;
        static final long MAX_BACKOFF = 86400L;
        final String username;
        private long timestamp = 0L;
        private int count = 0;

        private Attempt(String username) {
            this.username = username;
        }

        private void increase() {
            this.timestamp = System.currentTimeMillis();
            ++this.count;
        }

        private long backoff() {
            if (this.count < 3) {
                return this.timestamp;
            }
            int power = this.count - 3;
            long backoff = (long)(1.0 * Math.pow(2.0, power));
            return this.timestamp + Math.min(backoff, 86400L) * 1000L;
        }

        public long retryAfter() {
            long now = System.currentTimeMillis();
            return (this.backoff() - now) / 1000L;
        }

        public boolean isBlocked() {
            return this.retryAfter() > 0L;
        }

        public String toString() {
            return String.format("Attempt{username=%s, timestamp=%s, count=%s, retryAfter=%s}", this.username, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.timestamp)), this.count, this.retryAfter());
        }
    }
}

