/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import org.apache.camel.BeanScope;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.PredicateFactory;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.language.CSimpleExpression;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.DatasonnetExpression;
import org.apache.camel.model.language.ExchangePropertyExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.GroovyExpression;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.Hl7TerserExpression;
import org.apache.camel.model.language.JavaExpression;
import org.apache.camel.model.language.JavaScriptExpression;
import org.apache.camel.model.language.JoorExpression;
import org.apache.camel.model.language.JqExpression;
import org.apache.camel.model.language.JsonPathExpression;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.MvelExpression;
import org.apache.camel.model.language.OgnlExpression;
import org.apache.camel.model.language.PythonExpression;
import org.apache.camel.model.language.RefExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.SpELExpression;
import org.apache.camel.model.language.TokenizerExpression;
import org.apache.camel.model.language.VariableExpression;
import org.apache.camel.model.language.WasmExpression;
import org.apache.camel.model.language.XMLTokenizerExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.model.language.XQueryExpression;
import org.apache.camel.spi.ExpressionFactoryAware;
import org.apache.camel.spi.PredicateFactoryAware;
import org.apache.camel.support.builder.Namespaces;

public class ExpressionClauseSupport<T>
implements ExpressionFactoryAware,
PredicateFactoryAware {
    private final T result;
    private Expression expressionValue;
    private ExpressionFactory expressionType;
    private PredicateFactory predicateType;

    public ExpressionClauseSupport(T result) {
        this.result = result;
    }

    public T expression(Expression expression) {
        if (!this.tryExpressionOrPredicate(expression)) {
            this.setExpressionValue(expression);
        }
        return this.result;
    }

    private boolean tryExpressionOrPredicate(Expression expression) {
        boolean match = false;
        if (expression instanceof ExpressionFactory) {
            ExpressionFactory expressionFactory = (ExpressionFactory)expression;
            this.setExpressionType(expressionFactory);
            match = true;
        }
        if (expression instanceof PredicateFactory) {
            PredicateFactory predicateFactory = (PredicateFactory)expression;
            this.setPredicateType(predicateFactory);
            match = true;
        }
        return match;
    }

    public T language(ExpressionFactory expression) {
        this.setExpressionType(expression);
        return this.result;
    }

    public T constant(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return this.expression(new ConstantExpression(str));
        }
        ConstantExpression ce = new ConstantExpression();
        ce.setExpressionType(new ExpressionDefinition(ExpressionBuilder.constantExpression((Object)value)));
        ce.setExpression(String.valueOf(value));
        return this.expression(ce);
    }

    public T constant(String value, Class<?> resultType) {
        ConstantExpression exp = new ConstantExpression(value);
        exp.setResultType(resultType);
        return this.expression(exp);
    }

    public T constant(Object value, boolean trim) {
        if (value instanceof String) {
            String str = (String)value;
            ConstantExpression ce = new ConstantExpression(str);
            ce.setTrim(trim ? "true" : "false");
            return this.expression(ce);
        }
        ConstantExpression ce = new ConstantExpression();
        ce.setExpressionType(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression((Object)value)));
        ce.setExpression(String.valueOf(value));
        ce.setTrim(trim ? "true" : "false");
        return this.expression(ce);
    }

    public T exchange() {
        return this.expression(ExpressionBuilder.exchangeExpression());
    }

    public T inMessage() {
        return this.expression(ExpressionBuilder.inMessageExpression());
    }

    public T body() {
        return this.expression(new SimpleExpression("${body}"));
    }

    public T body(Class<?> expectedType) {
        return this.expression(ExpressionBuilder.bodyExpression(expectedType));
    }

    public T header(String name) {
        return this.expression(new HeaderExpression(name));
    }

    public T headers() {
        return this.expression(ExpressionBuilder.headersExpression());
    }

    public T exchangePattern() {
        return this.expression(ExpressionBuilder.exchangePatternExpression());
    }

    public T exchangeProperty(String name) {
        return this.expression(new ExchangePropertyExpression(name));
    }

    public T exchangeProperties() {
        return this.expression(ExpressionBuilder.exchangePropertiesExpression());
    }

    public T variable(String name) {
        return this.expression(new VariableExpression(name));
    }

    public T method(String ref) {
        return this.expression(new MethodCallExpression(ref));
    }

    public T method(Object instance) {
        return this.expression(new MethodCallExpression(instance));
    }

    public T method(Class<?> beanType) {
        return this.expression(new MethodCallExpression(beanType));
    }

    public T method(String ref, String method) {
        return this.expression(new MethodCallExpression(ref, method));
    }

    public T method(String ref, BeanScope scope) {
        MethodCallExpression exp = new MethodCallExpression(ref);
        exp.setScope(scope.name());
        return this.expression(exp);
    }

    public T method(String ref, String method, BeanScope scope) {
        MethodCallExpression exp = new MethodCallExpression(ref, method);
        exp.setScope(scope.name());
        return this.expression(exp);
    }

    public T method(Object instance, String method) {
        return this.expression(new MethodCallExpression(instance, method));
    }

    public T method(Class<?> beanType, String method) {
        return this.expression(new MethodCallExpression(beanType, method));
    }

    public T method(Class<?> beanType, BeanScope scope) {
        MethodCallExpression exp = new MethodCallExpression(beanType);
        exp.setScope(scope.name());
        return this.expression(exp);
    }

    public T method(Class<?> beanType, String method, BeanScope scope) {
        MethodCallExpression exp = new MethodCallExpression(beanType, method);
        exp.setScope(scope.name());
        return this.expression(exp);
    }

    public T groovy(String text) {
        return this.expression(new GroovyExpression(text));
    }

    public T js(String text) {
        return this.expression(new JavaScriptExpression(text));
    }

    public T js(String text, Class<?> resultType) {
        JavaScriptExpression exp = new JavaScriptExpression(text);
        exp.setResultType(resultType);
        return this.expression(exp);
    }

    @Deprecated(since="4.3.0")
    public T joor(String text) {
        return this.expression(new JoorExpression(text));
    }

    @Deprecated(since="4.3.0")
    public T joor(String text, Class<?> resultType) {
        JoorExpression exp = new JoorExpression(text);
        exp.setResultType(resultType);
        return this.expression(exp);
    }

    public T java(String text) {
        return this.expression(new JavaExpression(text));
    }

    public T java(String text, Class<?> resultType) {
        JavaExpression exp = new JavaExpression(text);
        exp.setResultType(resultType);
        return this.expression(exp);
    }

    public T jq(String text) {
        return this.expression(new JqExpression(text));
    }

    public T jq(String text, Class<?> resultType) {
        JqExpression exp = new JqExpression(text);
        exp.setResultType(resultType);
        return this.expression(exp);
    }

    public T datasonnet(String text) {
        return this.expression(new DatasonnetExpression(text));
    }

    public T jsonpath(String text) {
        return this.jsonpath(text, false);
    }

    public T jsonpath(String text, boolean suppressExceptions) {
        JsonPathExpression expression = new JsonPathExpression(text);
        if (suppressExceptions) {
            expression.setSuppressExceptions("true");
        }
        return this.expression(expression);
    }

    public T jsonpath(String text, boolean suppressExceptions, boolean allowSimple) {
        JsonPathExpression expression = new JsonPathExpression(text);
        if (suppressExceptions) {
            expression.setSuppressExceptions("true");
        }
        if (allowSimple) {
            expression.setAllowSimple("true");
        }
        return this.expression(expression);
    }

    public T jsonpath(String text, Class<?> resultType) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setResultType(resultType);
        this.expression(expression);
        return this.result;
    }

    public T jsonpath(String text, boolean suppressExceptions, Class<?> resultType) {
        JsonPathExpression expression = new JsonPathExpression(text);
        if (suppressExceptions) {
            expression.setSuppressExceptions("true");
        }
        expression.setResultType(resultType);
        this.expression(expression);
        return this.result;
    }

    public T jsonpath(String text, boolean suppressExceptions, boolean allowSimple, Class<?> resultType) {
        JsonPathExpression expression = new JsonPathExpression(text);
        if (suppressExceptions) {
            expression.setSuppressExceptions("true");
        }
        if (allowSimple) {
            expression.setAllowSimple("true");
        }
        expression.setResultType(resultType);
        this.expression(expression);
        return this.result;
    }

    public T jsonpathWriteAsString(String text) {
        return this.jsonpathWriteAsString(text, false);
    }

    public T jsonpathWriteAsString(String text, Class<?> resultType) {
        return this.jsonpathWriteAsString(text, false, resultType);
    }

    public T jsonpathWriteAsString(String text, boolean suppressExceptions) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setWriteAsString("true");
        if (suppressExceptions) {
            expression.setSuppressExceptions("true");
        }
        return this.expression(expression);
    }

    public T jsonpathWriteAsString(String text, boolean suppressExceptions, Class<?> resultType) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setWriteAsString("true");
        if (suppressExceptions) {
            expression.setSuppressExceptions("true");
        }
        expression.setResultType(resultType);
        return this.expression(expression);
    }

    public T jsonpathWriteAsString(String text, boolean suppressExceptions, boolean allowSimple) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setWriteAsString("true");
        if (suppressExceptions) {
            expression.setSuppressExceptions("true");
        }
        if (allowSimple) {
            expression.setAllowSimple("true");
        }
        return this.expression(expression);
    }

    public T jsonpathUnpack(String text, Class<?> resultType) {
        JsonPathExpression expression = new JsonPathExpression(text);
        expression.setUnpackArray("true");
        expression.setResultType(resultType);
        return this.expression(expression);
    }

    public T ognl(String text) {
        return this.expression(new OgnlExpression(text));
    }

    public T python(String text) {
        return this.expression(new PythonExpression(text));
    }

    public T python(String text, Class<?> resultType) {
        PythonExpression exp = new PythonExpression(text);
        exp.setResultType(resultType);
        return this.expression(exp);
    }

    public T mvel(String text) {
        return this.expression(new MvelExpression(text));
    }

    public T ref(String ref) {
        return this.expression(new RefExpression(ref));
    }

    public T spel(String text) {
        return this.expression(new SpELExpression(text));
    }

    public T csimple(String text) {
        return this.expression(new CSimpleExpression(text));
    }

    public T csimple(String text, Class<?> resultType) {
        CSimpleExpression exp = new CSimpleExpression(text);
        exp.setResultType(resultType);
        return this.expression(exp);
    }

    public T simple(String text) {
        return this.expression(new SimpleExpression(text));
    }

    public T simple(String text, Class<?> resultType) {
        SimpleExpression expression = new SimpleExpression(text);
        expression.setResultType(resultType);
        this.expression(expression);
        return this.result;
    }

    public T hl7terser(String text) {
        return this.expression(new Hl7TerserExpression(text));
    }

    public T tokenize(String token) {
        return this.tokenize(token, false);
    }

    public T tokenize(String token, int group) {
        return this.tokenize(token, false, group);
    }

    public T tokenize(String token, int group, boolean skipFirst) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(token);
        expression.setSkipFirst(Boolean.toString(skipFirst));
        expression.setGroup(Integer.toString(group));
        this.expression(expression);
        return this.result;
    }

    public T tokenize(String token, boolean regex) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(token);
        expression.setRegex(Boolean.toString(regex));
        this.expression(expression);
        return this.result;
    }

    public T tokenize(String token, boolean regex, int group) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(token);
        expression.setRegex(Boolean.toString(regex));
        expression.setGroup(Integer.toString(group));
        this.expression(expression);
        return this.result;
    }

    public T tokenize(String token, boolean regex, int group, boolean skipFirst) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(token);
        expression.setRegex(Boolean.toString(regex));
        expression.setSkipFirst(Boolean.toString(skipFirst));
        expression.setGroup(Integer.toString(group));
        expression.setSkipFirst(Boolean.toString(skipFirst));
        this.expression(expression);
        return this.result;
    }

    public T tokenize(String token, boolean regex, String group, boolean skipFirst) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(token);
        expression.setRegex(Boolean.toString(regex));
        expression.setSkipFirst(Boolean.toString(skipFirst));
        expression.setGroup(group);
        expression.setSkipFirst(Boolean.toString(skipFirst));
        this.expression(expression);
        return this.result;
    }

    public T tokenizePair(String startToken, String endToken, boolean includeTokens) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(startToken);
        expression.setEndToken(endToken);
        expression.setIncludeTokens(Boolean.toString(includeTokens));
        this.expression(expression);
        return this.result;
    }

    public T tokenizeXMLPair(String tagName, String inheritNamespaceTagName, int group) {
        return this.tokenizeXMLPair(tagName, inheritNamespaceTagName, Integer.toString(group));
    }

    public T tokenizeXMLPair(String tagName, String inheritNamespaceTagName, String group) {
        TokenizerExpression expression = new TokenizerExpression();
        expression.setToken(tagName);
        expression.setInheritNamespaceTagName(inheritNamespaceTagName);
        expression.setXml(Boolean.toString(true));
        expression.setGroup(group);
        this.expression(expression);
        return this.result;
    }

    public T xtokenize(String path, char mode, Namespaces namespaces, int group) {
        XMLTokenizerExpression expression = new XMLTokenizerExpression(path);
        expression.setMode(Character.toString(mode));
        expression.setNamespaces(namespaces.getNamespaces());
        if (group > 0) {
            expression.setGroup(Integer.toString(group));
        }
        this.expression(expression);
        return this.result;
    }

    public T xpath(String text) {
        return this.expression(new XPathExpression(text));
    }

    public T xpath(String text, Class<?> resultType) {
        XPathExpression expression = new XPathExpression(text);
        expression.setResultType(resultType);
        this.expression(expression);
        return this.result;
    }

    public T xpath(String text, Class<?> resultType, Namespaces namespaces) {
        return this.xpath(text, resultType, namespaces.getNamespaces());
    }

    public T xpath(String text, Class<?> resultType, Map<String, String> namespaces) {
        XPathExpression expression = new XPathExpression(text);
        expression.setResultType(resultType);
        expression.setNamespaces(namespaces);
        this.expression(expression);
        return this.result;
    }

    public T xpath(String text, Namespaces namespaces) {
        return this.xpath(text, namespaces.getNamespaces());
    }

    public T xpath(String text, Map<String, String> namespaces) {
        XPathExpression expression = new XPathExpression(text);
        expression.setNamespaces(namespaces);
        this.expression(expression);
        return this.result;
    }

    public T xquery(String text) {
        return this.expression(new XQueryExpression(text));
    }

    public T xquery(String text, Class<?> resultType) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setResultType(resultType);
        this.expression(expression);
        return this.result;
    }

    public T xquery(String text, Class<?> resultType, Namespaces namespaces) {
        return this.xquery(text, resultType, namespaces.getNamespaces());
    }

    public T xquery(String text, Class<?> resultType, Map<String, String> namespaces) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setResultType(resultType);
        expression.setNamespaces(namespaces);
        this.expression(expression);
        return this.result;
    }

    public T xquery(String text, Namespaces namespaces) {
        return this.xquery(text, namespaces.getNamespaces());
    }

    public T xquery(String text, Map<String, String> namespaces) {
        XQueryExpression expression = new XQueryExpression(text);
        expression.setNamespaces(namespaces);
        this.expression(expression);
        return this.result;
    }

    public T wasm(String functionName, String module) {
        return this.expression(new WasmExpression(functionName, module));
    }

    public T wasm(String functionName, String module, Class<?> resultType) {
        WasmExpression exp = new WasmExpression(functionName, module);
        exp.setResultType(resultType);
        return this.expression(exp);
    }

    public T language(String language, String expression) {
        LanguageExpression exp = new LanguageExpression(language, expression);
        this.expression(exp);
        return this.result;
    }

    public Expression getExpressionValue() {
        return this.expressionValue;
    }

    public void setExpressionValue(Expression expressionValue) {
        this.expressionValue = expressionValue;
    }

    public ExpressionFactory getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(ExpressionFactory expressionType) {
        this.expressionType = expressionType;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionType;
    }

    public PredicateFactory getPredicateType() {
        return this.predicateType;
    }

    public void setPredicateType(PredicateFactory predicateType) {
        this.predicateType = predicateType;
    }

    public PredicateFactory getPredicateFactory() {
        return this.predicateType;
    }

    protected Expression createExpression(CamelContext camelContext) {
        if (this.getExpressionValue() == null) {
            if (this.getExpressionType() != null) {
                this.setExpressionValue(this.getExpressionType().createExpression(camelContext));
            } else {
                throw new IllegalStateException("No expression value configured");
            }
        }
        return this.getExpressionValue();
    }
}

